/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.mpEdit;

import java.awt.*;
import java.util.Vector;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.12 $
 */
public class PrintMan extends Thread
{

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private PrintJob pjob;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Vector spool;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Font font;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private TextFrame parent;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String jobName;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private int tabsize;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final int PRINT_PROGRESS = 10000;


   /**
    * Constructor for class PrintMan
    *
    * @param p       No description provided
    * @param docMan  No description provided
    * @param n       No description provided
    * @param f       No description provided
    * @param t       No description provided
    */
   public PrintMan (TextFrame p, DocMan docMan, String n, Font f, int t)
   {
      int i;
      int
         max;
      int
         part;
      int
         tens;

      parent = p;
      jobName = n;
      font = f;
      tabsize = t;

      max = docMan.getLineCount();
      spool = new Vector (max);
      tens = max / 10;
      part = 0;

      Progress spoolProgress = null;

      if (max > PRINT_PROGRESS)
      {
         spoolProgress = new Progress (parent, "Saving print copy ... ");
         spoolProgress.show();
      }

      for (i = 0; i < max; i++)
      {
         spool.addElement (docMan.getLine (i));
         if (max > PRINT_PROGRESS)
         {
            part++;
         }
         if (part > tens)
         {
            spoolProgress.update ( (100 * i / max));
            part = 0;
         }
      }

      if (spoolProgress != null)
      {
         spoolProgress.dispose();
      }
   }


   /**
    * Main processing method for the PrintMan object
    */
   public void run()
   {
      pjob = parent.getToolkit().getPrintJob (parent, jobName, null);

      if (pjob == null)
      {
         return;
      }

      Graphics pg = pjob.getGraphics();

      if (pg != null)
      {
         String nextLine;
         int pageHeight = pjob.getPageDimension().height;
         pg.setFont (font);
         FontMetrics fm = pg.getFontMetrics (font);
         int fontHeight = fm.getHeight();
         int fontDescent = fm.getDescent();
         int curHeight = 0;

         for (int i = 0; i < spool.size(); i++)
         {
            curHeight += fontHeight;
            if (curHeight > pageHeight)
            {
               pg.dispose();
               pg = pjob.getGraphics();
               if (pg == null)
               {
                  return;
               }
               pg.setFont (font);
               curHeight = fontHeight;
            }
            nextLine = detabbed ((String) spool.elementAt (i), tabsize);
            pg.drawString (nextLine, 0, curHeight - fontDescent);
         }

         pg.dispose();
      }

      pjob.end();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param s        No description provided
    * @param tabSize  No description provided
    * @return         No description provided
    */
   private String detabbed (String s, int tabSize)
   {
      if (s.indexOf ('\t') < 0)
      {
         return s;
      }

      char c;
      String t = "";
      int j = 0;
      int tabs;
      int max = s.length();

      for (int i = 0; i < max; i++)
      {
         c = s.charAt (i);
         if (c == '\t')
         {
            tabs = tabSize -  (j % tabSize);
            j += tabs;
            while (tabs-- > 0)
            {
               t = t + ' ';
            }
         }
         else
         {
            t = t + c;
            j++;
         }
      }

      return t;
   }

}

/*
 * $Log: PrintMan.java,v $
 * Revision 1.12  2004/10/22 16:41:40  lowende
 * Deprecated warnings removed. Other compile warnings removed.
 *
 */
