/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.mpEdit;

import java.awt.*;
import java.awt.event.*;
import java.util.ResourceBundle;

import javax.swing.*;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.13 $
 */
class NotFoundDialog extends JDialog implements WindowListener,
   ActionListener
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JButton okButton;


   /**
    * Constructor for class NotFoundDialog
    *
    * @param textFrame  No description provided
    * @param strings    No description provided
    */
   public NotFoundDialog (TextFrame textFrame, ResourceBundle strings)
   {
      super (textFrame, "", true);

      JPanel north = new JPanel();
      north.add (new JLabel (strings.getString ("DialogNotFound")));
      getContentPane().add ("North", north);

      okButton = new JButton (strings.getString ("ButtonOk"));
      okButton.addActionListener (this);
      JPanel south = new JPanel();
      south.add (okButton);
      getContentPane().add ("South", south);

      pack();
      Dimension size = getSize();
      setLocation (textFrame.getPlace (size));

      addWindowListener (this);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public void windowDeiconified (WindowEvent event) { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public void windowIconified (WindowEvent event) { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public void windowActivated (WindowEvent event) { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public void windowDeactivated (WindowEvent event) { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public void windowOpened (WindowEvent event) { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public void windowClosed (WindowEvent event) { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public void windowClosing (WindowEvent event)
   {
      dispose();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param evt  No description provided
    */
   public void actionPerformed (ActionEvent evt)
   {
      if (evt.getSource() == okButton)
      {
         dispose();
      }
   }

}

/*
 * $Log: NotFoundDialog.java,v $
 * Revision 1.13  2004/10/20 17:50:01  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
