/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.mpEdit;

import java.io.InputStream;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.10 $
 */
public class ManifestItem
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String keys[];
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String values[];
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private int nkeys;


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param k  No description provided
    * @return   No description provided
    */
   public String findValue (String k)
   {
      for (int i = 0; i < nkeys; i++)
      {
         if (k.equalsIgnoreCase (keys[i]))
         {
            return values[i];
         }
      }

      return null;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private void grow()
   {
      if (keys == null || nkeys >= keys.length)
      {
         String[] nk = new String[nkeys + 4];
         String[] nv = new String[nkeys + 4];
         if (keys != null)
         {
            System.arraycopy (keys, 0, nk, 0, nkeys);
         }
         if (values != null)
         {
            System.arraycopy (values, 0, nv, 0, nkeys);
         }
         keys = nk;
         values = nv;
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param k  No description provided
    * @param v  No description provided
    */
   public void add (String k, String v)
   {
      grow();
      keys[nkeys] = k;
      values[nkeys] = v;
      nkeys++;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param is                    No description provided
    * @return                      No description provided
    * @throws java.io.IOException  Exception description not provided
    */
   public boolean read (InputStream is) throws java.io.IOException
   {
      boolean eof = false;

      nkeys = 0;

      if (is == null)
      {
         return false;
      }

      char s[] = new char[10];
      int firstc = is.read();
      if (firstc < 0)
      {
         eof = true;
      }

      while (firstc != '\n' && firstc != '\r' && firstc >= 0)
      {
         int len = 0;
         int keyend = -1;
         int c;
         boolean inKey = firstc > ' ';
         s[len++] = (char) firstc;
         parseloop :
         {
            while ( (c = is.read()) >= 0)
            {
               if (c < 0)
               {
                  eof = true;
               }
               switch (c)
               {
                  case ':':
                     if (inKey && len > 0)
                     {
                        keyend = len;
                     }
                     inKey = false;
                     break;
                  case '\t':
                     c = ' ';
                  case ' ':
                     inKey = false;
                     break;
                  case '\r':
                  case '\n':
                     firstc = is.read();
                     if (firstc < 0)
                     {
                        eof = true;
                     }
                     if (c == '\r' && firstc == '\n')
                     {
                        firstc = is.read();
                        if (firstc == '\r')
                        {
                           firstc = is.read();
                        }
                        if (firstc < 0)
                        {
                           eof = true;
                        }
                     }
                     if (firstc == '\n' || firstc == '\r' || firstc > ' ')
                     {
                        break parseloop;
                     }
                     /*
                      *  continuation
                      */
                     c = ' ';
                     break;
               }
               if (len >= s.length)
               {
                  char ns[] = new char[s.length * 2];
                  System.arraycopy (s, 0, ns, 0, len);
                  s = ns;
               }
               s[len++] = (char) c;
            }
            firstc = -1;
         }
         while (len > 0 && s[len - 1] <= ' ')
         {
            len--;
         }
         String k;
         if (keyend <= 0)
         {
            k = null;
            keyend = 0;
         }
         else
         {
            k = String.copyValueOf (s, 0, keyend);
            if (keyend < len && s[keyend] == ':')
            {
               keyend++;
            }
            while (keyend < len && s[keyend] <= ' ')
            {
               keyend++;
            }
         }
         String v;
         if (keyend >= len)
         {
            v = "";
         }
         else
         {
            v = String.copyValueOf (s, keyend, len - keyend);
         }
         add (k, v);
      }

      return !eof;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public String toString()
   {
      String result = super.toString();

      for (int i = 0; i < keys.length; i++)
      {
         result += "{" + keys[i] + ": " + values[i] + "}\n";
      }

      return result;
   }
}

/*
 * $Log: ManifestItem.java,v $
 * Revision 1.10  2004/10/20 17:50:01  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
