/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.mpEdit;

import java.util.Vector;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.11 $
 */
public class LineMan
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Vector lines;


   /**
    * Constructor for class LineMan
    */
   public LineMan()
   {
      lines = new Vector (100, 100);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param aSize   No description provided
    * @param aDelta  No description provided
    */
   public synchronized void freshVectors (int aSize, int aDelta)
   {
      lines = new Vector (aSize, aDelta);
   }


   /**
    * Access method for an one to n association.
    *
    * @param s  The object added.
    */
   public synchronized void addElement (String s)
   {
      lines.addElement (new LineInfo (s));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param s  No description provided
    * @param i  No description provided
    */
   public synchronized void insertElementAt (String s, int i)
   {
      lines.insertElementAt (new LineInfo (s), i);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public synchronized void removeAllElements()
   {
      lines.removeAllElements();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param i  No description provided
    */
   public synchronized void removeElementAt (int i)
   {
      lines.removeElementAt (i);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public synchronized int size()
   {
      return lines.size();
   }


   /**
    * Sets the string attribute of the LineMan object
    *
    * @param s  The new string value
    * @param i  The new string value
    */
   public synchronized void setString (String s, int i)
   {
      LineInfo li = (LineInfo) lines.elementAt (i);
      li.data = s;
   }


   /**
    * Get the string attribute of the LineMan object
    *
    * @param i  No description provided
    * @return   The string value
    */
   public synchronized String getString (int i)
   {
      LineInfo li = (LineInfo) lines.elementAt (i);
      return li.data;
   }


   /**
    * Get the lineInfo attribute of the LineMan object
    *
    * @param i  No description provided
    * @return   The lineInfo value
    */
   public synchronized LineInfo getLineInfo (int i)
   {
      return (LineInfo) lines.elementAt (i);
   }


   /**
    * Sets the lineInfo attribute of the LineMan object
    *
    * @param li  The new lineInfo value
    * @param i   The new lineInfo value
    */
   public synchronized void setLineInfo (LineInfo li, int i)
   {
      lines.setElementAt (li, i);
   }
}

/*
 * $Log: LineMan.java,v $
 * Revision 1.11  2004/10/20 17:50:01  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
