/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.mpEdit;



/**
 * This is doubly a "key object". It holds a keystroke and serves as a hashtable key for the
 * keystroke to action-string mapping
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.9 $
 */
class KeyObject
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public int key;


   /**
    * Constructor for class KeyObject
    *
    * @param m  No description provided
    * @param k  No description provided
    */
   public KeyObject (int m, int k)
   {
      key =  (k & 0xFFFF) |  (m & 0x7FFF) << 16;
   }


   /**
    * Get the mod attribute of the KeyObject object
    *
    * @return   The mod value
    */
   public int getMod()
   {
      return  (key & 0x7FFF0000) >> 16;
   }


   /**
    * Get the code attribute of the KeyObject object
    *
    * @return   The code value
    */
   public int getCode()
   {
      return  (key & 0x0000FFFF);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public int hashCode()
   {
      return key;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param obj  No description provided
    * @return     No description provided
    */
   public boolean equals (Object obj)
   {
      return obj instanceof KeyObject &&  ((KeyObject) obj).key == this.key;
   }
}

/*
 * $Log: KeyObject.java,v $
 * Revision 1.9  2004/10/20 17:50:01  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
