/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.mpEdit;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.10 $
 */
abstract class KeyMap
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected Hashtable keyhash;


   /**
    * Sets the keyAction attribute of the KeyMap object
    *
    * @param action     The new keyAction value
    * @param modifiers  The new keyAction value
    * @param key        The new keyAction value
    */
   public void setKeyAction (String action, int modifiers, int key)
   {
      keyhash.put (new KeyObject (modifiers, key), action);
   }


   /**
    * Get the action attribute of the KeyMap object
    *
    * @param modifiers  No description provided
    * @param key        No description provided
    * @return           The action value
    */
   public String getAction (int modifiers, int key)
   {
      return (String) keyhash.get (new KeyObject (modifiers, key));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Hashtable cloneKeyTable()
   {
      return (Hashtable) keyhash.clone();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param aWriter  No description provided
    */
   public void writeTo (Writer aWriter)
   {
      PrintWriter pw = new PrintWriter (aWriter);
      pw.println ("// Keyboard definition data");
      pw.println ("// <modifier> <keycode> <action>");
      synchronized (keyhash)
      {
         Enumeration keys = keyhash.keys();
         Enumeration idnames = keyhash.elements();
         KeyObject keyVal;
         while (keys.hasMoreElements())
         {
            keyVal = (KeyObject) keys.nextElement();
            pw.println ("" + keyVal.getMod() + ' ' +
               keyVal.getCode() + '\t' +
               (String) idnames.nextElement());
         }
      }
      pw.println (-1);
      pw.flush();
   }

}

/*
 * $Log: KeyMap.java,v $
 * Revision 1.10  2004/10/20 17:50:01  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
