/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.mpEdit;

import java.util.Stack;

import org.apache.log4j.Logger;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: mksoft $
 * @version   $Revision: 1.10.2.1 $
 */
public class HiliteLife extends Hilite
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (HiliteLife.class);

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Stack hideLevel;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static boolean debug = true;


   /**
    * Constructor for class HiliteLife
    *
    * @param l  No description provided
    * @param t  No description provided
    * @param a  No description provided
    */
   public HiliteLife (LineMan l, int t, boolean a)
   {
      super (l, t, a);

      hideLevel = new Stack();

      String temp[] = new String[]
         {
         "abstract",
         "boolean",
         "break",
         "byte",
         "byvalue",
         "case",
         "catch",
         "char",
         "class",
         "const",
         "continue",
         "default",
         "do",
         "double",
         "else",
         "extends",
         "false",
         "final",
         "finally",
         "float",
         "for",
         "goto",
         "if",
         "implements",
         "import",
         "instanceof",
         "int",
         "interface",
         "long",
         "native",
         "new",
         "null",
         "package",
         "private",
         "protected",
         "public",
         "return",
         "short",
         "static",
         "super",
         "switch",
         "synchronized",
         "this",
         "threadsafe",
         "throw",
         "transient",
         "true",
         "try",
         "void",
         "while"
         };

      int i;

      int
         max;

      max = temp.length;

      keys = new char[max][];

      for (i = 0; i < max; i++)
      {
         keys[i] = temp[i].toCharArray();
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param i  No description provided
    */
   protected void scanLine (int i)
   {
      char c;
      char  // this is the character at the index.

         d;
      char  // this is the character before c

         e; // this is the character before d

      boolean inword;
      boolean incharliteral;
      int pos;
      int start;
      int max;

      max = fillBuffer (i); //Fills buffer with line i, length of buffer is max

      pos = -1;
      inword = incharliteral = false;
      start = 0;
      c = d = 0;
      keyCt = 0; //contains the position in the LineMan keyword handling arrays

      if (!hideLevel.empty())
      {
         keyStarts[keyCt] = 0;
         keyTypes[keyCt] = (byte)  (HIDE +  ((Integer) hideLevel.peek()).byteValue());
         keyEnds[keyCt] = max;
         keyCt++;
      }

      if (inComment || inLiteral)
      { //If the last line ended with a comment or a literal...

         keyStarts[keyCt] = 0; //...the beginning of this line is quite a key
      }

      while (++pos <= max)
      { //scan the whole buffer

         e = d; //swap positions
         d = c;

         if (pos < max)
         {
            c = buffer[pos];
         } //Fill c with the current char from buffer
         else
         {
            c = 0;
         } //reached end of line

         if ( (c == '+') &&  (d == '/') &&  (e == '/'))
         { //check if we have reached a HIDE tag '//>#' # = hide level

            byte level = 0;

            keyStarts[keyCt] = pos - 2;
            keyEnds[keyCt] = max;

            try
            {
               level =  (new Integer (new String (buffer, pos + 1, max - pos - 1))).byteValue(); //get hide level
            }
            catch (NumberFormatException nfe)
            {
               if (debug)
               {
                  if (log.isInfoEnabled())
                  {
                     log.info ("mpEDIT: Illegal hide level in line " + i);
                  }
               }
               break; //if # is not a legal hide level, ignore hide tag
            }

            keyTypes[keyCt] = (byte)  (HIDE + level);
            hideLevel.push (new Integer (level));
            keyCt++;
         }

         if ( (debug) &&  (c == '-') &&  (d == '/') &&  (e == '/') && hideLevel.empty())
         {
            if (log.isInfoEnabled())
            {
               log.info ("mpEDIT: Tried to close a non existing hide level in line " + i);
            }
         }

         if ( (c == '-') &&  (d == '/') &&  (e == '/') && !hideLevel.empty())
         {
            hideLevel.pop(); //remove last entry
         }

         if ( (c == '/') &&  (d == '*') &&  (e != '/') && inComment && !inLiteral)
         { //check if we are leaving a comment '*/'

            keyEnds[keyCt] = pos + 1; //set end position of the keyword
            keyTypes[keyCt] = COMMENT; //set type of keyword
            keyCt++; //increase position in the keyword handling arrays
            inComment = false; //set inComment Flag to false, this works like a carry flag for the next line, too
            continue; //continue with while
         }

         if ( (c == '*') &&  (d == '/') && ! (inComment || inLiteral))
         { //check if we have reached a starting comment '/*'

            keyStarts[keyCt] = pos - 1;
            inComment = true;
            continue;
         }

         if (inComment)
         { //nothing to do if we are within a comment
            continue;
         }

         //         if ((c == '"') && (d != '\\') && (d != '\''))
         if ( (c == '"') &&  (d != '\\'))
         { //check for a literal "a Literal"

            if (!inLiteral)
            { //starting literal

               inLiteral = true;
               keyStarts[keyCt] = pos;
            }
            else
            { //ending literal

               inLiteral = false;
               keyEnds[keyCt] = pos + 1;
               keyTypes[keyCt] = QUOTE;
               keyCt++;
            }
            inword = false; //not a keyword
         }

         if (inLiteral)
         { //nothing to do...
            continue;
         }

         if ( (c == '\'') &&  ( (d != '\"') ||  (d != '\\') ||  ( (d == '\\') &&  (e == '\\'))))
         { //check if a character literal starts here 'a character literal'

            if (!incharliteral)
            { //starting literal

               incharliteral = true;
               keyStarts[keyCt] = pos;
            }
            else
            { //ending literal

               incharliteral = false;
               keyEnds[keyCt] = pos + 1;
               keyTypes[keyCt] = QUOTE;
               keyCt++;
            }
            inword = false;
         }

         if (incharliteral)
         { //nothing to do...
            continue;
         }

         if ( ( (c >= 'a') &&  (c <= 'z')) ||  (c == '_'))
         { //check if we found something that starts like a keyword...

            if (!inword &&  ( (d < 'A') ||  (d > 'Z')) &&  ( (d < 'a') ||  (d > 'z')))
            { //... and we are not within a keyword

               keyStarts[keyCt] = start = pos; //set keyword start
               inword = true;
            }

            continue;
         }
         else
         {
            if (inword)
            {
               if ( (c < 'A') ||  (c > 'Z'))
               { //reached the end of the keyword

                  if (matchKeys (start, pos))
                  { //check if the expression between start and pos is in keys[]

                     keyEnds[keyCt] = pos;
                     keyTypes[keyCt] = KEYWORD;
                     keyCt++;
                  }
               }
               inword = false;
               continue;
            }
         }

         if ( (d == '/') &&  (e == '/'))
         { //check if this is a comment '//'

            keyStarts[keyCt] = pos - 2;
            keyEnds[keyCt] = max;
            keyTypes[keyCt] = COMMENT;
            keyCt++;
            pos = max; // bail, we don't want any more parsing on this line
         }

      }

      if (inComment)
      {
         keyEnds[keyCt] = max;
         keyTypes[keyCt] = COMMENT;
         keyCt++;
      }

      if (inLiteral)
      {
         keyEnds[keyCt] = max;
         keyTypes[keyCt] = QUOTE;
         keyCt++;
      }

      //Finally save all information in LineInfo

      LineInfo hi = lines.getLineInfo (i);

      hi.inComment = inComment;
      hi.inLiteral = inLiteral;
      hi.keyCt = keyCt;
      hi.keyStarts = new int[keyCt];
      hi.keyEnds = new int[keyCt];
      hi.keyTypes = new byte[keyCt];

      for (int j = 0; j < keyCt; j++)
      {
         hi.keyStarts[j] = keyStarts[j];
         hi.keyEnds[j] = keyEnds[j];
         hi.keyTypes[j] = keyTypes[j];
      }
   }


   /**
    * Get the hideLevelEmpty attribute of the HiliteLife object
    *
    * @return   The hideLevelEmpty value
    */
   public boolean isHideLevelEmpty()
   {
      return hideLevel.empty();
   }
}

/*
 * $Log: HiliteLife.java,v $
 * Revision 1.10.2.1  2005/09/30 18:57:14  mksoft
 * replacing many System.out.println with if (log.isInfoEnabled()) log.info ()
 *
 */
