/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.mpEdit;

import java.awt.*;
import java.awt.event.*;
import java.util.ResourceBundle;

import javax.swing.*;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.14.2.1 $
 */
class GotoDialog extends JDialog implements WindowListener,
   ActionListener,
   KeyListener
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JButton gbutton;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JButton cbutton;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private TextFrame textFrame;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JTextField line;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private ResourceBundle strings;


   /**
    * Constructor for class GotoDialog
    *
    * @param tf     No description provided
    * @param tm     No description provided
    * @param str    No description provided
    * @param title  No description provided
    */
   public GotoDialog (TextFrame tf, TextMenu tm, ResourceBundle str, String title)
   {
      super (tf, title, false);

      setBackground (Color.lightGray);

      textFrame = tf;
      strings = str;

      JPanel p1 = new JPanel();
      p1.add (new JLabel (strings.getString ("PromptGoto")));
      line = new JTextField (String.valueOf (textFrame.getCanvas().getLine()), 10);
      line.requestFocus();
      line.selectAll();
      p1.add (line);
      getContentPane().add ("North", p1);

      JPanel p2 = new JPanel();
      gbutton = new JButton (strings.getString ("ButtonGoto"));
      gbutton.addActionListener (this);
      p2.add (gbutton);
      cbutton = new JButton (strings.getString ("ButtonClose"));
      cbutton.addActionListener (this);
      p2.add (cbutton);
      getContentPane().add ("South", p2);

      pack();
      Dimension size = getPreferredSize();
      size.width += 20;
      setSize (size);
      setLocation (textFrame.getPlace (size));

      addWindowListener (this);
      line.addKeyListener (this);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private void executeGoto()
   {
      try
      {
         int l = Integer.valueOf (line.getText()).intValue();
         textFrame.getCanvas().Goto (l);
      }
      catch (NumberFormatException e)
      {
         /*
          *  ignore
          */
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public void windowDeiconified (WindowEvent event) { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public void windowIconified (WindowEvent event) { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public void windowActivated (WindowEvent event) { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public void windowDeactivated (WindowEvent event) { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public void windowOpened (WindowEvent event) { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public void windowClosed (WindowEvent event) { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public void windowClosing (WindowEvent event)
   {
      dispose();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param evt  No description provided
    */
   public void actionPerformed (ActionEvent evt)
   {
      if (evt.getSource() == gbutton)
      {
         executeGoto();
      }
      dispose();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void keyTyped (KeyEvent e) { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void keyReleased (KeyEvent e) { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void keyPressed (KeyEvent e)
   {
      if (e.getKeyCode() == KeyEvent.VK_ENTER)
      {
         executeGoto();
         dispose();
      }
      else if (e.getKeyCode() == KeyEvent.VK_ESCAPE)
      {
         dispose();
      }
   }

}

/*
 * $Log: GotoDialog.java,v $
 * Revision 1.14.2.1  2005/08/23 08:24:45  lowende
 * Removed compile warnings.
 *
 */
