/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.mpEdit;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.*;

import org.apache.log4j.Logger;


/**
 * This class will be changed to inherit from swing AbstractAction
 *
 * @author    Artur Biesiadowski
 * @version   1.0 Sun 1997.12.07
 */

abstract class AbstractMpAction implements MpAction
{

   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (AbstractMpAction.class);

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static ResourceBundle strings =
      ResourceBundle.getBundle (mpEDIT.stringsResourceName, Locale.getDefault());

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private boolean enabled = true;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private PropertyChangeSupport propertyChangeSupport;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected String idString;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected String name;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected String shortDescription;


   /**
    * Constructor for class AbstractMpAction
    *
    * @param aIdString  No description provided
    */
   public AbstractMpAction (String aIdString)
   {
      idString = aIdString;
      propertyChangeSupport = new PropertyChangeSupport (this);
      try
      {
         name = strings.getString ("action." + idString + ".name");
         shortDescription = strings.getString ("action." + idString + ".short");
      }
      catch (MissingResourceException e)
      {
         if (log.isInfoEnabled())
         {
            log.info ("No description for action " + idString);
         }
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public abstract void actionPerformed (ActionEvent e);


   /**
    * Get the text attribute of the AbstractMpAction object
    *
    * @param key  No description provided
    * @return     The text value
    */
   public String getText (String key)
   {
      if (key.equals (NAME))
      {
         return name;
      }
      else if (key.equals (ID_STRING))
      {
         return idString;
      }
      else if (key.equals (SHORT_DESCRIPTION))
      {
         return shortDescription;
      }
      return idString;
   }


   /**
    * Sets the text attribute of the AbstractMpAction object
    *
    * @param key   The new text value
    * @param text  The new text value
    */
   public void setText (String key, String text)
   {
      if (key.equals (NAME))
      {
         setName (text);
      }
      else if (key.equals (SHORT_DESCRIPTION))
      {
         setShortDescription (text);
      }
      else
      {
         throw new RuntimeException ("Value " + key + " cannot be set");
      }
   }


   /**
    * Get the idString attribute of the AbstractMpAction object
    *
    * @return   The idString value
    */
   public String getIdString()
   {
      return idString;
   }


   /**
    * Get the shortDescription attribute of the AbstractMpAction object
    *
    * @return   The shortDescription value
    */
   public String getShortDescription()
   {
      return shortDescription;
   }


   /**
    * Sets the shortDescription attribute of the AbstractMpAction object
    *
    * @param text  The new shortDescription value
    */
   public void setShortDescription (String text)
   {
      propertyChangeSupport.firePropertyChange (SHORT_DESCRIPTION,
         shortDescription, text);
      shortDescription = text;
   }


   /**
    * Get the name attribute of the AbstractMpAction object
    *
    * @return   The name value
    */
   public String getName()
   {
      return name;
   }


   /**
    * Sets the name attribute of the AbstractMpAction object
    *
    * @param text  The new name value
    */
   public void setName (String text)
   {
      propertyChangeSupport.firePropertyChange (NAME,
         name, text);
      name = text;
   }


   /**
    * Get the enabled attribute of the AbstractMpAction object
    *
    * @return   The enabled value
    */
   public boolean isEnabled()
   {
      return enabled;
   }


   /**
    * Sets the enabled attribute of the AbstractMpAction object
    *
    * @param b  The new enabled value
    */
   public void setEnabled (boolean b)
   {
      propertyChangeSupport.firePropertyChange (ENABLED,
         Boolean.valueOf (enabled), Boolean.valueOf (b));
      enabled = b;
   }


   /**
    * Access method for an one to n association.
    *
    * @param listener  The object added.
    */
   public void addPropertyChangeListener (PropertyChangeListener listener)
   {
      propertyChangeSupport.addPropertyChangeListener (listener);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param listener  No description provided
    */
   public void removePropertyChangeListener (PropertyChangeListener listener)
   {
      propertyChangeSupport.removePropertyChangeListener (listener);
   }
}

/*
 * $Log: AbstractMpAction.java,v $
 * Revision 1.13.2.1  2005/09/30 18:57:15  mksoft
 * replacing many System.out.println with if (log.isInfoEnabled()) log.info ()
 *
 */
