/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.metamodel;

import java.util.Iterator;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.3 $ $Date: 2004/11/22 19:04:52 $
 */
public interface FProject extends FElement
{
   // Property rootPackage
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String ROOT_PACKAGE_PROPERTY = "rootPackage";


   /**
    * There should be no need to set the rootPackage outside of this class. But it must be
    * for the load and save mechanism, until now. Hopefully this will be corrected by inro
    * as soon as possible.
    *
    * @param rootPackage  The new rootPackage value
    */
   public void setRootPackage (FPackage rootPackage);


   /**
    * Get the rootPackage attribute of the FProject object
    *
    * @return   The rootPackage value
    */
   public abstract FPackage getFRootPackage();

   // --- Other methods ---
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param fullName  No description provided
    * @param create    No description provided
    * @return          No description provided
    */
   public abstract FPackage findFPackage (String fullName, boolean create);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param fullName          No description provided
    * @param create            No description provided
    * @param coobraPersistent  No description provided
    * @return                  No description provided
    */
   public abstract FPackage findFPackage (String fullName, boolean create,
                                          boolean coobraPersistent);

   // --- Deprecated methods ---

   /**
    * Searches for a package with the full-name fullname and returns this package. If there
    * is no package, it will be created.
    *
    * @param fullName  Parameter description
    * @return          The newFromPackages value
    * @deprecated
    */
   public abstract FPackage getNewFromFPackages (String fullName);


   /**
    * Get the newFromPackages attribute of the FProject object
    *
    * @param fullName          No description provided
    * @param coobraPersistent  No description provided
    * @return                  The newFromPackages value
    * @deprecated
    */
   public abstract FPackage getNewFromFPackages (String fullName,
                                                 boolean coobraPersistent);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param fullName  No description provided
    * @return          No description provided
    * @deprecated
    */
   public abstract FPackage findFPackage (String fullName);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return       Return Value description
    * @deprecated
    */
   public abstract Iterator iteratorOfPackages();


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return       Return Value description
    * @deprecated
    */
   public abstract Iterator iteratorOfFiles();


   /**
    * Get the fromBaseTypes attribute of the FProject object
    *
    * @param key    Parameter description
    * @return       The fromBaseTypes value
    * @deprecated
    */
   public abstract FType getFromFBaseTypes (String key);


   /**
    * Get the fromReferences attribute of the FProject object
    *
    * @param key    full qualified class name
    * @return       The fromReferences value
    * @deprecated
    */
   public abstract FClass getFromFReferences (String key);


   /**
    * @param context
    * @param name
    * @return         The orNewFType value
    * @deprecated
    */
   public abstract FType getOrNewFType (FClass context, String name);


   /**
    * Get the orNewType attribute of the FProject object
    *
    * @param context           No description provided
    * @param name              No description provided
    * @param coobraPersistent  No description provided
    * @return                  The orNewType value
    * @deprecated
    */
   public abstract FType getOrNewFType (FClass context, String name,
                                        boolean coobraPersistent);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param context  No description provided
    * @param name     No description provided
    * @return         No description provided
    * @deprecated
    */
   public abstract FType findFType (FClass context, String name);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param context  No description provided
    * @param name     No description provided
    * @param create   No description provided
    * @return         No description provided
    * @deprecated
    */
   public abstract FType findFType (FClass context, String name,
                                    boolean create);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param context           No description provided
    * @param name              No description provided
    * @param create            No description provided
    * @param coobraPersistent  No description provided
    * @return                  No description provided
    * @deprecated
    */
   public abstract FType findFType (FClass context, String name,
                                    boolean create, boolean coobraPersistent);


   /**
    * Get the orNewFromReferences attribute of the FProject object
    *
    * @param name   full qualified class name
    * @return       The orNewFromReferences value
    * @deprecated
    */
   public abstract FClass getOrNewFromFReferences (String name);


   /**
    * Get the orNewFromReferences attribute of the FProject object
    *
    * @param name              No description provided
    * @param coobraPersistent  No description provided
    * @return                  The orNewFromReferences value
    * @deprecated
    */
   public abstract FClass getOrNewFromFReferences (String name,
                                                   boolean coobraPersistent);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param name   No description provided
    * @return       No description provided
    * @deprecated
    */
   public abstract FClass findFReference (String name);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param name    No description provided
    * @param create  No description provided
    * @return        No description provided
    * @deprecated
    */
   public abstract FClass findFReference (String name, boolean create);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param name              No description provided
    * @param create            No description provided
    * @param coobraPersistent  No description provided
    * @return                  No description provided
    * @deprecated
    */
   public abstract FClass findFReference (String name, boolean create,
                                          boolean coobraPersistent);


   /**
    * Get the typeList attribute of the FProject object
    *
    * @return       The typeList value
    * @deprecated
    */
   public abstract FTypeList getFTypeList();


   /**
    * @param diagram  The object added.
    * @return         No description provided
    * @deprecated
    */
   public abstract boolean addToDiags (FDiagram diagram);


   /**
    * @return       No description provided
    * @deprecated
    */
   public abstract Iterator iteratorOfDiags();


   /**
    * @param context  No description provided
    * @param name     No description provided
    * @return         The fClassFromImports value
    * @deprecated
    */
   public abstract FClass getFClassFromImports (FClass context, String name);
}

/*
 * $Log: FProject.java,v $
 * Revision 1.3  2004/11/22 19:04:52  lowende
 * Some javadoc corrections.
 *
 */
