/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.metamodel;



/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.2 $ $Date: 2004/10/22 16:41:45 $
 */
public interface FGeneralization extends FConnection
{

   // --- Property discriminator ---
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String DISCRIMINATOR_PROPERTY = "discriminator";


   /**
    * Get the discriminator attribute of the FGeneralization object
    *
    * @return   The discriminator value
    */
   public abstract String getDiscriminator();


   /**
    * Sets the discriminator attribute of the FGeneralization object
    *
    * @param discriminator  The new discriminator value
    */
   public abstract void setDiscriminator (String discriminator);

   // --- Property subclass ---
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String SUBCLASS_PROPERTY = "subclass";


   /**
    * Get the subclass attribute of the FGeneralization object
    *
    * @return   The subclass value
    */
   public abstract FClass getFSubclass();


   /**
    * Sets the subclass attribute of the FGeneralization object
    *
    * @param subclass  The new subclass value
    * @return          No description provided
    */
   public abstract boolean setSubclass (FClass subclass);

   // --- Property superclass ---
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String SUPERCLASS_PROPERTY = "superclass";


   /**
    * Get the superclass attribute of the FGeneralization object
    *
    * @return   The superclass value
    */
   public abstract FClass getFSuperclass();


   /**
    * Sets the superclass attribute of the FGeneralization object
    *
    * @param superclass  The new superclass value
    * @return            No description provided
    */
   public abstract boolean setSuperclass (FClass superclass);
}

/*
 * $Log: FGeneralization.java,v $
 * Revision 1.2  2004/10/22 16:41:45  lowende
 * Deprecated warnings removed. Other compile warnings removed.
 *
 */
