/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.metamodel;

import java.util.Iterator;

import de.tu_bs.coobra.ObjectChangeAware;
import de.uni_kassel.prop.InspectionAware;
import de.uni_paderborn.fujaba.basic.UniqueIdentifier;
import de.uni_paderborn.fujaba.codegen.OOGenToken;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;
import de.uni_paderborn.fujaba.messages.Message;
import de.upb.tools.pcs.PropertyChangeClient;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: cschneid $
 * @version   $Revision: 1.4 $ $Date: 2005/02/14 14:28:11 $
 */
public interface FElement extends Comparable, UniqueIdentifier, LogicUnparseInterface, PropertyChangeClient, ObjectChangeAware, InspectionAware
{

   // --- Property name ---
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String NAME_PROPERTY = "name";


   /**
    * Get the name attribute of the ASGElement object
    *
    * @return   The name value
    */
   public abstract String getName();


   /**
    * Sets the name attribute of the ASGElement object
    *
    * @param newName  The new name value
    */
   public abstract void setName (String newName);

   // --- Property generated ---
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String GENERATED_PROPERTY = "generated";


   /**
    * Sets the generated attribute of the BasicIncrement object
    *
    * @param value  The new generated value
    */
   public abstract void setGenerated (boolean value);


   /**
    * Get the generated attribute of the BasicIncrement object
    *
    * @return   The generated value
    */
   public abstract boolean isGenerated();

   // --- Property text ---
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String TEXT_PROPERTY = "text";


   /**
    * Get the text attribute of the ASGElement object
    *
    * @return   The text value
    */
   public abstract String getText();

   // --- Property diagrams property ---
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String DIAGRAMS_PROPERTY = "diagrams";


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public abstract int sizeOfDiagrams();


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param diagram  No description provided
    * @return         No description provided
    */
   public abstract boolean hasInDiagrams (FDiagram diagram);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public abstract Iterator iteratorOfDiagrams();


   /**
    * Access method for an one to n association.
    *
    * @param diagram  The object added.
    */
   public abstract void addToDiagrams (FDiagram diagram);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param diagram  No description provided
    */
   public abstract void removeFromDiagrams (FDiagram diagram);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public abstract void removeAllFromDiagrams();

   // --- Property elementReferences ---
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String ELEMENT_REFERENCES_PROPERTY = "elementReferences";


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public abstract boolean hasInElementReferences (FElementRef value);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param key    No description provided
    * @param value  No description provided
    * @return       No description provided
    */
   public abstract boolean hasInElementReferences (String key, FElementRef value);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param key  No description provided
    * @return     No description provided
    */
   public abstract boolean hasKeyInElementReferences (String key);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public abstract Iterator iteratorOfElementReferences();


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public abstract Iterator keysOfElementReferences();


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public abstract Iterator entriesOfElementReferences();


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public abstract int sizeOfElementReferences();


   /**
    * Get the fromReferences attribute of the ASGElement object
    *
    * @param key  No description provided
    * @return     The fromReferences value
    */
   public abstract FElementRef getFromFElementReferences (String key);


   /**
    * Access method for an one to n association.
    *
    * @param key    The object added.
    * @param value  The object added.
    * @return       No description provided
    */
   public abstract boolean addToElementReferences (String key, FElementRef value);


   /**
    * Access method for an one to n association.
    *
    * @param entry  The object added.
    * @return       No description provided
    */
   public abstract boolean addToElementReferences (java.util.Map.Entry entry);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public abstract boolean removeFromElementReferences (FElementRef value);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param key    No description provided
    * @param value  No description provided
    * @return       No description provided
    */
   public abstract boolean removeFromElementReferences (String key, FElementRef value);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param key  No description provided
    * @return     No description provided
    */
   public abstract boolean removeKeyFromElementReferences (String key);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public abstract void removeAllFromElementReferences();

   // --- Property annotations ---
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String ANNOTATIONS_PROPERTY = "annotations";


   /**
    * Access method for an one to n association.
    *
    * @param key    The object added.
    * @param value  The object added.
    * @return       No description provided
    */
   public abstract boolean addToAnnotations (String key, FAnnotation value);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public abstract Iterator iteratorOfAnnotations();


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public abstract boolean hasInAnnotations (FAnnotation value);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public abstract int sizeOfAnnotations();


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param key    No description provided
    * @param value  No description provided
    * @return       No description provided
    */
   public abstract boolean removeFromAnnotations (String key, FAnnotation value);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public abstract void removeAllFromAnnotations();

   // --- Other methods ---
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public abstract void removeYou();


   /**
    * Sets the firstOOGenToken attribute of the ASGElement object
    *
    * @param value  The new firstOOGenToken value
    * @return       No description provided
    */
   public abstract boolean setFirstOOGenToken (OOGenToken value);


   /**
    * Get the firstOOGenToken attribute of the ASGElement object
    *
    * @return   The firstOOGenToken value
    */
   public abstract OOGenToken getFirstOOGenToken();


   /**
    * Sets the lastOOGenToken attribute of the ASGElement object
    *
    * @param value  The new lastOOGenToken value
    * @return       No description provided
    */
   public abstract boolean setLastOOGenToken (OOGenToken value);


   /**
    * Get the lastOOGenToken attribute of the ASGElement object
    *
    * @return   The lastOOGenToken value
    */
   public abstract OOGenToken getLastOOGenToken();


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @deprecated
    */
   public abstract void deleteTokens();


   /**
    * Hangs the current ASGElement into the ASG-tree. Needed for cut'n'paste.
    *
    * @param parent
    * @deprecated
    */
   public abstract void setCutCopyPasteParent (FElement parent);


   /**
    * @return       The coobraPersistent value
    * @deprecated
    */
   public abstract boolean isCoobraPersistent();


   /**
    * Stick a user message onto this element. This element will become part of the context of the message.
    *
    * @param value  new message
    * @return       true if something was changed
    */
   boolean addToUserMessages (Message value);


   /**
    * Iterate through all user messages this element if context of.
    *
    * @return   iterator through Messages
    */
   Iterator iteratorOfUserMessages();


   /**
    * remove this element from all message contexts.
    */
   void removeAllFromUserMessages();


   /**
    * Remove this element from the context of the message.
    *
    * @param value  which message
    * @return       true if something was changed
    */
   boolean removeFromUserMessages (Message value);


   /**
    * @return   number of messages this element is context of.
    */
   int sizeOfUserMessages();


   /**
    * Query the logical parent of this element (e.g. package of a class, diagram of an object).
    * This method allows to navigate in direction of the model root (project) from any element within a project.
    *
    * @return   the logical parent of this element, may not return null unless this is the top level node (project)
    *         or is not contained in any parent yet
    */
   public FElement getParentElement();
}

/*
 * $Log: FElement.java,v $
 * Revision 1.4  2005/02/14 14:28:11  cschneid
 * introduced message view, getParentElement() for FElement, code generation and compiler messages in message view
 *
 */
