/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.metamodel;



/**
 * @author    $Author: schneider $
 * @version   $Revision: 1.1 $
 */
public interface FClassDiagram extends FDiagram
{
   // --- Property classes ---
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String CLASSES_PROPERTY = "classes";


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param className  No description provided
    * @return           No description provided
    */
   public abstract boolean hasInClasses (String className);


   /**
    * Get the fromClasses attribute of the FClassDiagram object
    *
    * @param className  No description provided
    * @return           The fromClasses value
    */
   public abstract FClass getFromFClasses (String className);

   // --- Deprecated classes ---
   /**
    * Returns a class with the full qualified name "className". If the class can not be found,
    * a new one is created within the given package. If no package was given, the default package
    * will be used.
    *
    * @param className    Full qualified (with package) class name.
    * @param reuse        If true, method tries to reuse existing classes from another class
    *      diagram.
    * @param packageName  No description provided
    * @return             No description provided
    * @deprecated
    */
   public abstract FClass provideFClass (String className, String packageName, boolean reuse);

}

/*
 * $Log: FClassDiagram.java,v $
 * Revision 1.1  2004/10/20 19:14:25  schneider
 * new interfaces
 *
 */
