/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.metamodel;

import java.util.Iterator;


/**
 * <h2>Associations</h2> <pre>
 *             +------+ 1                 1
 * UMLTypeList | name +--------------------- UMLType
 *             +------+ revTypes      types
 * </pre>
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.2 $
 */
public interface FBaseTypes extends FIncrement, FType
{
   // standard basetype names
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String INITIALIZER = "Initializer";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String BOOLEAN = "Boolean";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String CHARACTER = "Character";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String STRING = "String";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String INTEGER = "Integer";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String BYTE = "Byte";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String SHORT_INTEGER = "ShortInteger";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String LONG_INTEGER = "LongInteger";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String FLOAT = "Float";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String DOUBLE = "Double";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String VOID = "Void";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String CONSTRUCTOR = "constructor";

   // --- Property revAttrType ---
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String REV_ATTR_TYPE_PROPERTY = "revAttrType";


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public abstract boolean hasInRevAttrType (FAttr value);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public abstract Iterator iteratorOfRevAttrType();


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public abstract int sizeOfRevAttrType();


   /**
    * Access method for an one to n association.
    *
    * @param value  The object added.
    * @return       No description provided
    */
   public abstract boolean addToRevAttrType (FAttr value);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public abstract boolean removeFromRevAttrType (FAttr value);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public abstract void removeAllFromRevAttrType();

   // ######################################################################

   // --- Property revType ---
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String REV_TYPE_PROPERTY = "revType";


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public abstract boolean hasInRevType (FQualifier value);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public abstract Iterator iteratorOfRevType();


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public abstract int sizeOfRevType();


   /**
    * Access method for an one to n association.
    *
    * @param value  The object added.
    * @return       No description provided
    */
   public abstract boolean addToRevType (FQualifier value);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public abstract boolean removeFromRevType (FQualifier value);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public abstract void removeAllFromRevType();

   // --- Property revResultType ---
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String REV_RESULT_TYPE = "revResultType";


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public abstract boolean hasInRevResultType (FMethod value);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public abstract Iterator iteratorOfRevResultType();


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public abstract int sizeOfRevResultType();


   /**
    * Access method for an one to n association.
    *
    * @param value  The object added.
    * @return       No description provided
    */
   public abstract boolean addToRevResultType (FMethod value);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public abstract boolean removeFromRevResultType (FMethod value);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public abstract void removeAllFromRevResultType();

   // --- Property revParamType ---
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String REV_PARAM_TYPE = "revParamType";


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public abstract boolean hasInRevParamType (FParam value);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public abstract Iterator iteratorOfRevParamType();


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public abstract int sizeOfRevParamType();


   /**
    * Access method for an one to n association.
    *
    * @param value  The object added.
    * @return       No description provided
    */
   public abstract boolean addToRevParamType (FParam value);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public abstract boolean removeFromRevParamType (FParam value);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public abstract void removeAllFromRevParamType();

   // --- Property revTypes ---
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String REV_TYPES = "revTypes";


   /**
    * Sets the revTypes attribute of the UMLBaseTypes object
    *
    * @param value  The new revTypes value
    * @return       No description provided
    */
   public abstract boolean setRevTypes (FTypeList value);


   /**
    * Get the revTypes attribute of the UMLBaseTypes object
    *
    * @return   The revTypes value
    */
   public FTypeList getFRevTypes();

   // --- Property revArrayType ---
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String REV_ARRAY_TYPE = "arrayType";


   /**
    * Get the revArrayType attribute of the UMLBaseTypes object
    *
    * @return   The revArrayType value
    */
   public abstract FArray getFRevArrayType();


   /**
    * Sets the revArrayType attribute of the UMLBaseTypes object
    *
    * @param revArrayType  The new revArrayType value
    */
   public abstract void setRevArrayType (FArray revArrayType);

}

/*
 * $Log: FBaseTypes.java,v $
 * Revision 1.2  2004/10/22 16:41:45  lowende
 * Deprecated warnings removed. Other compile warnings removed.
 *
 */
