/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.messages;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.basic.IncrSelector;
import de.uni_paderborn.fujaba.fsa.SelectionManager;
import de.uni_paderborn.fujaba.metamodel.FClass;
import de.uni_paderborn.fujaba.metamodel.FElement;
import de.uni_paderborn.fujaba.metamodel.FMethod;
import de.uni_paderborn.fujaba.metamodel.FPackage;
import de.upb.lib.userinterface.UserInterfaceManager;
import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FHashSet;
import de.upb.tools.fca.IteratorConcatenation;


/**
 * @author    christian.schneider@uni-kassel.de
 * @version   $Revision: 1.3.2.2 $ $Date: 2006/02/09 15:30:36 $
 */
public class Message
{
   /**
    * actions that can be performed on messages
    */
   private LinkedList customActions = new LinkedList();


   /**
    * getter for field messageClass
    *
    * @return   current value of field messageClass
    */
   public String getMessageCategory()
   {
      return this.messageCategory;
   }


   /**
    * store the value for field messageClass
    */
   private String messageCategory;


   /**
    * setter for field messageClass
    *
    * @param value  new value
    */
   public void setMessageCategory (final String value)
   {
      final String oldValue = this.messageCategory;
      if (oldValue != value)
      {
         this.messageCategory = value;
      }
   }


   /**
    *Constructor for class Message
    */
   public Message() { }


   /**
    * getter for field text
    *
    * @return   current value of field text
    */
   public String getText()
   {
      return this.text;
   }


   /**
    * setter for field text
    *
    * @param text  new  value of field text
    */
   public void setText (String text)
   {
      this.text = text;
   }


   /**
    *Constructor for class Message
    *
    * @param text  No description provided
    */
   public Message (String text)
   {
      setText (text);
   }


   /**
    * store the value for field text
    */
   private String text;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Set context;


   /**
    * Access method for a To N-association.
    *
    * @param value  The object added.
    * @return       No description provided
    */
   public boolean addToContext (FElement value)
   {
      boolean changed = false;
      if (value != null)
      {
         if (this.context == null)
         {
            this.context = new FHashSet();
         }
         changed = this.context.add (value);
//         firePropertyChange( "context", null, value );
         if (changed)
         {
            value.addToUserMessages (this);
         }
      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean hasInContext (FElement value)
   {
      return  ( (this.context != null) &&
          (value != null) &&
         this.context.contains (value));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Iterator iteratorOfContext()
   {
      if (this.context == null)
      {
         return FEmptyIterator.get();
      }
      else
      {
         return this.context.iterator();
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void removeAllFromContext()
   {
      FElement tmpValue;
      Iterator iter = this.iteratorOfContext();
      while (iter.hasNext())
      {
         tmpValue = (FElement) iter.next();
         this.removeFromContext (tmpValue);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean removeFromContext (FElement value)
   {
      boolean changed = false;
      if ( (this.context != null) &&  (value != null))
      {
         changed = this.context.remove (value);
//         firePropertyChange( "context", value, null );
         if (changed)
         {
            value.removeFromUserMessages (this);
         }
      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public int sizeOfContext()
   {
      return  ( (this.context == null)
         ? 0
         : this.context.size());
   }


   /**
    * Get the icon attribute of the Message object
    *
    * @return   The icon value
    */
   public Icon getIcon()
   {
      URL imageURL = getIconURL();
      if (imageURL != null)
      {
         return new ImageIcon (Toolkit.getDefaultToolkit().createImage (imageURL));
      }
      else
      {
         return null;
      }
   }


   /**
    * Get the iconURL attribute of the Message object
    *
    * @return   The iconURL value
    */
   protected URL getIconURL()
   {
      return Message.class.getResource ("images/i.png");
   }


   /**
    * remove this message
    */
   public void removeYou()
   {
      removeAllFromContext();
      MessageView messageView = getMessageView();
      if (messageView != null)
      {
         messageView.removeFromMessages (this);
      }
   }


   /**
    * store value for field messageView
    */
   private MessageView messageView;


   /**
    * @return   current value of the field messageView
    */
   public MessageView getMessageView()
   {
      return this.messageView;
   }


   /**
    * Don't call directly! Use {@link MessageView#addToMessages}/{@link MessageView#removeFromMessages} instead
    *
    * @param value  new value for field messageView
    * @return       true if messageView was changed
    */
   boolean setMessageView (MessageView value)
   {
      boolean changed = false;
      final MessageView oldValue = this.messageView;
      if (oldValue != value)
      {
         if (oldValue != null)
         {
            this.messageView = null;
         }
         this.messageView = value;
         changed = true;
      }
      return changed;
   }


   /**
    * Query fully qualified package, class or method, etc. to provide userfriendly order/hierarchy.
    *
    * @return   fully qualified name of a class/package/method this message belongs to
    */
   public String getPath()
   {
      if (sizeOfContext() > 0)
      {
         for (Iterator it = iteratorOfContext(); it.hasNext(); )
         {
            String fqn = null;
            FElement element = (FElement) it.next();
            while (! (element instanceof FPackage)
               && element != null)
            {
               try
               {
                  if (element instanceof FMethod)
                  {
                     FMethod method = (FMethod) element;
                     fqn = method.getFullMethodName() +  (fqn != null ? "." + fqn : "");
                  }
                  else if (element instanceof FClass)
                  {
                     FClass cls = (FClass) element;
                     fqn = cls.getName() +  (fqn != null ? "." + fqn : "");
                  }
                  element = element.getParentElement();
               }
               catch (UnsupportedOperationException e)
               {
                  e.printStackTrace();
                  element = null;
               }
            }
            if (element != null)
            {
               FPackage pkg = (FPackage) element;
               if (!"".equals (pkg.getFullPackageName()))
               {
                  fqn = pkg.getFullPackageName() +  (fqn != null ? "." + fqn : "");
               }
               return fqn;
            }
         }
      }
      return null;
   }


   /**
    * getter for field time
    *
    * @return   current value of field time
    */
   public long getTime()
   {
      return this.time;
   }


   /**
    * store the value for field time
    */
   private long time = System.currentTimeMillis();


   /**
    * Show the context of this message via gotoElement.
    */
   public void showContext()
   {
      SelectionManager.get().removeAllFromSelectedComponents();
      for (Iterator it = iteratorOfContext(); it.hasNext(); )
      {
         ASGElement element = (ASGElement) it.next();
         IncrSelector.get().gotoElement (element);
         //SelectionManager.get().addToSelection( element );
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static boolean dobsLoaded = true;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   static Action dobsAction;


   /**
    * Get the dobsAction attribute of the Message object
    *
    * @return   The dobsAction value
    */
   private Action getDobsAction()
   {
      if (dobsLoaded && dobsAction == null)
      {
         dobsAction = UserInterfaceManager.get().getFromActions ("dobsAst");
         if (dobsAction == null)
         {
            dobsLoaded = false;
         }
      }

      if (dobsLoaded)
      {
         return
            new AbstractAction ("Show context in DOBS")
            {
               /**
                * Invoked when an action occurs.
                *
                * @param e  No description provided
                */
               public void actionPerformed (ActionEvent e)
               {
                  dobsAction.actionPerformed (new ActionEvent (iteratorOfContext(), 0, null));
               }
            };
      }
      else
      {
         return null;
      }
   }


   /**
    * Query actions than can be performed on this message.
    *
    * @return   iterator through actions than can be performed on this message.
    */
   public Iterator iteratorOfActions()
   {
      if (sizeOfContext() > 0)
      {
         LinkedList actions = new LinkedList();
         Action action;
         action = getDefaultAction();
         if (action != null)
         {
            actions.add (action);
         }
         action = getDobsAction();
         if (action != null)
         {
            actions.add (action);
         }
         return new IteratorConcatenation (actions.iterator(),
            iteratorOfCustomActions());
      }
      else
      {
         return iteratorOfCustomActions();
      }
   }


   /**
    * Access method for a To N-association.
    *
    * @param value  The object added.
    * @return       No description provided
    */
   public boolean addToCustomActions (Action value)
   {
      boolean changed = false;
      if (value != null)
      {
         if (this.customActions == null)
         {
            this.customActions = new LinkedList();
         }
         if (!customActions.contains (value))
         {
            changed = this.customActions.add (value);
         }
      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Iterator iteratorOfCustomActions()
   {
      return  ( (this.customActions == null)
         ? FEmptyIterator.get()
         : this.customActions.iterator());
   }


   /**
    * @return   the default action, taken when the message is clicked
    */
   public Action getDefaultAction()
   {
      return new ShowContextAction();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: lowende $
    * @version   $Revision: 1.3.2.2 $ $Date: 2006/02/09 15:30:36 $
    */
   private class ShowContextAction extends AbstractAction
   {
      /**
       *Constructor for class ShowContextAction
       */
      public ShowContextAction()
      {
         super ("Show context");
      }


      /**
       * Invoked when an action occurs.
       *
       * @param e  No description provided
       */
      public void actionPerformed (ActionEvent e)
      {
         showContext();
      }
   }
}

/*
 * $Log: Message.java,v $
 * Revision 1.3.2.2  2006/02/09 15:30:36  lowende
 * Some compile warnings removed.
 *
 */
