/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.messages;

import java.util.Iterator;
import de.uni_paderborn.fujaba.app.action.CompileAction;
import de.uni_paderborn.fujaba.messages.CompilerMessage;

import de.uni_paderborn.fujaba.messages.Warning;
import de.upb.tools.fca.IteratorConcatenation;
import de.upb.tools.fca.SingleObjectIterator;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: cschneid $
 * @version   $Revision: 1.1 $ $Date: 2005/02/18 15:40:13 $
 */
public class CompilerWarning extends Warning implements CompilerMessage
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private int lineNr;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String className;


   /**
    * Get the className attribute of the CompilerWarning object
    *
    * @return   The className value
    */
   public String getClassName()
   {
      return className;
   }


   /**
    * Get the lineNumber attribute of the CompilerWarning object
    *
    * @return   The lineNumber value
    */
   public int getLineNumber()
   {
      return lineNr;
   }


   /**
    * Constructor for class CompilerWarning
    *
    * @param className  No description provided
    * @param lineNr     No description provided
    */
   public CompilerWarning (String className, int lineNr)
   {
      this.className = className;
      this.lineNr = lineNr;
   }


   /**
    * Query actions than can be performed on this message.
    *
    * @return   iterator through actions than can be performed on this message.
    */
   public Iterator iteratorOfActions()
   {
      return new IteratorConcatenation (super.iteratorOfActions(),
         new SingleObjectIterator (CompileAction.createGotoSourceAction (this)));
   }
}

/*
 * $Log: CompilerWarning.java,v $
 * Revision 1.1  2005/02/18 15:40:13  cschneid
 * moved CompilerMessage-classes to own files
 *
 */
