/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.layout.options;

import de.uni_paderborn.fujaba.preferences.AbstractPreferences;
import de.uni_paderborn.fujaba.preferences.PreferencesProperties;


/**
 * Contains all options of Mr Layout.
 *
 * @author    $Author: joerg $
 * @version   $Revision: 1.9 $
 */
public class LayoutPreferences extends AbstractPreferences
{
   /**
    * This is the properties key for Fujaba's properties.
    */
   private final static String PROPERTY_NAME = "MrLayout.";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static String COLLAPSE_CLASSES = "CollapseClasses";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String SHOW_ROLE_NAMES = "ShowRoleNames";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static String SEL_LAYOUT = "SelectedLayout";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static String SEL_ACTIVITY_DIAGRAM_LAYOUT = "SelectedActivityDiagramLayout";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static String HOR_DIST = "HorizontalDistance";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static String VER_DIST = "VerticalDistance";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static String NUM_OF_ITER = "NumberOfIterations";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static String MINIMUM_WIDTH = "MinimumWidth";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static String STRETCH_FACTOR = "StretchFactor";

   // some default values
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static boolean DEF_COLLAPSE_CLASSES = true;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static boolean DEF_SHOW_ROLE_NAMES = false;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static int DEF_SEL_LAYOUT = 0;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static int DEF_SEL_ACTIVITY_DIAGRAM_LAYOUT = 2;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static int DEF_HOR_DIST = 80;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static int DEF_VER_DIST = 80;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static int DEF_MINIMUM_WIDTH = 0;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static int DEF_NUM_OF_ITER = 60;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static double DEF_STRETCH_FACTOR = 1.4;

   /**
    * The instance of this singleton class. Use LayoutPreferences.get() to get an instance
    * of this class.
    *
    * @see   #get
    */
   private static LayoutPreferences options;


   /**
    * The <B>private</B> constructor for this class. Use LayoutPreferences.get() to get an
    * instance of this class.
    *
    * @see   #get
    */
   private LayoutPreferences() { } // LayoutPreferences


   /**
    * This method provides the user the singleton instance of this class.
    *
    * @return   No description provided
    */
   public static synchronized LayoutPreferences get()
   {
      if (options == null)
      {
         options = new LayoutPreferences();
      }

      return options;
   } // get


   /**
    * Set the default values for all options.
    */
   public void setDefaults()
   {
      PreferencesProperties options = PreferencesProperties.get();

      options.putSetting (PROPERTY_NAME + COLLAPSE_CLASSES, DEF_COLLAPSE_CLASSES);
      options.putSetting (PROPERTY_NAME + SHOW_ROLE_NAMES, DEF_SHOW_ROLE_NAMES);

      options.putSetting (PROPERTY_NAME + SEL_LAYOUT, DEF_SEL_LAYOUT);
      options.putSetting (PROPERTY_NAME + SEL_ACTIVITY_DIAGRAM_LAYOUT, DEF_SEL_ACTIVITY_DIAGRAM_LAYOUT);

      options.putSetting (PROPERTY_NAME + HOR_DIST, DEF_HOR_DIST);
      options.putSetting (PROPERTY_NAME + VER_DIST, DEF_VER_DIST);
      options.putSetting (PROPERTY_NAME + MINIMUM_WIDTH, DEF_MINIMUM_WIDTH);
      options.putSetting (PROPERTY_NAME + NUM_OF_ITER, DEF_NUM_OF_ITER);
      options.putSetting (PROPERTY_NAME + STRETCH_FACTOR, DEF_STRETCH_FACTOR);
   } // setDefaults



   /**
    * CollapseClasses indicates if classes should be collapsed initially when adding to class
    * diagram.
    *
    * @return   true if classes should be collapsed initially.
    */
   public boolean isCollapseClasses()
   {
      return PreferencesProperties.get().getBoolSetting (PROPERTY_NAME + COLLAPSE_CLASSES, DEF_COLLAPSE_CLASSES);
   }


   /**
    * CollapseClasses indicates if classes should be collapsed initially when adding to class
    * diagram.
    *
    * @param value
    */
   public void setCollapseClasses (boolean value)
   {
      PreferencesProperties options = PreferencesProperties.get();

      if (options.getBoolSetting (PROPERTY_NAME + COLLAPSE_CLASSES, DEF_COLLAPSE_CLASSES) != value)
      {
         options.putSetting (PROPERTY_NAME + COLLAPSE_CLASSES, value);
         setModified (true);
      }
   }


   /**
    * Sets the showRoleNames attribute of the GeneralPreferences object
    *
    * @param value  The new showRoleNames value
    */
   public void setShowRoleNames (boolean value)
   {
      PreferencesProperties options = PreferencesProperties.get();
      if (options.getBoolSetting (PROPERTY_NAME + SHOW_ROLE_NAMES, DEF_SHOW_ROLE_NAMES) != value)
      {
         options.putSetting (PROPERTY_NAME + SHOW_ROLE_NAMES, value);
         setModified (true);
      }
   }


   /**
    * Get the showRoleNames attribute of the GeneralPreferences object
    *
    * @return   The showRoleNames value
    */
   public boolean isShowRoleNames()
   {
      return PreferencesProperties.get().getBoolSetting (PROPERTY_NAME + SHOW_ROLE_NAMES, DEF_SHOW_ROLE_NAMES);
   }


   /**
    * Get the whichActivityDiagramLayout attribute of the LayoutPreferences object
    *
    * @return   The whichActivityDiagramLayout value
    */
   public int getWhichActivityDiagramLayout()
   {
      int number;

      try
      {
         number = PreferencesProperties.get().getIntSetting (PROPERTY_NAME + SEL_ACTIVITY_DIAGRAM_LAYOUT,
            DEF_SEL_LAYOUT);
      }
      catch (NumberFormatException e)
      {
         number = DEF_SEL_ACTIVITY_DIAGRAM_LAYOUT;
      }

      return number;
   } // getWhichActivityDiagramLayout


   /**
    * Sets the whichActivityDiagramLayout attribute of the LayoutPreferences object
    *
    * @param value  The new whichActivityDiagramLayout value
    */
   public void setWhichActivityDiagramLayout (int value)
   {
      PreferencesProperties options = PreferencesProperties.get();

      try
      {
         int number = options.getIntSetting (PROPERTY_NAME + SEL_ACTIVITY_DIAGRAM_LAYOUT, DEF_SEL_ACTIVITY_DIAGRAM_LAYOUT);
         if (number != value)
         {
            options.putSetting (PROPERTY_NAME + SEL_ACTIVITY_DIAGRAM_LAYOUT, value);
            setModified (true);
         }
      }
      catch (NumberFormatException e)
      {
         options.putSetting (PROPERTY_NAME + SEL_ACTIVITY_DIAGRAM_LAYOUT, value);
         setModified (true);
      }
   } // setWhichActivityDiagramLayout


   /**
    * Get the whichLayout attribute of the LayoutPreferences object
    *
    * @return   The whichLayout value
    */
   public int getWhichLayout()
   {
      int number;

      try
      {
         number = PreferencesProperties.get().getIntSetting (PROPERTY_NAME + SEL_LAYOUT,
            DEF_SEL_LAYOUT);
      }
      catch (NumberFormatException e)
      {
         number = DEF_SEL_LAYOUT;
      }

      return number;
   } // getWhichLayout


   /**
    * Sets the whichLayout attribute of the LayoutPreferences object
    *
    * @param value  The new whichLayout value
    */
   public void setWhichLayout (int value)
   {
      PreferencesProperties options = PreferencesProperties.get();

      try
      {
         int number = options.getIntSetting (PROPERTY_NAME + SEL_LAYOUT, DEF_SEL_LAYOUT);
         if (number != value)
         {
            options.putSetting (PROPERTY_NAME + SEL_LAYOUT, value);
            setModified (true);
         }
      }
      catch (NumberFormatException e)
      {
         options.putSetting (PROPERTY_NAME + SEL_LAYOUT, value);
         setModified (true);
      }
   } // setWhichLayout


   /**
    * Get the horizDist attribute of the LayoutPreferences object
    *
    * @return   The horizDist value
    */
   public int getHorizDist()
   {
      int number;

      try
      {
         number = PreferencesProperties.get().getIntSetting (PROPERTY_NAME + HOR_DIST, DEF_HOR_DIST);
      }
      catch (NumberFormatException e)
      {
         number = DEF_HOR_DIST;
      }

      return number;
   } // getHorizDist


   /**
    * Sets the horizDist attribute of the LayoutPreferences object
    *
    * @param value  The new horizDist value
    */
   public void setHorizDist (int value)
   {
      PreferencesProperties options = PreferencesProperties.get();

      try
      {
         int number = options.getIntSetting (PROPERTY_NAME + HOR_DIST, DEF_HOR_DIST);
         if (number != value)
         {
            options.putSetting (PROPERTY_NAME + HOR_DIST, value);
            setModified (true);
         }
      }
      catch (NumberFormatException e)
      {
         options.putSetting (PROPERTY_NAME + HOR_DIST, value);
         setModified (true);
      }
   } // setHorizDist (int)


   /**
    * Sets the horizDist attribute of the LayoutPreferences object
    *
    * @param newDist  The new horizDist value
    */
   public void setHorizDist (String newDist)
   {
      try
      {
         setHorizDist (Integer.parseInt (newDist));
      }
      catch (NumberFormatException e)
      {
      }
   } // setHorizDist (String)


   /**
    * Get the vertDist attribute of the LayoutPreferences object
    *
    * @return   The vertDist value
    */
   public int getVertDist()
   {
      int number;

      try
      {
         number = PreferencesProperties.get().getIntSetting (PROPERTY_NAME + VER_DIST, DEF_VER_DIST);
      }
      catch (NumberFormatException e)
      {
         number = DEF_VER_DIST;
      }

      return number;
   } // getVertDist


   /**
    * Sets the vertDist attribute of the LayoutPreferences object
    *
    * @param value  The new vertDist value
    */
   public void setVertDist (int value)
   {
      PreferencesProperties options = PreferencesProperties.get();

      try
      {
         int number = options.getIntSetting (PROPERTY_NAME + VER_DIST, DEF_VER_DIST);
         if (number != value)
         {
            options.putSetting (PROPERTY_NAME + VER_DIST, value);
            setModified (true);
         }
      }
      catch (NumberFormatException e)
      {
         options.putSetting (PROPERTY_NAME + VER_DIST, value);
         setModified (true);
      }
   } // setVertDist (int)


   /**
    * Sets the vertDist attribute of the LayoutPreferences object
    *
    * @param newDist  The new vertDist value
    */
   public void setVertDist (String newDist)
   {
      try
      {
         setVertDist (Integer.parseInt (newDist));
      }
      catch (NumberFormatException e)
      {
      }
   } // setVertDist (String)


   /**
    * Get the minimumWidth attribute of the LayoutPreferences object
    *
    * @return   The vertDist value
    */
   public int getMinimumWidth()
   {
      int number;

      try
      {
         number = PreferencesProperties.get().getIntSetting (PROPERTY_NAME + MINIMUM_WIDTH, DEF_MINIMUM_WIDTH);
      }
      catch (NumberFormatException e)
      {
         number = DEF_MINIMUM_WIDTH;
      }

      return number;
   } // getMinimumWidth


   /**
    * Sets the minimumWidth attribute of the LayoutPreferences object
    *
    * @param value  The new vertDist value
    */
   public void setMinimumWidth (int value)
   {
      PreferencesProperties options = PreferencesProperties.get();

      try
      {
         int number = options.getIntSetting (PROPERTY_NAME + MINIMUM_WIDTH, DEF_MINIMUM_WIDTH);
         if (number != value)
         {
            options.putSetting (PROPERTY_NAME + MINIMUM_WIDTH, value);
            setModified (true);
         }
      }
      catch (NumberFormatException e)
      {
         options.putSetting (PROPERTY_NAME + MINIMUM_WIDTH, value);
         setModified (true);
      }
   } // setMinimumWidth (int)


   /**
    * Sets the minimumWidth attribute of the LayoutPreferences object
    *
    * @param newWidth  The new minimumWidth value
    */
   public void setMinimumWidth (String newWidth)
   {
      try
      {
         setMinimumWidth (Integer.parseInt (newWidth));
      }
      catch (NumberFormatException e)
      {
      }
   } // setMinimumWidth (String)


   /**
    * How many iterations should the spring embedder do.
    *
    * @return   The numberIterations value
    */
   public int getNumberIterations()
   {
      int number;

      try
      {
         number = PreferencesProperties.get().getIntSetting (PROPERTY_NAME + NUM_OF_ITER,
            DEF_NUM_OF_ITER);
      }
      catch (NumberFormatException e)
      {
         number = DEF_NUM_OF_ITER;
      }

      return number;
   } // getNumberIterations


   /**
    * How many iterations should the spring embedder do.
    *
    * @param value  The new numberIterations value
    */
   public void setNumberIterations (int value)
   {
      PreferencesProperties options = PreferencesProperties.get();

      try
      {
         int number = options.getIntSetting (PROPERTY_NAME + NUM_OF_ITER, DEF_NUM_OF_ITER);
         if (number != value)
         {
            options.putSetting (PROPERTY_NAME + NUM_OF_ITER, value);
            setModified (true);
         }
      }
      catch (NumberFormatException e)
      {
         options.putSetting (PROPERTY_NAME + NUM_OF_ITER, value);
         setModified (true);
      }
   } // setNumberIterations (int)


   /**
    * How many iterations should the spring embedder do.
    *
    * @param newIterations  The new numberIterations value
    */
   public void setNumberIterations (String newIterations)
   {
      try
      {
         setNumberIterations (Integer.parseInt (newIterations));
      }
      catch (NumberFormatException e)
      {
      }
   } // setNumberIterations (String)


   /**
    * A multiplier for the edge stretching.
    *
    * @return   The stretchFactor value
    */
   public double getStretchFactor()
   {
      double number;

      try
      {
         number = PreferencesProperties.get().getDoubleSetting (PROPERTY_NAME + STRETCH_FACTOR, DEF_STRETCH_FACTOR);
      }
      catch (NumberFormatException e)
      {
         number = DEF_STRETCH_FACTOR;
      }

      return number;
   } // getStretchFactor


   /**
    * A multiplier for the edge stretching.
    *
    * @param value  The new stretchFactor value
    */
   public void setStretchFactor (double value)
   {
      PreferencesProperties options = PreferencesProperties.get();

      try
      {
         double number = options.getDoubleSetting (PROPERTY_NAME + STRETCH_FACTOR, DEF_STRETCH_FACTOR);
         if (number != value)
         {
            options.putSetting (PROPERTY_NAME + STRETCH_FACTOR, value);
            setModified (true);
         }
      }
      catch (NumberFormatException e)
      {
         options.putSetting (PROPERTY_NAME + STRETCH_FACTOR, value);
         setModified (true);
      }
   } // setStretchFactor (double)


   /**
    * A multiplier for the edge stretching.
    *
    * @param newStretchFactor  The new stretchFactor value
    */
   public void setStretchFactor (String newStretchFactor)
   {
      try
      {
         Double myDouble = Double.valueOf (newStretchFactor);
         setStretchFactor (myDouble.doubleValue());
      }
      catch (NumberFormatException e)
      {
      }
   } // setStretchFactor (String)

}

/*
 * $Log: LayoutPreferences.java,v $
 * Revision 1.9  2005/01/24 12:30:51  joerg
 * started new layout algoritm for class diagrams
 *
 */
