/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.layout.classdiag;

import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.fsa.FSAObject;
import de.uni_paderborn.fujaba.fsa.FSAPolyLine;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;
import de.uni_paderborn.fujaba.uml.*;


/**
 * A class to get the proper layouter for a Fig. Currently this deals only with
 * Generalizations and Realizations. The class has been taken from Argo UML
 * source code.
 *
 * @author    $Author: joerg $
 * @version   $Revision: 1.1 $ $Date: 2005/01/24 12:30:48 $
 */
public class ClassdiagramModelElementFactory
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static Logger LOG = Logger.getLogger (ClassdiagramModelElementFactory.class);

   /**
    * The singleton.
    */
   public final static ClassdiagramModelElementFactory SINGLETON = new ClassdiagramModelElementFactory();


   /**
    *Constructor for class ClassdiagramModelElementFactory
    */
   private ClassdiagramModelElementFactory() { }


   /**
    * create layouter object from a FSAObject
    *
    *
    * @param fig  No description provided
    * @return     LayouterEdge for the Edge or null if none exists.
    */
   public ClassdiagramEdge getInstance (FSAObject fig)
   {
      LogicUnparseInterface lui = fig.getLogic();
      if (lui instanceof UMLIncrement)
      {
         if (lui instanceof UMLGeneralization)
         {
            UMLGeneralization gen = (UMLGeneralization) lui;
            if (gen.getSuperclass().hasInStereotypes (
               UMLStereotypeManager.get().getFromStereotypes (UMLStereotypeManager.INTERFACE)))
            {
               return new ClassdiagramRealizationEdge ((FSAPolyLine) fig);
            }
            else
            {
               return new ClassdiagramGeneralizationEdge ((FSAPolyLine) fig);
            }
         }
         if (lui instanceof UMLAssoc)
         {
            return new ClassdiagramAssociationEdge ((FSAPolyLine) fig);
         }
         LOG.debug ("Do not know how to deal with: " + fig.getClass().getName()
            + "\nUsing standard layout");
      }
      return null;
   }
}

/*
 * $Log: ClassdiagramModelElementFactory.java,v $
 * Revision 1.1  2005/01/24 12:30:48  joerg
 * started new layout algoritm for class diagrams
 *
 */
