/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.layout.classdiag;

import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.fsa.FSABendLine;
import de.uni_paderborn.fujaba.fsa.FSAObject;


/**
 * The class has been taken from Argo UML source code.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.2 $ $Date: 2005/01/28 11:36:28 $
 */
public abstract class ClassdiagramInheritanceEdge extends ClassdiagramEdge
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static Logger LOG = Logger.getLogger (ClassdiagramInheritanceEdge.class);

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private FSAObject high, low;


   /**
    * Constructor.
    *
    * @param edge  the fig edge
    */
   public ClassdiagramInheritanceEdge (FSABendLine edge)
   {
      super (edge);

      // calculate the higher and lower Figs
      LOG.debug ("sourceFigNode: " + getSourceFigNode().toString());
      LOG.debug ("destFigNode: " + getDestFigNode().toString());
      if (getSourceFigNode().getLocation().getY() <= getDestFigNode().getLocation().getY())
      {
         high = getDestFigNode();
         low = getSourceFigNode();
         LOG.debug ("high is sourcenode, " + "is low destnode");
      }
      else
      {
         high = getDestFigNode();
         low = getSourceFigNode();
         LOG.debug ("high is destnode, " + "low is sourcenode");
      }
      LOG.debug ("High: " + high.toString());
      LOG.debug ("Low : " + low.toString());
   }


   /**
    * @return   the vertical offset
    */
   public abstract int getVerticalOffset();


   /**
    * @return   the center of the high node
    */
   public int getCenterHigh()
   {
      return (int)  (high.getLocation().getX() + high.getSize().getWidth() / 2);
   }


   /**
    * @return   the center of the low node
    */
   public int getCenterLow()
   {
      return (int)  (low.getLocation().getX() + low.getSize().getWidth() / 2);
   }


   /**
    * @return   the gap with the node one level down
    */
   public int getDownGap()
   {
      return (int)  (low.getLocation().getY() - getVerticalOffset());
   }


   /**
    * Layout the edges in a way that they form a nice inheritance tree. Try to
    * implement these nice zigzag lines between classes and works well when the
    * row difference is one.
    */
   public void layout()
   {
      LOG.debug ("underlyingFig: " + getUnderlyingFig().toString());

      // now we construct the zig zag inheritance line
      int centerHigh = getCenterHigh();
      int centerLow = getCenterLow();

      LOG.debug ("centerHigh: " + centerHigh + " centerLow: " + centerLow + " downGap: "
         + getDownGap());

      // the amount of the "sidestep"
      int difference = centerHigh - centerLow;

      /*
       *  not needed because grabs don't need to be layouted addPoint(centerLow,
       *  (int) (low.getLocation().getY())); LOG.debug("Point: x: " + centerLow + "
       *  y: " + (int) (low.getLocation().getY()));
       */
      // if the Figs are directly under each other we
      // do not need to add these points
      if (difference != 0)
      {
         addPoint (centerHigh - difference, getDownGap());
         LOG.debug ("Point: x: " +  (centerHigh - difference) + " y: " + getDownGap());
         addPoint (centerHigh, getDownGap());
         LOG.debug ("Point: x: " + centerHigh + " y: " + getDownGap());

      }

      /*
       *  not needed because grabs don't need to be layouted addPoint(centerHigh,
       *  (int) (high.getLocation().getY() + high.getSize().getHeight()));
       *  LOG.debug("Point x: " + centerHigh + " y: " + (int)
       *  (high.getLocation().getY() + high.getSize().getHeight()));
       */
      // currentEdge.setBetweenNearestPoints(false);
   }
}

/*
 * $Log: ClassdiagramInheritanceEdge.java,v $
 * Revision 1.2  2005/01/28 11:36:28  lowende
 * Removed some compile warnings.
 *
 */
