/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.layout.classdiag;

import java.awt.Dimension;
import java.awt.Point;

import de.uni_paderborn.fujaba.fsa.FSABendLine;
import de.uni_paderborn.fujaba.fsa.FSAObject;


/**
 * The class has been taken from Argo UML source code.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.3 $ $Date: 2005/03/23 15:57:39 $
 */
public class ClassdiagramAssociationEdge extends ClassdiagramEdge
{

   /**
    * The constructor.
    *
    * @param edge  the fig of the edge
    */
   public ClassdiagramAssociationEdge (FSABendLine edge)
   {
      super (edge);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void layout()
   {
      // self associations are special cases. No need to let the maze
      // runner find the way.
      if (getDestFigNode() == getSourceFigNode())
      {
         // self assocs are layouted automatically :-)
         /*
          *  Point centerRight = getCenterRight((FigNode) getSourceFigNode());
          *  int yoffset = (int) ((getSourceFigNode().getSize().getHeight() /
          *  2)); yoffset = java.lang.Math.min(30, yoffset);
          *  getUnderlyingFig().addPoint(centerRight.x, centerRight.y); // move
          *  more right getUnderlyingFig().addPoint(centerRight.x + 30,
          *  centerRight.y); // move down
          *  getUnderlyingFig().addPoint(centerRight.x + 30, centerRight.y +
          *  yoffset); // move left getUnderlyingFig().addPoint(centerRight.x,
          *  centerRight.y + yoffset);
          *
          *  getUnderlyingFig().setFilled(false);
          *  getUnderlyingFig().setSelfLoop(true);
          *  getCurrentEdge().setFig(getUnderlyingFig());
          */
      }
      else
      {
         ; // brute force rectangular layout
         /*
          *  Point centerSource = sourceFigNode.center(); Point centerDest =
          *  destFigNode.center();
          *
          *  underlyingFig.addPoint(centerSource.x, centerSource.y);
          *  underlyingFig.addPoint(centerSource.x +
          *  (centerDest.x-centerSource.x)/2, centerSource.y);
          *  underlyingFig.addPoint(centerSource.x +
          *  (centerDest.x-centerSource.x)/2, centerDest.y);
          *  underlyingFig.addPoint(centerDest.x, centerDest.y);
          *  underlyingFig.setFilled(false); underlyingFig.setSelfLoop(false);
          *  currentEdge.setFig(underlyingFig);
          */
      }
   }


   /**
    * return a point which is just right of the center.
    *
    * @param fig  No description provided
    * @return     The centerRight value
    */
   private Point getCenterRight (FSAObject fig)
   {
      Point center = getCenter (fig);
      return new Point (center.x + fig.getSize().width / 2, center.y);
   }


   /**
    * return a Point which is just lower than the center of the Fig.
    *
    * @param fig  No description provided
    * @return     The centerLow value
    */
   private Point getCenterLow (FSAObject fig)
   {
      Point center = getCenter (fig);
      return new Point (center.x, center.y +  (fig.getSize().height / 2));
   }


   /**
    * return the center point of the object
    *
    * @param fig  No description provided
    * @return     The center value
    */
   private Point getCenter (FSAObject fig)
   {
      Dimension d = fig.getSize();
      Point loc = fig.getLocation();
      return new Point (loc.x +  (d.width / 2), loc.y +  (d.height / 2));
   }
}

/*
 * $Log: ClassdiagramAssociationEdge.java,v $
 * Revision 1.3  2005/03/23 15:57:39  lowende
 * Javadoc warnings removed.
 *
 */
