/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gxl;

import java.io.*;
import java.util.Iterator;
import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.app.FujabaApp;
import de.uni_paderborn.fujaba.asg.ASGDiagram;
import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.basic.BasicIncrement;
import de.uni_paderborn.fujaba.basic.FujabaComparator;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.upb.lib.plugins.PluginManager;
import de.upb.lib.plugins.PluginProperty;
import de.upb.tools.fca.FHashSet;
import de.upb.tools.fca.FTreeSet;


/**
 * No comment provided by developer, please add a comment to improve documentation. GXLFilter.java
 *
 * @author    $Author: creckord $
 * @version   $Revision: 1.33.2.2 $
 */
public class GXLFilter
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (GXLFilter.class);

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static FHashSet removed;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static FHashSet excluded;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public static ASGDiagram root;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public Filter actualFilter;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static FHashSet diagramItems;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static FHashSet addDiagrams;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static FHashSet savedDiagrams;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static boolean firstSelected;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private FHashSet storedItems;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static boolean include;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private StringBuffer outputData;


   /**
    * Constructor for class GXLFilter
    *
    * @param outputData    No description provided
    * @param rootIter      No description provided
    * @param isInclude     No description provided
    * @throws IOException  Exception description not provided
    * @throws Exception    Exception description not provided
    */
   public GXLFilter (Iterator rootIter, boolean isInclude, StringBuffer outputData) throws Exception
   {
      excluded = new FHashSet();
      removed = new FHashSet();
      diagramItems = new FHashSet();
      storedItems = new FHashSet();
      include = isInclude;
      this.outputData = outputData;

      if (rootIter.hasNext())
      {
         Object tmpObject = rootIter.next();
         if (tmpObject instanceof ASGDiagram)
         {
            root = (ASGDiagram) tmpObject;
            Iterator iter = root.iteratorOfElements();
            while (iter.hasNext())
            {
               diagramItems.add (iter.next());
            }
         }
         else
         {
            root = UMLProject.get().getCurrentDiagram();
            diagramItems.add (root);
            diagramItems.add (tmpObject);
            while (rootIter.hasNext())
            {
               diagramItems.add (rootIter.next());
            }
         }

         if (setActualFilter())
         {
            loadExcluded();
         }
         else
         {
            throw new Exception();
         }
      }
      save();
   }


   /**
    * Sets the actualFilter which is saved in the GXLFilterMap(extends FHashMap).
    *
    * @return   No description provided
    */
   protected boolean setActualFilter()
   {
      actualFilter =  (GXLFilterMap.get().getFromFilter (root.getClass()));
      if (actualFilter != null)
      {
         return true;
      }
      else
      {
         if (log.isInfoEnabled())
         {
            log.info ("Filter for " + root.getClass() + " could not be found");
         }
         return false;
      }
   }


   /**
    * Get the root attribute of the GXLFilter class
    *
    * @return   The root value
    */
   public static ASGDiagram getRoot()
   {
      return root;
   }


   /**
    * Get the include attribute of the GXLFilter class
    *
    * @return   The include value
    */
   public static boolean getInclude()
   {
      return include;
   }


   /**
    * Get the firstSelected attribute of the GXLFilter class
    *
    * @return   The firstSelected value
    */
   public static boolean getFirstSelected()
   {
      return firstSelected;
   }


   /**
    * Access method for an one to n association.
    *
    * @param diag  The object added.
    */
   public static void addToAddDiagrams (ASGDiagram diag)
   {
      if (addDiagrams != null)
      {
         addDiagrams.add (diag);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param diag  No description provided
    * @return      No description provided
    */
   public static boolean hasInAddDiagrams (ASGDiagram diag)
   {
      return addDiagrams.contains (diag);
   }


   /**
    * Access method for an one to n association.
    *
    * @param diag  The object added.
    */
   public static void addToSavedDiagrams (ASGDiagram diag)
   {
      if (savedDiagrams != null)
      {
         savedDiagrams.add (diag);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param diag  No description provided
    * @return      No description provided
    */
   public static boolean hasInSavedDiagrams (ASGDiagram diag)
   {
      return savedDiagrams.contains (diag);
   }



   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void loadExcluded()
   {
      GXLExcludedLoader loadClasses = new GXLExcludedLoader();
      if (loadClasses.isReady())
      {
         excluded = loadClasses.getExcluded (root.getClass().getName());
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void save()
   {
      ASGDiagram rootIncrement = UMLProject.get().getCurrentDiagram();
      FTreeSet savedIncrements = new FTreeSet (FujabaComparator.getLessBasicIncr());
      firstSelected = true;
      addDiagrams = new FHashSet();
      savedDiagrams = new FHashSet();
      try
      {
         // Write the header at the beginning of the file
         PluginManager manager = FujabaApp.getPluginManager();
         PluginProperty plugin = null;
         Iterator pluginIter = manager.iteratorOfProperties();
         outputData.append ("# used plug-ins\n");
         while (pluginIter.hasNext())
         {
            plugin = (PluginProperty) pluginIter.next();
            outputData.append ("$;" + plugin.getName() + ";" + plugin.getPluginID() + ";" + plugin.getMajor() + ";" + plugin.getMinor() + ";" + plugin.getBuildNumber() + "\n");
         }
         rootIncrement.writeClassToStringBuffer (outputData, savedIncrements, this);
      }
      catch (Exception e)
      {
         log.error ("Es kann nur ein String als Key gespeichert werden --> ClassCastException");
         e.printStackTrace();
      }
      savedDiagrams.add (rootIncrement);
      Iterator iter = addDiagrams.iterator();
      while (iter.hasNext())
      {
         if (firstSelected)
         {
            firstSelected = false;
         }
         outputData.append ("@\n");
         FTreeSet savedIncr = new FTreeSet (FujabaComparator.getLessBasicIncr());
         ASGElement rootIncr = (ASGElement) iter.next();
         root = (ASGDiagram) rootIncr;
         log.error ("Saving Diagram: " + rootIncr);
         setActualFilter();
         diagramItems = new FHashSet();
         Iterator iter2 = root.iteratorOfElementReferences();
         while (iter2.hasNext())
         {
            Object tmpObj = iter2.next();
            diagramItems.add (tmpObj);
         }
         loadExcluded();
         try
         {
            rootIncr.writeClassToStringBuffer (outputData, savedIncr, this);
            savedDiagrams.add (rootIncr);
         }
         catch (Exception e)
         {

         }
      }
   }



   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param obj  No description provided
    * @return     No description provided
    */
   public boolean verifyObject (BasicIncrement obj)
   {
      boolean result = false;
      if (excluded.contains (obj.getClass().getName()))
      {
         if (!hasInStoredItems (obj.getID()))
         {
            removed.add (obj.getID());
         }
         return result;
      }
      else
      {
         result = actualFilter.verifyObject (obj);
         if (result)
         {
            if (getInclude() & hasInRemoved (obj.getID()))
            {
               removeFromRemoved (obj.getID());
            }
            storedItems.add (obj.getID());
         }
         else
         {
            if (!hasInStoredItems (obj.getID()))
            {
               removed.add (obj.getID());

            }
         }
      }

      return result;
   }



   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param structure  No description provided
    * @return           No description provided
    */
   public StringBuffer removeExcludedObjects (StringBuffer structure)
   {
      BufferedReader in = new BufferedReader (new StringReader (structure.toString()));
      StringWriter out = new StringWriter();
      StringWriter o = new StringWriter();
      String line;
      int idx;

      try
      {
         while (in.ready())
         {
            line = in.readLine();
            o.write (line);
            o.flush();

            if (line == null)
            {
               break;
            }

            if (line.charAt (0) == '~')
            {
               idx = line.lastIndexOf (";id");
               if (idx == -1)
               {
                  out.write (line + "\n");

               }

               else
               {

                  String tmpString = line.substring (idx + 1);
                  if (tmpString.indexOf (".") == -1)
                  {
                     if (!removed.contains (tmpString))
                     {
                        out.write (line + "\n");
                     }
                  }
                  else
                  {
                     out.write (line + "\n");
                  }

               }

            }
            else
            {
               out.write (line + "\n");
            }

         }

      }
      catch (Exception e)
      {

         log.error ("Failed to remove references \n" + e + o.toString());
         e.printStackTrace();
      }
      return new StringBuffer (out.toString());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param element  No description provided
    * @return         No description provided
    */
   public static boolean hasInItems (ASGElement element)
   {
      return  (diagramItems == null
         ? false
         : diagramItems.contains (element));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param element  No description provided
    * @return         No description provided
    */
   public static boolean hasInRemoved (String element)
   {
      return  (removed == null
         ? false
         : removed.contains (element));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param element  No description provided
    * @return         No description provided
    */
   private boolean hasInStoredItems (String element)
   {
      return  (this.storedItems == null
         ? false
         : storedItems.contains (element));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param element  No description provided
    */
   public static void removeFromRemoved (String element)
   {
      if (removed != null)
      {
         removed.remove (element);
      }
   }

}

/*
 * $Log: GXLFilter.java,v $
 * Revision 1.33.2.2  2005/12/15 15:21:52  creckord
 * - FujabaApp can determine the Fujaba install location now
 * - Template dir and default plugin dir are determined based on install location instead of current dir
 *
 * - UMLCollabStat has an int number for its sequence number now instead of noText
 * - hopefully fixed UMLCollabStats losing/messing up their order and number between save & load
 * - threadId is honored by renumbering methods and GUI
 *
 * - FTreeEnumeration can enumerate elements nested in other elements of target type now
 * - iterator/elementsOfClasses in FProject returns inner classes now, too
 *
 * - UMLClass doesn't lose inner classes anymore (hopefully)
 *
 */
