/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gxl;

import java.io.InputStream;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.apache.log4j.Logger;
import org.w3c.dom.*;

import de.upb.tools.fca.FHashSet;


/**
 * UMLClass: ''.
 *
 * @author    $Author: mtt $
 * @version   $Revision: 1.21.2.1 $
 */
public class GXLExcludedLoader
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (GXLExcludedLoader.class);

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private boolean ready = false;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Element element;


   /**
    * Constructor for class GXLExcludedLoader
    */
   public GXLExcludedLoader()
   {
      initialize();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private void initialize()
   {
      InputStream stream = GXLExcludedLoader.class.getClassLoader().getResourceAsStream("de/uni_paderborn/fujaba/gxl/GXLExcluded.xml");
      if (stream != null)
      {
         try
         {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            GXLHandler handler = new GXLHandler();
            parser.setEntityResolver (handler);
            parser.setErrorHandler (handler);
            Document doc = parser.parse (stream);
            element = doc.getDocumentElement();
            ready = true;
         }
         catch (Exception e)
         {
            log.error ("Unable to open GXLExcluded.xml!");
         }
      }
      else
      {
         log.error ("Unable to open GXLExcluded.xml!");
      }

   }


   /**
    * Get the ready attribute of the GXLExcludedLoader object
    *
    * @return   The ready value
    */
   public boolean isReady()
   {
      return ready;
   }


   /**
    * Get the excluded attribute of the GXLExcludedLoader object
    *
    * @param root  No description provided
    * @return      The excluded value
    */
   public FHashSet getExcluded (String root)
   {
      FHashSet excluded = new FHashSet();

      NodeList generalList = element.getElementsByTagName ("General");
      NodeList diagramList = element.getElementsByTagName ("UMLDiagram");

      for (int i = 0; i < generalList.getLength(); i++)
      {
         NodeList generalClasses =  (generalList.item (i)).getChildNodes();

         for (int u = 0; u < generalClasses.getLength(); u++)
         {
            if ( (generalClasses.item (u).getNodeName()).equals ("Class"))
            {
               excluded.add (generalClasses.item (u).getFirstChild().getNodeValue());
            }
         }

      }

      for (int x = 0; x < diagramList.getLength(); x++)
      {
         if (diagramList.item (x).hasAttributes())
         {
            NamedNodeMap attributes =  (diagramList.item (x)).getAttributes();

            for (int y = 0; y < attributes.getLength(); y++)
            {
               Node attributeNode = attributes.item (y);

               if ( ( (attributeNode.getNodeName().equals ("class")) &&  (attributeNode.getNodeValue()).equals (root)))
               {
                  NodeList children = diagramList.item (x).getChildNodes();

                  for (int xyz = 0; xyz < children.getLength(); xyz++)
                  {
                     if ( (children.item (xyz).getNodeName()).equals ("Class"))
                     {
                        excluded.add (children.item (xyz).getFirstChild().getNodeValue());
                     }
                  }
               }
            }

         }

      }

      return excluded;
   }


   /**
    * Get the mergePoints attribute of the GXLExcludedLoader object
    *
    * @param root  No description provided
    * @return      The mergePoints value
    */
   public FHashSet getMergePoints (String root)
   {
      FHashSet mergePoints = new FHashSet();

      NodeList diagramList = element.getElementsByTagName ("UMLDiagram");

      for (int x = 0; x < diagramList.getLength(); x++)
      {
         if (diagramList.item (x).hasAttributes())
         {
            NamedNodeMap attributes =  (diagramList.item (x)).getAttributes();

            for (int y = 0; y < attributes.getLength(); y++)
            {
               Node attributeNode = attributes.item (y);

               if ( ( (attributeNode.getNodeName().equals ("class")) &&  (attributeNode.getNodeValue()).equals (root)))
               {
                  NodeList children = diagramList.item (x).getChildNodes();
                  for (int xyz = 0; xyz < children.getLength(); xyz++)
                  {
                     if ( (children.item (xyz).getNodeName()).equals ("MergePoints"))
                     {
                        mergePoints.add (children.item (xyz).getFirstChild().getNodeValue());

                     }
                  }
               }
            }

         }

      }

      return mergePoints;
   }

}

/*
 * $Log: GXLExcludedLoader.java,v $
 * Revision 1.21.2.1  2006/03/30 13:03:01  mtt
 * fix for fujaba4eclipse by using class.getClassLoader to load resources
 *
 * Revision 1.21  2004/11/19 09:11:54  lowende
 * Deprecated warnings removed.
 * Compile warnings removed.
 *
 */
