/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gxl;

import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;


/**
 * UMLClass: 'FXMLTree'.
 *
 * @author    $Author: mksoft $
 * @version   $Revision: 1.15.2.1 $
 */
public class FXMLTree
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (FXMLTree.class);

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private int currObject = 0;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private NodeList objects;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Element myRoot;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private NodeList diagrams;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private int currentDiagram = 0;


   /**
    * Constructor for class FXMLTree
    *
    * @param elem        No description provided
    * @throws Exception  Exception description not provided
    */
   public FXMLTree (Element elem) throws Exception
   {

      this.myRoot = elem;
      if (myRoot == null)
      {
         log.error ("root of DOM Tree is null.");
      }

      diagrams = this.myRoot.getElementsByTagName ("diagram");

   }


   /**
    * Get the root attribute of the FXMLTree object
    *
    * @return   The root value
    */
   public String getRoot()
   {
      return this.myRoot.getNodeName();
   }


   /**
    * UMLMethod: '+ getFirstObject (): FXMLNode'.
    *
    * @param diag  No description provided
    * @return      The firstObject value
    */
   public FXMLNode getFirstObject (Element diag)
   {
      if (diag != null)
      {
         currObject = 0;
         objects =  (diag.getElementsByTagName ("object"));
         if (objects.getLength() == 0)
         {
            return null;
         }
         else
         {
            return new FXMLNode ((Element)  (objects.item (currObject)));
         }
      }
      return null;
   }



   /**
    * UMLMethod: '+ getNextObject (): FXMLNode'.
    *
    * @return   The nextObject value
    */
   public FXMLNode getNextObject()
   {
      currObject++;
      if (currObject < objects.getLength())
      {
         return new FXMLNode ((Element)  (objects.item (currObject)));
      }
      else
      {
         return null;
      }
   }


   /**
    * Get the nextDiagram attribute of the FXMLTree object
    *
    * @return   The nextDiagram value
    */
   public Element getNextDiagram()
   {
      if (diagrams != null)
      {
         if (diagrams.getLength() > 0 &  (currentDiagram < diagrams.getLength()))
         {
            Element tmpDiag = (Element) diagrams.item (currentDiagram);
            currentDiagram++;
            return tmpDiag;
         }
         else
         {
            return null;
         }
      }
      else
      {
         if (log.isInfoEnabled())
         {
            log.info ("diagrams = null");
         }
         return null;
      }
   }

}

/*
 * $Log: FXMLTree.java,v $
 * Revision 1.15.2.1  2005/09/30 18:57:22  mksoft
 * replacing many System.out.println with if (log.isInfoEnabled()) log.info ()
 *
 */
