/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gxl;

import java.util.HashSet;
import java.util.Vector;

import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import de.upb.tools.fca.FHashMap;



/**
 * NOTE: The "attribute" in the method's names refers the logical attribute of BasicIncrement
 * objects and NOT the attributes of the xml document. A FXMLNode object encapsulates an BasicIncrement
 * object and defines methods to read out the single attributes(see above).
 *
 * @author    $Author: mksoft $
 * @version   $Revision: 1.19.2.1 $ $Date: 2005/09/30 18:57:22 $
 */
public class FXMLNode
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (FXMLNode.class);

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String clazz;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String id;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private NodeList attrs;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private HashSet names;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String tmpName;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private FHashMap namesAndValues;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Element myObject;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String pluginId;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String classLoader;



   /**
    * Constructor for class FXMLNode
    *
    * @param elem  No description provided
    */
   public FXMLNode (Element elem)
   {

      this.myObject = elem;
      if ( ( (myObject.getElementsByTagName ("class").item (0)).getFirstChild().getNodeValue() == null))
      {

         if (log.isInfoEnabled())
         {
            log.info ("class element is empty");
         }

      }

      this.clazz =  (myObject.getElementsByTagName ("class").item (0)).getFirstChild().getNodeValue();

      try
      { //a plugin is involved
         pluginId =  (myObject.getElementsByTagName ("pluginId").item (0)).getFirstChild().getNodeValue();

         classLoader =  (myObject.getElementsByTagName ("classLoader").item (0)).getFirstChild().getNodeValue();
      }
      catch (Exception e)
      {
      }

      this.id = myObject.getAttribute ("id");

      attrs = myObject.getElementsByTagName ("attribute");

      namesAndValues = new FHashMap();

      names = new HashSet();

      //log.info("object: " + this.getId() + "::"  + this.getType() );

      for (int i = 0; i < attrs.getLength(); i++)
      {

         Element currentNode = (Element) attrs.item (i);

         tmpName = currentNode.getAttribute ("name");

         int idx = tmpName.indexOf ("::");

         if (idx >= 0)
         {

            tmpName = tmpName.substring (idx + 2);

         }

         if (!names.contains (tmpName))
         {

            names.add (tmpName);

         }
         String value = null;

         NodeList nl = currentNode.getElementsByTagName ("reference");

         if (nl.getLength() > 0 && nl.item (0).getFirstChild() != null)
         {

            value = nl.item (0).getFirstChild().getNodeValue() + FileSaver.SEPARATOR;
         }

         nl = currentNode.getElementsByTagName ("value");

         if (nl.item (0).getFirstChild() != null)
         {

            if (value == null)
            {

               value = nl.item (0).getFirstChild().getNodeValue();
            }

            else
            {

               value += nl.item (0).getFirstChild().getNodeValue();
            }

         }

         if (value != null)
         {

            //log.error(tmpName + "'s value: " +  value);

            value = FileSaver.reReplace (value);

            //log.info("value " +  value);

         }

         if (!namesAndValues.containsKey (tmpName))
         {

            Vector newVector = new Vector();

            newVector.add (value);

            namesAndValues.put (tmpName, newVector);

            newVector.trimToSize();

         }

         else
         {

            Vector addVector = (Vector) namesAndValues.get (tmpName);

            addVector.add (value);

            addVector.trimToSize();

         }

      }

   }



   /**
    * UMLMethod: '+ getId (): String'.
    *
    * @return   The id value
    */

   public String getId()
   {

      return this.id;
   }



   /**
    * UMLMethod: '+ getType (): String'.
    *
    * @return   The type value
    */

   public String getType()
   {

      return this.clazz;
   }



   /**
    * Get the attributesAndValues attribute of the FXMLNode object
    *
    * @return   The attributesAndValues value
    */
   public FHashMap getAttributesAndValues()
   {

      return this.namesAndValues;
   }



   /**
    * UMLMethod: '+ getAttributeNames (): HashSet'.
    *
    * @return   The attributeNames value
    */

   public HashSet getAttributeNames()
   {

      return this.names;
   }


   /**
    * Get the pluginId attribute of the FXMLNode object
    *
    * @return   The pluginId value
    */
   public String getPluginId()
   {
      return this.pluginId;
   }


   /**
    * Get the classLoader attribute of the FXMLNode object
    *
    * @return   The classLoader value
    */
   public String getClassLoader()
   {
      return this.classLoader;
   }
}

/*
 * $Log: FXMLNode.java,v $
 * Revision 1.19.2.1  2005/09/30 18:57:22  mksoft
 * replacing many System.out.println with if (log.isInfoEnabled()) log.info ()
 *
 */
