/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gui.comp;

import java.util.Collection;
import java.util.Map;

import javax.swing.*;


/**
 * @author    $Author: schneider $
 * @version   $Revision: 1.17 $
 */
public class JglListModel extends AbstractListModel
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private boolean pair = false;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private boolean useKey = false;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Object[] items;


   /**
    * Sets the pair attribute of the JglListModel object
    *
    * @param pair  The new pair value
    */
   protected void setPair (boolean pair)
   {
      this.pair = pair;
   }


   /**
    * Sets the useKey attribute of the JglListModel object
    *
    * @param key  The new useKey value
    */
   public void setUseKey (boolean key)
   {
      this.useKey = key;
   }

   // ######################################################################

   /**
    * Constructor for class JglListModel
    *
    * @param container  No description provided
    */
   public JglListModel (Collection container)
   {
      if (container != null)
      {
         this.items = container.toArray();
      }
      else
      {
         this.items = new Object[0];
      }
      this.pair = false;
   }


   /**
    * Constructor for class JglListModel
    *
    * @param container  No description provided
    */
   public JglListModel (Map container)
   {
      if (container != null)
      {
         this.items = container.entrySet().toArray();
      }
      else
      {
         this.items = new Object[0];
      }
      this.pair = true;
   }

   // ######################################################################

   /**
    * Get the size attribute of the JglListModel object
    *
    * @return   The size value
    */
   public int getSize()
   {
      return this.items.length;
   }


   /**
    * Get the elementAt attribute of the JglListModel object
    *
    * @param index  No description provided
    * @return       The elementAt value
    */
   public java.lang.Object getElementAt (int index)
   {
      if (this.pair == true)
      {
         if (this.useKey == true)
         {
            return  ((Map.Entry) this.items[index]).getKey();
         }
         else
         {
            return  ((Map.Entry) this.items[index]).getValue();
         }
      }
      return this.items[index];
   }
}

/*
 * $Log: JglListModel.java,v $
 * Revision 1.17  2004/10/20 17:49:56  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
