/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gui.comp;

import java.util.Collection;
import java.util.Map;

import javax.swing.*;


/**
 * @author    $Author: schneider $
 * @version   $Revision: 1.15 $
 */
public class JglComboBoxModel extends JglListModel
    implements ComboBoxModel
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String NONE = "NONE";

   /**
    * none == 1 there is a value NONE none == 0 there is no value NONE
    */
   private int none = 0;

   // ######################################################################

   /**
    * Constructor for class JglComboBoxModel
    *
    * @param container  No description provided
    * @param none       No description provided
    */
   public JglComboBoxModel (Collection container, boolean none)
   {
      super (container);
      this.none =  (none == false) ? 0 : 1;
   }


   /**
    * Constructor for class JglComboBoxModel
    *
    * @param container  No description provided
    * @param none       No description provided
    */
   public JglComboBoxModel (Map container, boolean none)
   {
      super (container);
      this.none =  (none == false) ? 0 : 1;
   }

   // ######################################################################

   /**
    * Get the size attribute of the JglComboBoxModel object
    *
    * @return   The size value
    */
   public int getSize()
   {
      return super.getSize() + this.none;
   }


   /**
    * Get the elementAt attribute of the JglComboBoxModel object
    *
    * @param index  No description provided
    * @return       The elementAt value
    */
   public java.lang.Object getElementAt (int index)
   {
      if (index == 0 && this.none != 0)
      {
         return NONE;
      }
      return super.getElementAt (index - this.none);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private java.lang.Object selectedItem = null;


   /**
    * Sets the selectedItem attribute of the JglComboBoxModel object
    *
    * @param anItem  The new selectedItem value
    */
   public void setSelectedItem (java.lang.Object anItem)
   {
      this.selectedItem = anItem;
      this.fireContentsChanged (this, -1, -1);
   }


   /**
    * Get the selectedItem attribute of the JglComboBoxModel object
    *
    * @return   The selectedItem value
    */
   public java.lang.Object getSelectedItem()
   {
      return this.selectedItem;
   }
}

/*
 * $Log: JglComboBoxModel.java,v $
 * Revision 1.15  2004/10/20 17:49:56  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
