/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gui;

import de.uni_paderborn.fujaba.metamodel.FAttr;
import de.uni_paderborn.fujaba.metamodel.FClass;


/**
 * TemplateBlockListeners can alter a for a template block by implementing the method getTemplateBlockName.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.5 $
 */
public interface TemplateBlockNameListener
{
   /**
    * A TemplateBlockNameListener can alter a name for a template block by implementing this
    * method (e.g. append a suffix). All block names for associations are passed through this
    * method.
    *
    * @param blockName  the current name of the template block to be aquired
    * @param cls        class that has the association/attribute
    * @param attr       attribute of the association
    * @return           the altered name of the template block
    */
   String getTemplateBlockName (String blockName, FClass cls, FAttr attr);
}

/*
 * $Log: TemplateBlockNameListener.java,v $
 * Revision 1.5  2004/10/20 17:49:55  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
