/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gui;

import java.awt.*;

import javax.swing.*;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.uml.*;
import de.uni_paderborn.fujaba.views.ViewDiagram;


/**
 * @author    $Author: cschneid $
 * @version   $Revision: 1.20 $
 */
public class StoryActivityPanel extends ActivityPanel
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JTextField nameTextField;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JCheckBox typeCheckBox;


   /**
    * Constructor for class StoryActivityPanel
    *
    * @param asgElement  No description provided
    */
   public StoryActivityPanel (ASGElement asgElement)
   {
      setAsgElement (asgElement);

      if (isResponsible())
      {
         setLayout (new BorderLayout());

         GridBagLayout gridBag = new GridBagLayout();
         GridBagConstraints constraints = new GridBagConstraints();

         constraints.fill = GridBagConstraints.BOTH;
         constraints.gridwidth = GridBagConstraints.REMAINDER;
         constraints.weightx = 1.0;

         JPanel panel = new JPanel();
         panel.setLayout (gridBag);

         JLabel nameLabel = new JLabel ("Name");
         constraints.insets = new Insets (0, 3, 0, 3);
         gridBag.setConstraints (nameLabel, constraints);
         panel.add (nameLabel);

         nameTextField = new JTextField();
         constraints.insets = new Insets (0, 3, 0, 3);
         gridBag.setConstraints (nameTextField, constraints);
         panel.add (nameTextField);

         typeCheckBox = new JCheckBox ("\"For Each\"-Activity");
         constraints.insets = new Insets (8, 3, 0, 3);
         gridBag.setConstraints (typeCheckBox, constraints);
         panel.add (typeCheckBox);

         add (panel, BorderLayout.NORTH);
      }
   } // constructor


   /**
    * Get the name attribute of the StoryActivityPanel object
    *
    * @return   The name value
    */
   public String getName()
   {
      return "Story";
   } // getName


   /**
    * Get the responsible attribute of the StoryActivityPanel object
    *
    * @return   The responsible value
    */
   public boolean isResponsible()
   {
      return  ( (getAsgElement() instanceof UMLStoryActivity) ||
          (getAsgElement() instanceof UMLActivityDiagram) ||
          (getAsgElement() instanceof ViewDiagram &&  ((ViewDiagram) getAsgElement()).getOriginalDiagram() instanceof UMLActivityDiagram));
   } // isResponsible


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public UMLActivity parse()
   {
      if (getAsgElement() != null)
      {
         ASGElement incr = getAsgElement();
         if (incr instanceof UMLDiagram)
         {
            UMLDiagram diag = (UMLDiagram) getAsgElement();
            UMLActivityDiagram actDiag = null;
            UMLStoryActivity story = null;

            if (diag instanceof UMLActivityDiagram)
            {
               actDiag = (UMLActivityDiagram) diag;
            }
            else if (diag instanceof ViewDiagram &&  ((ViewDiagram) diag).getOriginalDiagram() instanceof UMLActivityDiagram)
            {
               actDiag = (UMLActivityDiagram)  ((ViewDiagram) diag).getOriginalDiagram();
            }
            else
            {
               return null;
            }

            // create a new UMLStoryActivity
            if (actDiag.belongsToState())
            {
               UMLComplexState complexState = new UMLComplexState();
               UMLStoryPattern storyPattern = new UMLStoryPattern (nameTextField.getText(), UMLProject.get(),
                  UMLStoryPattern.STORYPATTERN, null);
               story = new UMLStoryActivity (typeCheckBox.isSelected(), storyPattern);

               complexState.setName (nameTextField.getText());
               complexState.setStory (story);
               diag.addToElements (complexState);
               return complexState;
            }
            else
            {
               UMLStoryPattern storyPattern = new UMLStoryPattern (nameTextField.getText(), UMLProject.get(),
                  UMLStoryPattern.STORYPATTERN, null);
               story = new UMLStoryActivity (typeCheckBox.isSelected(), storyPattern);

               diag.addToElements (story);
               return story;
            }
         }
         else if (incr instanceof UMLStoryActivity)
         {
            UMLStoryActivity umlStoryActivity = (UMLStoryActivity) incr;

            umlStoryActivity.setForEach (typeCheckBox.isSelected());
            UMLStoryPattern storyPattern = umlStoryActivity.getStoryPattern();
            if (storyPattern != null)
            {
               storyPattern.setName (nameTextField.getText());
            }
            return umlStoryActivity;
         }
         else
         {
            return null;
         }
      }
      else
      {
         return null;
      }
   } // parse


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void unparse()
   {
      if (getAsgElement() != null)
      {
         ASGElement incr = getAsgElement();
         if (incr instanceof UMLDiagram)
         {
            UMLDiagram diag = (UMLDiagram) getAsgElement();
            UMLActivityDiagram actDiag = null;

            if (diag instanceof UMLActivityDiagram)
            {
               actDiag = (UMLActivityDiagram) diag;
            }
            else if (diag instanceof ViewDiagram &&  ((ViewDiagram) diag).getOriginalDiagram() instanceof UMLActivityDiagram)
            {
               actDiag = (UMLActivityDiagram)  ((ViewDiagram) diag).getOriginalDiagram();
            }
            else
            {
               return;
            }

            // init. the value
            typeCheckBox.setEnabled (!actDiag.belongsToState());
            nameTextField.setText ("");
            typeCheckBox.setSelected (false);
         }
         else if (incr instanceof UMLStoryActivity)
         {
            // edit an existing Story
            try
            {
               typeCheckBox.setEnabled (! ((UMLActivityDiagram)  ((UMLStoryActivity) incr).
                  getFirstFromDiagrams()).belongsToState());
            }
            catch (Exception e)
            {
               typeCheckBox.setEnabled (true);
            }
            typeCheckBox.setSelected ( ((UMLStoryActivity) incr).isForEach());
            UMLStoryPattern story =  ((UMLStoryActivity) incr).getStoryPattern();
            if (story != null)
            {
               nameTextField.setText (story.getName());
            }
         }
      }
   } // unparse

}

/*
 * $Log: StoryActivityPanel.java,v $
 * Revision 1.20  2005/01/27 15:44:47  cschneid
 * bugfixes, new libraries, SDMObjectDialog improved, add activity in transition
 *
 */
