/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gui;

import java.awt.*;
import java.util.Iterator;

import javax.swing.*;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.uml.*;
import de.uni_paderborn.fujaba.views.ViewDiagram;
import de.upb.tools.fca.FHashSet;


/**
 * @author    $Author: cschneid $
 * @version   $Revision: 1.32 $
 */
public class StopActivityPanel extends ActivityPanel
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   //private JTextField textFieldReturnValue;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JComboBox objectsComboBox;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JCheckBox checkBoxGenerateCode;


   /**
    * Constructor for class StopActivityPanel
    *
    * @param asgElement  No description provided
    */
   public StopActivityPanel (ASGElement asgElement)
   {
      setAsgElement (asgElement);

      if (isResponsible())
      {
         setLayout (new BorderLayout());

         GridBagLayout gridBag = new GridBagLayout();
         GridBagConstraints constraints = new GridBagConstraints();

         JPanel panel = new JPanel();
         panel.setLayout (gridBag);

         constraints.fill = GridBagConstraints.BOTH;
         constraints.gridwidth = GridBagConstraints.REMAINDER;
         constraints.weightx = 1.0;

         /*
          *  JLabel valueLabel = new JLabel ("Return Value");
          *  constraints.insets = new Insets (0, 3, 0, 3);
          *  gridBag.setConstraints (valueLabel, constraints);
          *  panel.add (valueLabel);
          *  textFieldReturnValue = new JTextField();
          *  constraints.insets = new Insets (0, 3, 0, 3);
          *  gridBag.setConstraints (textFieldReturnValue, constraints);
          *  panel.add (textFieldReturnValue);
          */
         JLabel objectLabel = new JLabel ("Return Object");
         constraints.insets = new Insets (8, 3, 0, 3);
         gridBag.setConstraints (objectLabel, constraints);
         panel.add (objectLabel);

         objectsComboBox = new JComboBox();
         constraints.insets = new Insets (0, 3, 0, 3);
         gridBag.setConstraints (objectsComboBox, constraints);
         panel.add (objectsComboBox);
         objectsComboBox.setEditable (true);

         checkBoxGenerateCode = new JCheckBox ("Generate Code");
         checkBoxGenerateCode.setSelected (true);
         constraints.insets = new Insets (8, 3, 0, 3);
         gridBag.setConstraints (checkBoxGenerateCode, constraints);
         panel.add (checkBoxGenerateCode);

         add (panel, BorderLayout.NORTH);
      }
   } // constructor


   /**
    * Get the name attribute of the StopActivityPanel object
    *
    * @return   The name value
    */
   public String getName()
   {
      return "Stop";
   } // getName


   /**
    * Get the responsible attribute of the StopActivityPanel object
    *
    * @return   The responsible value
    */
   public boolean isResponsible()
   {
      return  ( (getAsgElement() instanceof UMLStopActivity) ||
          (getAsgElement() instanceof UMLActivityDiagram) ||
          (getAsgElement() instanceof ViewDiagram &&  ((ViewDiagram) getAsgElement()).getOriginalDiagram() instanceof UMLActivityDiagram));
   } // isResponsible


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param diag  No description provided
    */
   private void fillObjectsComboBox (UMLActivityDiagram diag)
   {
      if (diag != null)
      {
         FHashSet objects = new FHashSet();
         Iterator iter = diag.iteratorOfObjects();
         if (iter != null)
         {
            UMLObject object = null;
            while (iter.hasNext())
            {
               object = (UMLObject) iter.next();
               String text = object.getText();
               if (!objects.contains (text))
               {
                  objects.add (text);
                  objectsComboBox.addItem (text);
               }
            }
         }
      }
   } // fillObjectsComboBox


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public UMLActivity parse()
   {
      ASGElement incr = getAsgElement();
      UMLStopActivity stop = null;

      if (incr instanceof UMLActivityDiagram ||
          (incr instanceof ViewDiagram &&  ((ViewDiagram) incr).getOriginalDiagram() instanceof UMLActivityDiagram))
      {
         UMLActivityDiagram diag = (UMLActivityDiagram) getAsgElement();

         if (diag.getRevContains() == null && diag != null)
         {
            stop = new UMLStopActivity (checkBoxGenerateCode.isSelected(), (String) objectsComboBox.getSelectedItem());
            diag.addToElements (stop);
         }
         else
         {
            JOptionPane.showMessageDialog (null, "You only can add a stop activity in the uttermost state.", "error", JOptionPane.ERROR_MESSAGE);
         }
      }
      else if (incr instanceof UMLStopActivity)
      {
         stop = (UMLStopActivity) incr;
         if (stop != null)
         {
            stop.setReturnValue ((String) objectsComboBox.getSelectedItem());
            stop.setGenerateCode (checkBoxGenerateCode.isSelected());
         }
      }
      return stop;
   } // parse


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void unparse()
   {
      ASGElement incr = getAsgElement();
      objectsComboBox.addItem ("");
      objectsComboBox.addItem ("null");
      if (incr instanceof UMLActivityDiagram)
      {
         fillObjectsComboBox ((UMLActivityDiagram) incr);
         checkBoxGenerateCode.setSelected (true);
      }
      else if (incr instanceof ViewDiagram &&  ((ViewDiagram) incr).getOriginalDiagram() instanceof UMLActivityDiagram)
      {
         fillObjectsComboBox ((UMLActivityDiagram)  ((ViewDiagram) incr).getOriginalDiagram());
         checkBoxGenerateCode.setSelected (true);
      }
      else if (incr instanceof UMLStopActivity)
      {
         UMLStopActivity stop = (UMLStopActivity) incr;
         checkBoxGenerateCode.setSelected (stop.isGenerateCode());
         Iterator diags = stop.iteratorOfDiagrams();

         if (diags != null)
         {
            UMLDiagram diag = null;
            while (diags.hasNext())
            {
               diag = (UMLDiagram) diags.next();
               if (diag instanceof UMLActivityDiagram)
               {
                  fillObjectsComboBox ((UMLActivityDiagram) diag);
               }
            }
         }
         objectsComboBox.setSelectedItem (stop.getReturnValue());
      }
   } // unparse

}

/*
 * $Log: StopActivityPanel.java,v $
 * Revision 1.32  2005/01/27 15:44:47  cschneid
 * bugfixes, new libraries, SDMObjectDialog improved, add activity in transition
 *
 */
