/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gui;

import java.awt.*;

import javax.swing.*;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.texteditor.TextEditor;
import de.uni_paderborn.fujaba.uml.*;
import de.uni_paderborn.fujaba.views.ViewDiagram;


/**
 * @author    $Author: cschneid $
 * @version   $Revision: 1.26 $
 */
public class StatementActivityPanel extends ActivityPanel
{

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JTextArea sourceEditor;

   /**
    * Instance of text editor buffer to edit a Statement
    */
   TextEditor.Buffer sourceBuffer;

   /**
    * remember action to change dialog
    */
   private TextEditAction textEditAction;


   /**
    * Constructor for class StatementActivityPanel
    *
    * @param asgElement  No description provided
    */

   public StatementActivityPanel (ASGElement asgElement)
   {
      setAsgElement (asgElement);

      if (isResponsible())
      {
         GridBagLayout gridBag = new GridBagLayout();
         GridBagConstraints constraints = new GridBagConstraints();

         setLayout (gridBag);

         constraints.fill = GridBagConstraints.BOTH;
         constraints.gridwidth = GridBagConstraints.REMAINDER;
         constraints.anchor = GridBagConstraints.NORTH;
         constraints.weightx = 1.0;

         JLabel statementLabel = new JLabel ("Statement");
         constraints.insets = new Insets (0, 3, 0, 3);
         gridBag.setConstraints (statementLabel, constraints);
         add (statementLabel);

         sourceEditor = new JTextArea();
         sourceEditor.setToolTipText ("Edit Statement");
         sourceEditor.setColumns (30);
         sourceEditor.setRows (5);

         JScrollPane scrollPane = new JScrollPane (sourceEditor);
         constraints.weighty = 1.0;
         constraints.insets = new Insets (0, 3, 3, 3);
         gridBag.setConstraints (scrollPane, constraints);
         add (scrollPane);

         JPanel buttonPanel = new JPanel();
         buttonPanel.setLayout (new FlowLayout (FlowLayout.CENTER));
         JButton textEditButton = new JButton ("Open in editor");
         textEditAction = new TextEditAction (getActivityDialog(), sourceEditor);
         textEditButton.addActionListener (textEditAction);
         gridBag.setConstraints (textEditButton, constraints);
         buttonPanel.add (textEditButton);
         add (buttonPanel);
      }
   } // constructor


   /**
    * Sets the activityDialog attribute of the ActivityPanel object
    *
    * @param elem  The new activityDialog value
    */
   public void setActivityDialog (EditActivityDialog elem)
   {
      super.setActivityDialog (elem);
      if (isResponsible() && textEditAction != null)
      {
         textEditAction.setDialog (elem);
      }
   } // setActivityDialog


   /**
    * Get the name attribute of the StatementActivityPanel object
    *
    * @return   The name value
    */
   public String getName()
   {
      return "Statement";
   } // getName


   /**
    * Get the responsible attribute of the StatementActivityPanel object
    *
    * @return   The responsible value
    */
   public boolean isResponsible()
   {
      return  ( (getAsgElement() instanceof UMLStatementActivity) ||
          (getAsgElement() instanceof UMLActivityDiagram) ||
          (getAsgElement() instanceof ViewDiagram &&  ((ViewDiagram) getAsgElement()).getOriginalDiagram() instanceof UMLActivityDiagram));
   } // isResponsible


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public UMLActivity parse()
   {
      UMLStatementActivity activity = null;

      if (getAsgElement() instanceof UMLActivityDiagram ||
          (getAsgElement() instanceof ViewDiagram &&  ((ViewDiagram) getAsgElement()).getOriginalDiagram() instanceof UMLActivityDiagram))
      {
         // create a new object of type UMLStatement and UMLActivityStatement
         UMLDiagram diag = (UMLDiagram) getAsgElement();

         UMLStatement statement = new UMLStatement (sourceEditor.getText(), null);
         activity = new UMLStatementActivity (statement);
         diag.addToElements (activity);
      }
      else if (getAsgElement() instanceof UMLStatementActivity)
      {
         activity = (UMLStatementActivity) getAsgElement();
         if (activity != null)
         {
            if (activity.getState() != null)
            {
               activity.getState().setStatement (sourceEditor.getText());
            }
            else
            {
               activity.setState (new UMLStatement (sourceEditor.getText(), null));
            }
         }
      }
      return activity;
   } // parse


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void unparse()
   {
      if (getAsgElement() instanceof UMLStatementActivity)
      {
         // edit a ActivityStatement object
         UMLStatementActivity activity = (UMLStatementActivity) getAsgElement();
         if (activity != null)
         {
            UMLStatement statement = activity.getState();
            if (statement != null)
            {
               sourceEditor.append (statement.getStatement());
            }
         }
         else
         {
            // init value
            sourceEditor.setText ("");
         }
      }
   } // unparse

}

/*
 * $Log: StatementActivityPanel.java,v $
 * Revision 1.26  2005/01/27 15:44:47  cschneid
 * bugfixes, new libraries, SDMObjectDialog improved, add activity in transition
 *
 */
