/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gui;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.util.Vector;

import javax.swing.*;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.fsa.actions.KillDisplay;
import de.uni_paderborn.fujaba.uml.*;
import de.uni_paderborn.tools.util.MethodDeclaration;
import de.upb.lib.userinterface.UserInterfaceManager;


/**
 * This panel works with the Refactorings plugin only.
 *
 * @author    christian.schneider@uni-kassel.de
 * @version   $Revision: 1.4 $ $Date: 2005/02/24 15:54:50 $
 */
public class StartActivityPanelForMethod extends ActivityPanel
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JTextField signatureTextField;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private AbstractAction changeSignatureAction;


   /**
    *Constructor for class StartActivityPanelForMethod
    *
    * @param asgElement  No description provided
    */
   public StartActivityPanelForMethod (ASGElement asgElement)
   {
      setAsgElement (asgElement);
      changeSignatureAction = UserInterfaceManager.get().getFromActions ("refactor.changeSignature");

      if (isResponsible())
      {
         init();
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private void init()
   {
      setLayout (new BorderLayout());

      GridBagLayout gridBag = new GridBagLayout();
      GridBagConstraints constraints = new GridBagConstraints();

      constraints.fill = GridBagConstraints.BOTH;
      constraints.gridwidth = GridBagConstraints.REMAINDER;
      constraints.weightx = 1.0;

      JPanel panel = new JPanel();
      panel.setLayout (gridBag);

      JLabel nameLabel = new JLabel ("Method Signature");
      constraints.insets = new Insets (0, 3, 0, 3);
      gridBag.setConstraints (nameLabel, constraints);
      panel.add (nameLabel);

      signatureTextField = new JTextField();
      constraints.insets = new Insets (0, 3, 0, 3);
      gridBag.setConstraints (signatureTextField, constraints);
      panel.add (signatureTextField);

      add (panel, BorderLayout.NORTH);
   }


   /**
    * Returns the name of this panel.
    *
    * @return   The name value
    */
   public String getName()
   {
      return "Method start";
   }


   /**
    * Returns true, if panel is responsible for the umlIncrement.
    *
    * @return   The responsible value
    */
   public boolean isResponsible()
   {
      return changeSignatureAction != null && getMethod() != null;
   }


   /**
    * Get the method attribute of the StartActivityPanelForMethod object
    *
    * @return   The method value
    */
   private UMLMethod getMethod()
   {
      UMLMethod method;
      if (getAsgElement() instanceof UMLStartActivity)
      {
         UMLStartActivity startActivity = (UMLStartActivity) getAsgElement();
         method = startActivity.getSpec();
      }
      else
      {
         method = null;
      }
      return method;
   }


   /**
    * Catch all info from panel and change an existing or add a new ASGElement.
    *
    * @return   No description provided
    */
   public UMLActivity parse()
   {
      Vector params = new Vector (2);
      params.add (getMethod());
      params.add (signatureTextField.getText());
      changeSignatureAction.actionPerformed (new ActionEvent (params.iterator(), 0, null));

      //FIX ME the following should not be neccessary if start activities would update correctly
      new KillDisplay().actionPerformed (null);

      return (UMLActivity) getAsgElement();
   }


   /**
    * Catch all info from existing ASGElement and fill all elements from panel.
    */
   public void unparse()
   {
      UMLMethod method = getMethod();
      String signature = MethodDeclaration.userReadableSignature (method);

      signatureTextField.setText (signature);
   }

}

/*
 * $Log: StartActivityPanelForMethod.java,v $
 * Revision 1.4  2005/02/24 15:54:50  lowende
 * Removed some compile warnings.
 *
 */
