/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gui;

import java.awt.*;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.*;

import javax.swing.*;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import de.uni_paderborn.fujaba.app.PanelColumnLayout;
import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.uml.*;
import de.uni_paderborn.fujaba.views.ViewDiagram;
import de.upb.tools.sdm.FComplexState;


/**
 * @author    $Author: cschneid $
 * @version   $Revision: 1.28.2.1 $
 */
public class StartActivityPanel extends ActivityPanel
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JComboBox classesComboBox;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JCheckBox historyCheckBox;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JRadioButton shallowRadioButton;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JRadioButton deepRadioButton;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JList methodsList;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   MethodsListModel methodsListModel;


   /**
    * Constructor for class StartActivityPanel
    *
    * @param asgElement  No description provided
    */
   public StartActivityPanel (ASGElement asgElement)
   {
      setAsgElement (asgElement);

      if (isResponsible())
      {
         if (asgElement instanceof ViewDiagram)
         {
            asgElement =  ((ViewDiagram) asgElement).getOriginalDiagram();
         }
         if ( ( (asgElement instanceof UMLActivityDiagram) &&
             ( ((UMLActivityDiagram) asgElement).belongsToState())) ||
             ( ( (asgElement instanceof UMLStartActivity)) &&
             ( ((UMLStartActivity) asgElement).getActivityDiagram().belongsToState())))
         {
            createStatechartStartEditor();
         }
         else
         {
            createActivityStartEditor();
         }
      }
   } // constructor


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private void createStatechartStartEditor()
   {
      setLayout (new PanelColumnLayout());

      shallowRadioButton = new JRadioButton ("Shallow");
      deepRadioButton = new JRadioButton ("Deep");
      historyCheckBox = new JCheckBox ("History");
      historyCheckBox.addChangeListener (
         new ChangeListener()
         {
            public void stateChanged (ChangeEvent e)
            {
               JCheckBox checkBox = (JCheckBox) e.getSource();
               shallowRadioButton.setEnabled (checkBox.isSelected());
               deepRadioButton.setEnabled (checkBox.isSelected());
            }
         });
      historyCheckBox.setSelected (false);
      add (historyCheckBox);

      ButtonGroup buttonGroup = new ButtonGroup();
      buttonGroup.add (shallowRadioButton);
      buttonGroup.add (deepRadioButton);
      shallowRadioButton.setSelected (true);

      JPanel radioButtonPanel = new JPanel();
      radioButtonPanel.setLayout (new BoxLayout (radioButtonPanel, BoxLayout.X_AXIS));
      radioButtonPanel.add (new JLabel ("       "));

      JPanel rightPanel = new JPanel();
      rightPanel.setLayout (new GridLayout (2, 0));
      rightPanel.add (shallowRadioButton);
      rightPanel.add (deepRadioButton);
      radioButtonPanel.add (rightPanel);

      add (radioButtonPanel);
   } // createStatechartStartEditor


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private void createActivityStartEditor()
   {
      GridBagLayout gridBag = new GridBagLayout();
      GridBagConstraints constraints = new GridBagConstraints();

      setLayout (gridBag);

      constraints.fill = GridBagConstraints.BOTH;
      constraints.gridwidth = GridBagConstraints.REMAINDER;
      constraints.weightx = 1.0;

      JLabel classLabel = new JLabel ("Select Class");
      constraints.insets = new Insets (0, 3, 0, 3);
      gridBag.setConstraints (classLabel, constraints);
      add (classLabel);

      classesComboBox = new JComboBox();
      classesComboBox.setToolTipText ("Select a class for the activity.");
      classesComboBox.addItemListener (new ClassesComboBoxListener());
      constraints.insets = new Insets (0, 3, 0, 3);
      gridBag.setConstraints (classesComboBox, constraints);
      add (classesComboBox);

      JLabel methodLabel = new JLabel ("Select Method");
      constraints.insets = new Insets (8, 3, 0, 3);
      gridBag.setConstraints (methodLabel, constraints);
      add (methodLabel);

      methodsListModel = new MethodsListModel();
      methodsList = new JList (methodsListModel);
      methodsList.setSelectionMode (ListSelectionModel.SINGLE_SELECTION);
      methodsList.setToolTipText ("Select the method for this activity.");

      JScrollPane scrollPane = new JScrollPane (methodsList);
      constraints.insets = new Insets (0, 3, 3, 3);
      constraints.weighty = 1.0;
      gridBag.setConstraints (scrollPane, constraints);
      add (scrollPane);
   } // createActivityStartEditor


   /**
    * Get the name attribute of the StartActivityPanel object
    *
    * @return   The name value
    */
   public String getName()
   {
      return "Start";
   } // getName


   /**
    * Get the responsible attribute of the StartActivityPanel object
    *
    * @return   The responsible value
    */
   public boolean isResponsible()
   {
      boolean responsible = false;

      ASGElement incr = getAsgElement();
      if (incr instanceof UMLActivityDiagram ||
          (incr instanceof ViewDiagram &&  ((ViewDiagram) incr).getOriginalDiagram() instanceof UMLActivityDiagram))
      {
         responsible = true;
      }
      else if (incr instanceof UMLStartActivity)
      {
         UMLActivityDiagram actDiagram =  ((UMLStartActivity) incr).getActivityDiagram();
         if (actDiagram.belongsToState())
         {
            responsible = true;
         }
      }

      return responsible;
   } // isResponsible


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public UMLActivity parse()
   {
      UMLStartActivity start = null;

      if (getAsgElement() instanceof UMLDiagram)
      {
         UMLDiagram diag = (UMLDiagram) getAsgElement();
         UMLActivityDiagram actDiag = null;

         if (diag instanceof UMLActivityDiagram)
         {
            actDiag = (UMLActivityDiagram) diag;
         }
         else if (diag instanceof ViewDiagram &&  ((ViewDiagram) diag).getOriginalDiagram() instanceof UMLActivityDiagram)
         {
            actDiag = (UMLActivityDiagram)  ((ViewDiagram) diag).getOriginalDiagram();
         }
         else
         {
            return null;
         }

         if (actDiag.belongsToState())
         {
            start = new UMLStartActivity();

            if (historyCheckBox.isSelected())
            {
               if (deepRadioButton.isSelected())
               {
                  start.setHistoryKind (FComplexState.HISTORY_DEEP);
               }
               else if (shallowRadioButton.isSelected())
               {
                  start.setHistoryKind (FComplexState.HISTORY_SHALLOW);
               }
            }

            diag.addToElements (start);
         }
         else
         {
            if (methodsList.getSelectedIndex() >= 0)
            {
               UMLMethod selectedMethod = methodsListModel.getMethodAt (methodsList.getSelectedIndex());
               if (selectedMethod != null)
               {
                  start = new UMLStartActivity (selectedMethod);
                  diag.addToElements (start);
               }
            }
            else
            {
               start = new UMLStartActivity();
               diag.addToElements (start);
            }
         }
      }
      else if (getAsgElement() instanceof UMLStartActivity)
      {
         start = (UMLStartActivity) getAsgElement();

         if (historyCheckBox.isSelected())
         {
            if (deepRadioButton.isSelected())
            {
               start.setHistoryKind (FComplexState.HISTORY_DEEP);
            }
            else if (shallowRadioButton.isSelected())
            {
               start.setHistoryKind (FComplexState.HISTORY_SHALLOW);
            }
         }
         else
         {
            start.setHistoryKind (FComplexState.HISTORY_NONE);
         }
      }
      return start;
   } // parse


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void unparse()
   {
      if (getAsgElement() instanceof UMLStartActivity)
      {
         UMLStartActivity startActivity = (UMLStartActivity) getAsgElement();
         if (startActivity.isHistory())
         {
            historyCheckBox.setSelected (true);
            if (startActivity.getHistoryKind() == FComplexState.HISTORY_DEEP)
            {
               deepRadioButton.setSelected (true);
            }
            else
            {
               shallowRadioButton.setSelected (true);
            }
         }
      }
      else if (getAsgElement() instanceof UMLDiagram)
      {
         UMLDiagram diag = (UMLDiagram) getAsgElement();
         UMLActivityDiagram actDiag = null;

         if (diag instanceof UMLActivityDiagram)
         {
            actDiag = (UMLActivityDiagram) diag;
         }
         else if (diag instanceof ViewDiagram &&  ((ViewDiagram) diag).getOriginalDiagram() instanceof UMLActivityDiagram)
         {
            actDiag = (UMLActivityDiagram)  ((ViewDiagram) diag).getOriginalDiagram();
         }

         if (!actDiag.belongsToState())
         {
            UMLProject proj = UMLProject.get();
            if (proj != null)
            {
               Enumeration classes = proj.elementsOfClasses();
               if (classes != null)
               {
                  while (classes.hasMoreElements())
                  {
                     classesComboBox.addItem (classes.nextElement());
                  }
               }
               if (classesComboBox.getItemCount() > 0)
               {
                  classesComboBox.setSelectedIndex (0);
               }
            }
         }
      }
   } // unparse

   //------------------------------ some inner classes ------------------------------

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: cschneid $
    * @version   $Revision: 1.28.2.1 $
    */
   private class ClassesComboBoxListener implements ItemListener
   {
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void itemStateChanged (ItemEvent e)
      {
         JComboBox comboBox = (JComboBox) e.getSource();
         UMLClass currentClass = (UMLClass) comboBox.getSelectedItem();
         if (currentClass != null)
         {
            Iterator methodIter = currentClass.iteratorOfMethods();
            UMLMethod method = null;
            Vector vector = new Vector();
            while (methodIter.hasNext())
            {
               method = (UMLMethod) methodIter.next();
               // ignore all bound methods
               if (method.getRevSpec() == null)
               {
                  vector.add (method);
               }
            }
            methodsListModel.setMethods (vector);
         }
      }
   } // ClassesComboBoxListener


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: cschneid $
    * @version   $Revision: 1.28.2.1 $
    */
   private class MethodsListModel extends AbstractListModel
   {
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      private Vector methods;


      /**
       * Constructor for class MethodsListModel
       */
      public MethodsListModel()
      {
         methods = new Vector();
      } // constructor


      /**
       * Sets the methods attribute of the MethodsListModel object
       *
       * @param methods  The new methods value
       */
      public void setMethods (Vector methods)
      {
         this.methods = methods;
         fireContentsChanged (this, 0, methods.size());
      } // constructor


      /**
       * Get the elementAt attribute of the MethodsListModel object
       *
       * @param index  No description provided
       * @return       The elementAt value
       */
      public Object getElementAt (int index)
      {
         return  ((UMLMethod) methods.elementAt (index)).getText();
      } // getElementAt


      /**
       * Get the methodAt attribute of the MethodsListModel object
       *
       * @param index  No description provided
       * @return       The methodAt value
       */
      public UMLMethod getMethodAt (int index)
      {
         return (UMLMethod) methods.elementAt (index);
      } //getMethodAt


      /**
       * Get the size attribute of the MethodsListModel object
       *
       * @return   The size value
       */
      public int getSize()
      {
         return methods.size();
      } // getSize

   } // AbstractListModel

}

/*
 * $Log: StartActivityPanel.java,v $
 * Revision 1.28.2.1  2005/08/19 13:54:40  cschneid
 * create start activity now possible without attached method or statechart
 *
 */
