/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gui;

import java.awt.event.*;

import javax.swing.*;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.24 $
 */
public class PETextField extends PEHeaderComponent
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JTextField textField;


   /**
    * Constructor for class PETextField
    *
    * @param parent  No description provided
    * @param title   No description provided
    */
   public PETextField (BasicPropertyEditor parent, String title)
   {
      super (parent, title);

      textField.addFocusListener (new PETextFieldFocusListener (this));
   }


   /**
    * Constructor for class PETextField
    *
    * @param parent  No description provided
    * @param title   No description provided
    * @param value   No description provided
    */
   public PETextField (BasicPropertyEditor parent, String title, String value)
   {
      this (parent, title);
      setText (value);
   }


   /**
    * Access method for an one to n association.
    *
    * @param kl  The object added.
    */
   public void addKeyListener (KeyListener kl)
   {
      super.addKeyListener (kl);
      textField.addKeyListener (kl);
   }


   /**
    * Sets the readOnly attribute of the PETextField object
    *
    * @param b  The new readOnly value
    */
   public void setReadOnly (boolean b)
   {
      textField.setEditable (!b);
   }


   /**
    * Get the editable status of the textfield
    *
    * @return   false, if the textfield is editable, true, if the textfield is read only
    */
   public boolean isReadOnly()
   {
      return  (! (textField.isEditable()));
   } // isReadOnly


   /**
    * Access method for an one to n association.
    */
   public void addComponents()
   {
      textField = new JTextField();
      add (textField);
   }


   /**
    * Necessary access methods to added component
    *
    * @return   The text value
    */
   public String getText()
   {
      return textField.getText();
   }


   /**
    * Sets the text attribute of the PETextField object
    *
    * @param text  The new text value
    */
   public void setText (String text)
   {
      textField.setText (text);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void selectAll()
   {
      textField.selectAll();
   }


   /**
    * Get the horzResizable attribute of the PETextField object
    *
    * @return   The horzResizable value
    */
   public boolean isHorzResizable()
   {
      return false;
   }


   /**
    * Get the vertResizable attribute of the PETextField object
    *
    * @return   The vertResizable value
    */
   public boolean isVertResizable()
   {
      return true;
   }


   /**
    * Adds an ActionListener. The listener simply will become registered as ActionListener
    * at the textField
    *
    * @param listener  The object added.
    */
   public void addActionListener (ActionListener listener)
   {
      textField.addActionListener (listener);
   } // addActionListener


   /**
    * Removes an ActionListener
    *
    * @param listener  No description provided
    */
   public void removeActionListener (ActionListener listener)
   {
      textField.removeActionListener (listener);
   } // removeActionListener


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void focusGained()
   {
      super.focusGained();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void focusLost()
   {
      super.focusLost();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void requestFocus()
   {
      textField.requestFocus();
   }
}


/**
 * This is the FocusListener for the class PETextField. The original FocusAdapter in class
 * PEBaseComponent did not work. <br>
 * This FocusListener has to invoke the focusGained() and focusLost() methods in the superclass
 * PEBaseComponent.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.24 $
 */
class PETextFieldFocusListener implements FocusListener
{


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   PETextField text;


   /**
    * Constructor for class PETextFieldFocusListener
    *
    * @param text  No description provided
    */
   PETextFieldFocusListener (PETextField text)
   {
      this.text = text;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void focusGained (FocusEvent e)
   {
      text.focusGained();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void focusLost (FocusEvent e)
   {
      text.focusLost();
   }
}

/*
 * $Log: PETextField.java,v $
 * Revision 1.24  2004/10/20 17:49:54  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
