/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gui;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;

import javax.swing.*;
import javax.swing.border.TitledBorder;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.18 $
 */
public class PERadioGroup extends PEBaseComponent
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private ButtonGroup group;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String[] radionames = null;


   /**
    * Constructor for class PERadioGroup
    *
    * @param parent  No description provided
    * @param title   No description provided
    * @param names   No description provided
    */
   public PERadioGroup (BasicPropertyEditor parent, String title, String[] names)
   {
      super (parent);
      setBorder (new TitledBorder (title));
      setLayout (new GridLayout (0, 1));
      // setLayout (getLayoutManager ());
      radionames = new String[names.length];
      for (int i = 0; i < names.length; i++)
      {
         radionames[i] = names[i];
      }
      addComponents();
   }


   /**
    * Get the group attribute of the PERadioGroup object
    *
    * @return   The group value
    */
   public ButtonGroup getGroup()
   {
      return this.group;
   } // getGroup


   /**
    * Sets the readOnly attribute of the PERadioGroup object
    *
    * @param b  The new readOnly value
    */
   public void setReadOnly (boolean b)
   {
   }


   /**
    * Access method for an one to n association.
    */
   public void addComponents()
   {
      // once called from parent constructor,
      // 2nd time from this constructor
      if ( (parent == null) ||  (radionames == null))
      {
         return;
      }

      group = new ButtonGroup();
      JRadioButton button;
      for (int i = 0; i < radionames.length; i++)
      {
         button = new JRadioButton (radionames[i]);
         group.add (button);
         if (i == 0)
         {
            button.setSelected (true);
         }
         add (button);

         // thsa : added listener to button
         button.addActionListener (new RadioButtonListener (parent, radionames[i]));
      }
   }


   /**
    * Sets the enabled attribute of the PERadioGroup object
    *
    * @param enabled  The new enabled value
    */
   public void setEnabled (boolean enabled)
   {
      Enumeration buttons = group.getElements();
      JRadioButton button;

      while (buttons.hasMoreElements())
      {
         button = (JRadioButton) buttons.nextElement();
         button.setEnabled (enabled);
      }

   }


   /**
    * Sets the selectedButtonIndex attribute of the PERadioGroup object
    *
    * @param index  The new selectedButtonIndex value
    */
   public void setSelectedButtonIndex (int index)
   {
      Enumeration buttons = group.getElements();
      int i = 0;
      if (buttons != null)
      {
         JRadioButton button = null;
         while ( (buttons.hasMoreElements()) &&  (i <= index))
         {
            button = (JRadioButton) buttons.nextElement();
            i++;
         }
         if ( (i == index + 1) &&  (button != null))
         {
            button.setSelected (true);
         }
      }
   }


   /**
    * Get the selectedButtonIndex attribute of the PERadioGroup object
    *
    * @return   The selectedButtonIndex value
    */
   public int getSelectedButtonIndex()
   {
      Enumeration buttons = group.getElements();
      int i = 0;
      if (buttons != null)
      {
         while (buttons.hasMoreElements())
         {
            JRadioButton button = (JRadioButton) buttons.nextElement();
            if (button.isSelected())
            {
               return i;
            }
            i++;
         }
      }
      return -1;
   }


   /**
    * Get the horzResizable attribute of the PERadioGroup object
    *
    * @return   The horzResizable value
    */
   public boolean isHorzResizable()
   {
      boolean resizable = false;
      Enumeration buttons = group.getElements();
      if (buttons != null)
      {
         Object button = null;
         while (buttons.hasMoreElements())
         {
            button = buttons.nextElement();
            if (button instanceof PEBaseComponent)
            {
               if ( ((PEBaseComponent) button).isHorzResizable())
               {
                  resizable = true;
               }
            }
         }
      }
      return resizable;
   }


   /**
    * Get the vertResizable attribute of the PERadioGroup object
    *
    * @return   The vertResizable value
    */
   public boolean isVertResizable()
   {
      boolean resizable = false;
      Enumeration buttons = group.getElements();
      if (buttons != null)
      {
         Object button = null;
         while (buttons.hasMoreElements())
         {
            button = buttons.nextElement();
            if (button instanceof PEBaseComponent)
            {
               if ( ((PEBaseComponent) button).isVertResizable())
               {
                  resizable = true;
               }
            }
         }
      }
      return resizable;
   }
}


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.18 $
 */
class RadioButtonListener implements ActionListener
{


   /**
    * Constructor for class RadioButtonListener
    *
    * @param adaptee  No description provided
    * @param ident    No description provided
    */
   public RadioButtonListener (BasicPropertyEditor adaptee, String ident)
   {
      this.adaptee = adaptee;
      this.ident = ident;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void actionPerformed (ActionEvent e)
   {
      adaptee.buttonActionPerformed (ident, e);
   }

   //////////////////////////////////////////////////////////////////////

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private BasicPropertyEditor adaptee;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String ident;
}

/*
 * $Log: PERadioGroup.java,v $
 * Revision 1.18  2004/11/03 10:18:04  lowende
 * Javadoc warnings removed.
 *
 */
