/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gui;

import java.awt.event.*;
import java.util.Enumeration;
import java.util.Iterator;

import javax.swing.*;
import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.uml.*;
import de.upb.tools.fca.FLinkedList;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: cschneid $
 * @version   $Revision: 1.69.2.1 $
 */
public class PEParameters extends PropertyEditor
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (PEParameters.class);

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private FLinkedList addParameters = new FLinkedList();
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private FLinkedList delParameters = new FLinkedList();
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private FLinkedList modParameters = new FLinkedList();
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private FLinkedList refClasses = new FLinkedList();
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   PETextField propertyName;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   PEParameterSelection selection;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private PEListIncr methodTypeList;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private ASGElement second = null;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private PECheck pointer = null;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private PECheck callByReference = null;


   /**
    * Constructor for class PEParameters
    *
    * @param frame  No description provided
    * @param title  No description provided
    * @param modal  No description provided
    */
   public PEParameters (JFrame frame, String title, boolean modal)
   {
      super (frame);
      try
      {
         pack();
         this.setTitle ("Parameters Editor: ");
      }
      catch (Exception e)
      {
         e.printStackTrace();
      }
      initPE();
      addFocusListener (new CMAFocusListener (propertyName));
      propertyName.addActionListener (
         new ActionListener()
         {
            public void
               actionPerformed (ActionEvent e)
            {
               addButton_actionPerformed (e);
            }
         }
         );
   }


   /**
    * Constructor for class PEParameters
    *
    * @param frame  No description provided
    */
   public PEParameters (JFrame frame)
   {
      this (frame, "", false);
   }


   /**
    * Constructor for class PEParameters
    *
    * @param frame           No description provided
    * @param modal           No description provided
    * @param methodTypeList  No description provided
    */
   public PEParameters (JFrame frame, boolean modal, PEListIncr methodTypeList)
   {
      this (frame, "", modal);
   }


   /**
    * Constructor for class PEParameters
    *
    * @param frame           No description provided
    * @param title           No description provided
    * @param methodTypeList  No description provided
    */
   public PEParameters (JFrame frame, String title, PEListIncr methodTypeList)
   {
      this (frame, title, false);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param panel  No description provided
    */
   protected void additionalProperties (PEEditPanel panel)
   {
      propertyName = new PETextField (this, "Parameter Name");
      selection = new PEParameterSelection (this);
      propertyName.setText (getPropertyName());
      propertyName.setStatus ("Enter the name of the parameter");

      pointer = new PECheck (this, "Pointer", "pointer of type");
      pointer.setSelected (isPointer());

      callByReference = new PECheck (this, "Call", "call by reference");
      callByReference.setSelected (isCallByReference());

      selection.setAddListener (new PEParameter_addButton_actionAdapter (this));

      selection.setRemoveListener (new
         PEParameter_removeButton_actionAdapter (this));

      selection.setModifyListener (new
         PEParameter_modifyButton_actionAdapter (this));

      selection.setSourceMouseListener (new
         SourceMouseListener (selection.getSource().
         getList()));

      selection.setDestMouseListener (new
         DestMouseListener (selection.getSource().
         getList()));
      PEColumn column = new PEColumn (this);
      column.add (propertyName);

      column.add (pointer);
      column.add (callByReference);

      column.add (selection);
      panel.add (column);
   }


   /**
    * Sets the increment attribute of the PEParameters object
    *
    * @param incr    The new increment value
    * @param second  The new increment value
    */
   public void setIncrement (ASGElement incr, ASGElement second)
   {
      super.setIncrement (incr);
      this.second = second;
      if (incr instanceof UMLMethod)
      {
         propertyName.setReadOnly (isReadOnly());
         setTitle ("Editor: " +  ((UMLMethod) incr).getName());
      }
   }


   /**
    * Sets the propertyName attribute of the PEParameters object
    *
    * @param name  The new propertyName value
    */
   public void setPropertyName (String name)
   {
      propertyName.setText (name);
   }


   /**
    * Sets the pointer attribute of the PEParameters object
    *
    * @param isPointer  The new pointer value
    */
   public void setPointer (boolean isPointer)
   {
      pointer.setSelected (isPointer);
   }


   /**
    * Sets the callByReference attribute of the PEParameters object
    *
    * @param isCallByReference  The new callByReference value
    */
   public void setCallByReference (boolean isCallByReference)
   {
      callByReference.setSelected (isCallByReference);
   }


   /**
    * Sets the paramType attribute of the PEParameters object
    *
    * @param umlIncr  The new paramType value
    */
   public void setParamType (UMLIncrement umlIncr)
   {
      methodTypeList.selectIncrement (umlIncr);
   }


   /**
    * Sets the typeList attribute of the PEParameters object
    *
    * @param typelist  The new typeList value
    */
   public void setTypeList (Enumeration typelist)
   {
      selection.setTypeList (typelist);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected void unparse()
   {
      propertyName.setText (getPropertyName());

      pointer.setSelected (isPointer());
      callByReference.setSelected (isCallByReference());

      propertyName.selectAll();
      selection.setIncrement (getIncrement());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected void parse()
   {
      if (!isReadOnly())
      {
         UMLParam parameter = null;
         ASGElement incr = getIncrement();

         if (incr instanceof UMLMethod)
         {
            Iterator iter = addParameters.iterator();
            while (iter.hasNext())
            {
               parameter = (UMLParam) iter.next();
                ((UMLMethod) incr).addToParam (parameter);
            }
            addParameters.clear();
            iter = modParameters.iterator();
            while (iter.hasNext())
            {
               parameter = (UMLParam) iter.next();
                ((UMLMethod) incr).addToParam (parameter);
            }
            modParameters.clear();
            iter = delParameters.iterator();
            while (iter.hasNext())
            {
               parameter = (UMLParam) iter.next();
                ((UMLMethod) incr).removeFromParam (parameter);
               parameter.removeYou();
            }
            delParameters.clear();
            iter = refClasses.iterator();
            UMLClass refClass = null;
            while (iter.hasNext())
            {
               refClass = (UMLClass) iter.next();
               if ( (second != null) &&  (second instanceof UMLClass))
               {
                  Iterator diags =  ((UMLClass) second).iteratorOfDiagrams();
                  if (diags != null)
                  {
                     UMLDiagram diag = null;
                     while (diags.hasNext())
                     {
                        diag = (UMLDiagram) diags.next();
                        diag.addToElements (refClass);
                     }
                  }
               }
            }
            refClasses.clear();
         }
      }

      else
      {
         if (log.isDebugEnabled())
         {
            log.debug ("Editor in ReadOnly mode.");
         }
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected void cancel()
   {
      addParameters.clear();
      delParameters.clear();
      modParameters.clear();
      refClasses.clear();
      setVisible (false);
      dispose();
   }


   /**
    * Get the propertyName attribute of the PEParameters object
    *
    * @return   The propertyName value
    */
   protected String getPropertyName()
   {
      ASGElement incr = getIncrement();
      if (incr != null)
      {
         if (incr instanceof UMLMethod)
         {
            return "p" + String.valueOf ( ((UMLMethod) incr).sizeOfParam() +
               1);
         }
      }
      return "New Parameter";
   }


   /**
    * Get the pointer attribute of the PEParameters object
    *
    * @return   The pointer value
    */
   protected boolean isPointer()
   {
      return false;
   }


   /**
    * Get the callByReference attribute of the PEParameters object
    *
    * @return   The callByReference value
    */
   protected boolean isCallByReference()
   {
      return false;
   }


   /**
    * Access method for an one to n association.
    *
    * @param e  The object added.
    */
   void addButton_actionPerformed (ActionEvent e)
   {
      if ( (selection.getTypeName().length() > 0)
         &&  (propertyName.getText().length() > 0))
      {
         UMLParam newParam = new UMLParam();
         newParam.setName (propertyName.getText());

         newParam.setPointer (pointer.isSelected());
         newParam.setCallByReference (callByReference.isSelected());

         ASGElement incr = selection.getSourceIncrementByName (selection.getTypeName());

         // the type is null if a stereotype must be created for the class
         if (incr == null)
         {
            UMLTypeList typelist = null;
            if (getIncrement() instanceof UMLClass)
            {
               typelist =  ((UMLClass) getIncrement()).getRevTypes();
            }
            UMLClass refClass =
               new UMLClass (selection.getTypeName(),
               UMLStereotypeManager.get().
               getFromStereotypes (
               UMLStereotypeManager.REFERENCE), typelist,
               null);
            newParam.setParamType (refClass);
            refClasses.add (refClass);
         }
         else
         {
            newParam.setParamType ((UMLType) incr);
         }
         addParameters.add (newParam);
         selection.addToDest (newParam);
         setPropertyName ("");
         propertyName.requestFocus();
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   void removeButton_actionPerformed (ActionEvent e)
   {
      ASGElement incr = selection.getDestSelectedIncr();
      if (incr != null)
      {
         delParameters.add (incr);
         selection.removeFromDest (incr);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   void modifyButton_actionPerformed (ActionEvent e)
   {
      ASGElement oldIncr = selection.getDestSelectedIncr();
      if (oldIncr != null)
      {
         // delete old method
         delParameters.add (oldIncr);
         selection.removeFromDest (oldIncr);
         if ( (selection.getTypeName().length() > 0)
            &&  (propertyName.getText().length() > 0))
         {
            UMLParam newParam = new UMLParam();
            newParam.setName (propertyName.getText());

            newParam.setPointer (pointer.isSelected());
            newParam.setCallByReference (callByReference.isSelected());

            ASGElement incr = selection.getSourceIncrementByName (selection.getTypeName());

            // the type is null if a stereotype must be created for the class
            if (incr == null)
            {
               UMLTypeList typelist = null;
               if (getIncrement() instanceof UMLClass)
               {
                  typelist =  ((UMLClass) getIncrement()).getRevTypes();
               }
               UMLClass refClass =
                  new UMLClass (selection.getTypeName(),
                  UMLStereotypeManager.get().
                  getFromStereotypes
                   (UMLStereotypeManager.REFERENCE), typelist,
                  null);
               newParam.setParamType (refClass);
               refClasses.add (refClass);
            }
            else
            {
               newParam.setParamType ((UMLType) incr);
            }

            modParameters.add (newParam);
            selection.addToDest (newParam);
         }
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: cschneid $
    * @version   $Revision: 1.69.2.1 $
    */
   private class SourceMouseListener implements MouseListener
   {
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      PEListbox liste;


      /**
       * Constructor for class SourceMouseListener
       *
       * @param list  No description provided
       */
      SourceMouseListener (PEListbox list)
      {
         liste = list;
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void mouseClicked (MouseEvent e)
      {
         if (e.getClickCount() == 2)
         {
            ASGElement oldIncr = selection.getDestSelectedIncr();
            if (oldIncr != null && oldIncr instanceof UMLParam)
            {
               UMLParam curParam = (UMLParam) oldIncr;
               if (propertyName.getText().equals (curParam.getName()))
               {
                  modifyButton_actionPerformed (null);
               }

               else
               {
                  addButton_actionPerformed (null);
               }
            }

            else
            {
               addButton_actionPerformed (null);
            }
         }
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void mouseEntered (MouseEvent e) { }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void mouseExited (MouseEvent e) { }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void mousePressed (MouseEvent e) { }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void mouseReleased (MouseEvent e) { }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: cschneid $
    * @version   $Revision: 1.69.2.1 $
    */
   private class DestMouseListener implements MouseListener
   {
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      PEListbox liste;


      /**
       * Constructor for class DestMouseListener
       *
       * @param list  No description provided
       */
      DestMouseListener (PEListbox list)
      {
         liste = list;
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void mouseClicked (MouseEvent e) { }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void mouseEntered (MouseEvent e) { }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void mouseExited (MouseEvent e) { }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void mousePressed (MouseEvent e)
      {
         if ( (e.getClickCount() == 2)
            &&  (
            SwingUtilities.isRightMouseButton (e)))
         {
            removeButton_actionPerformed (null);
         }
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void mouseReleased (MouseEvent e) { }
   }
}


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: cschneid $
 * @version   $Revision: 1.69.2.1 $
 */
class PEParameter_addButton_actionAdapter implements
   java.awt.event.ActionListener
{


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   PEParameters adaptee;


   /**
    * Constructor for class PEParameter_addButton_actionAdapter
    *
    * @param adaptee  No description provided
    */
   PEParameter_addButton_actionAdapter (PEParameters adaptee)
   {
      this.adaptee = adaptee;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void actionPerformed (ActionEvent e)
   {
      adaptee.addButton_actionPerformed (e);
   }
}


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: cschneid $
 * @version   $Revision: 1.69.2.1 $
 */
class PEParameter_modifyButton_actionAdapter implements
   java.awt.event.ActionListener
{


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   PEParameters adaptee;


   /**
    * Constructor for class PEParameter_modifyButton_actionAdapter
    *
    * @param adaptee  No description provided
    */
   PEParameter_modifyButton_actionAdapter (PEParameters adaptee)
   {
      this.adaptee = adaptee;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void actionPerformed (ActionEvent e)
   {
      adaptee.modifyButton_actionPerformed (e);
   }
}


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: cschneid $
 * @version   $Revision: 1.69.2.1 $
 */
class PEParameter_removeButton_actionAdapter implements
   java.awt.event.ActionListener
{


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   PEParameters adaptee;


   /**
    * Constructor for class PEParameter_removeButton_actionAdapter
    *
    * @param adaptee  No description provided
    */
   PEParameter_removeButton_actionAdapter (PEParameters adaptee)
   {
      this.adaptee = adaptee;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void actionPerformed (ActionEvent e)
   {
      adaptee.removeButton_actionPerformed (e);
   }
}


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: cschneid $
 * @version   $Revision: 1.69.2.1 $
 */
class PEParameterSelection extends PETypeSelection
{


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Enumeration typeListCopy = null;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private PEParameters parameterEditor = null;


   /**
    * Constructor for class PEParameterSelection
    *
    * @param parent  No description provided
    */
   PEParameterSelection (PropertyEditor parent)
   {
      super (parent, "String");
      getDest().setHeader ("Parameters");
      parameterEditor = (PEParameters) parent;
   }


   /**
    * Sets the typeList attribute of the PEParameterSelection object
    *
    * @param typeList  The new typeList value
    */
   public void setTypeList (Enumeration typeList)
   {
      typeListCopy = typeList;
      fillSourceList();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected void destSelectionChanged()
   {
      ASGElement umlIncr = destination.getSelectedIncrement();
      if (umlIncr instanceof UMLParam)
      {
         UMLParam umlParam = (UMLParam) umlIncr;
         parameterEditor.setPropertyName (umlParam.getName());
         parameterEditor.setPointer (umlParam.isPointer());
         parameterEditor.setCallByReference (umlParam.isCallByReference());
         source.selectIncrement ((UMLIncrement) umlParam.getFParamType());
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected void fillSourceList()
   {
      clearSource();
      if (typeListCopy != null)
      {
         while (typeListCopy.hasMoreElements())
         {
            addToSource ( ((PEItem) typeListCopy.nextElement()).
               getIncrement());
         }
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected void fillDestList()
   {
      clearDest();
      if (getIncrement() instanceof UMLMethod)
      {
         UMLMethod method = (UMLMethod) getIncrement();
         Iterator iter = method.iteratorOfParam();
         UMLParam param = null;
         while (iter.hasNext())
         {
            param = (UMLParam) iter.next();
            addToDest (param);
         }
      }
   }
}

/*
 * $Log: PEParameters.java,v $
 * Revision 1.69.2.1  2006/08/14 11:02:41  cschneid
 * initial selection in Attribute and Parameter Editor is "String" now
 *
 */
