/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gui;

import java.awt.event.*;
import java.util.Enumeration;
import java.util.Iterator;

import javax.swing.*;
import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.metamodel.FDeclaration;
import de.uni_paderborn.fujaba.uml.*;
import de.uni_paderborn.tools.util.MethodDeclaration;
import de.uni_paderborn.tools.util.TextUtil;
import de.upb.tools.fca.FLinkedList;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: cschneid $
 * @version   $Revision: 1.115.2.3 $
 */
public class PEMethod extends PropertyEditor
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (PEMethod.class);

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JFrame frame = null;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   FLinkedList addMethods = new FLinkedList();
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   FLinkedList delMethods = new FLinkedList();
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   FLinkedList refClasses = new FLinkedList();
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   PETextField propertyName;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   PECheck signalModifier;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   PECheck finalModifier;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   PECheck staticModifier;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   PECheck abstractModifier;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   PECheck synchronizedModifier;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   PECheck nativeModifier;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   PECombo visibilityChoice;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   PEMethodSelection selection;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   PECheck pointer = null;


   /**
    * Constructor for class PEMethod
    *
    * @param frame  No description provided
    * @param title  No description provided
    * @param modal  No description provided
    */
   public PEMethod (JFrame frame, String title, boolean modal)
   {
      super (frame);
      try
      {
         pack();
         this.frame = frame;
         this.setTitle ("Method Editor");
      }
      catch (Exception e)
      {
         e.printStackTrace();
      }
      initPE();

      addFocusListener (new CMAFocusListener (propertyName));

      propertyName.addActionListener (
         new ActionListener()
         {
            public void actionPerformed (ActionEvent e)
            {
               addButton_actionPerformed (e);
            }
         }
         );
   }


   /**
    * Constructor for class PEMethod
    *
    * @param frame  No description provided
    */
   public PEMethod (JFrame frame)
   {
      this (frame, "", false);
   }


   /**
    * Constructor for class PEMethod
    *
    * @param frame  No description provided
    * @param modal  No description provided
    */
   public PEMethod (JFrame frame, boolean modal)
   {
      this (frame, "", modal);
   }


   /**
    * Constructor for class PEMethod
    *
    * @param frame  No description provided
    * @param title  No description provided
    */
   public PEMethod (JFrame frame, String title)
   {
      this (frame, title, false);
   }


   /**
    * Sets the propertyName attribute of the PEMethod object
    *
    * @param name  The new propertyName value
    */
   public void setPropertyName (String name)
   {
      propertyName.setText (name);
   }


   /**
    * Sets the visibilityChoice attribute of the PEMethod object
    *
    * @param index  The new visibilityChoice value
    */
   public void setVisibilityChoice (int index)
   {
      visibilityChoice.setSelectedIndex (index);
   }


   /**
    * Sets the increment attribute of the PEMethod object
    *
    * @param incr  The new increment value
    */
   public void setIncrement (ASGElement incr)
   {
      setReadOnly (isReadOnly());

      if (incr instanceof UMLMethod)
      {
         super.setIncrement ( ((UMLMethod) incr).getParent());
         selection.getDest().selectIncrement (incr);
      }
      else
      {
         super.setIncrement (incr);
      }
      if (getClassIncrement() != null)
      {
         propertyName.setReadOnly (isReadOnly());
         setTitle ("Method Editor: " + getClassIncrement().getName());
      }
   }


   /**
    * Sets the signalModifier attribute of the PEMethod object
    *
    * @param b  The new signalModifier value
    */
   public void setSignalModifier (boolean b)
   {
      signalModifier.setSelected (b);
   }


   /**
    * Sets the finalModifier attribute of the PEMethod object
    *
    * @param b  The new finalModifier value
    */
   public void setFinalModifier (boolean b)
   {
      finalModifier.setSelected (b);
   }


   /**
    * Sets the staticModifier attribute of the PEMethod object
    *
    * @param b  The new staticModifier value
    */
   public void setStaticModifier (boolean b)
   {
      staticModifier.setSelected (b);
   }


   /**
    * Sets the abstractModifier attribute of the PEMethod object
    *
    * @param b  The new abstractModifier value
    */
   public void setAbstractModifier (boolean b)
   {
      abstractModifier.setSelected (b);
   }


   /**
    * Sets the synchronizedModifier attribute of the PEMethod object
    *
    * @param b  The new synchronizedModifier value
    */
   public void setSynchronizedModifier (boolean b)
   {
      synchronizedModifier.setSelected (b);
   }


   /**
    * Sets the nativeModifier attribute of the PEMethod object
    *
    * @param b  The new nativeModifier value
    */
   public void setNativeModifier (boolean b)
   {
      nativeModifier.setSelected (b);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param panel  No description provided
    */
   protected void additionalProperties (PEEditPanel panel)
   {
      propertyName = new PETextField (this, "Method Name");
      signalModifier = new PECheck (this, "Signal Modifier", "Signal");
      finalModifier = new PECheck (this, "Final Modifier", "Method is final");
      staticModifier = new PECheck (this, "Static Modifier", "Method is static");
      abstractModifier = new PECheck (this, "Abstract Modifier", "Method is abstract");
      synchronizedModifier = new PECheck (this, "Synchronized Modifier", "Method is synchronized");
      nativeModifier = new PECheck (this, "Native Modifier", "Method is native");
      visibilityChoice = new PECombo (this, "visibility");
      selection = new PEMethodSelection (this);

      pointer = new PECheck (this, "Pointer", "result type is pointer");
      pointer.setSelected (isResultTypeIsPointer());

      selection.setSourceMouseListener (new SourceMouseListener (selection.getSource().getList()));
      selection.setDestMouseListener (new DestMouseListener (selection.getSource().getList()));

      propertyName.setText (getPropertyName());
      propertyName.setStatus ("Enter the new name");

      visibilityChoice.add ("- private");
      visibilityChoice.add ("+ public");
      visibilityChoice.add ("# protected");
      visibilityChoice.add ("~ package");
      visibilityChoice.setSelectedIndex (1);
      visibilityChoice.setStatus ("select the visibility of the method");

      PEColumn column = new PEColumn (this);
      column.add (propertyName);
      column.add (signalModifier);
      column.add (finalModifier);
      column.add (staticModifier);
      column.add (abstractModifier);
      column.add (synchronizedModifier);
      column.add (nativeModifier);
      column.add (visibilityChoice);

      column.add (pointer);

      column.add (selection);

      panel.add (column);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected void unparse()
   {
      propertyName.setText (getPropertyName());
      propertyName.selectAll();

      selection.setIncrement (getIncrement());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected void parse()
   {
      if (!isReadOnly())
      {
         ASGElement incr = getIncrement();

         if (incr instanceof UMLClass)
         {
            UMLClass umlClass = (UMLClass) incr;
            UMLMethod method = null;

            Iterator iter = addMethods.iterator();
            while (iter.hasNext())
            {
               method = (UMLMethod) iter.next();
               method.setParent (umlClass);
            }
            addMethods.clear();

            iter = delMethods.iterator();
            while (iter.hasNext())
            {
               method = (UMLMethod) iter.next();
               method.removeYou();
            }
            delMethods.clear();

            iter = refClasses.iterator();
            while (iter.hasNext())
            {
               UMLClass refClass = (UMLClass) iter.next();

               Iterator diags = umlClass.iteratorOfDiagrams();
               if (diags != null)
               {
                  UMLDiagram diag = null;
                  while (diags.hasNext())
                  {
                     diag = (UMLDiagram) diags.next();
                     diag.addToElements (refClass);
                  }
               }
            }
            refClasses.clear();
         }
      }
      else
      {
         if (log.isDebugEnabled())
         {
            log.debug ("Editor in ReadOnly mode.");
         }
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected void cancel()
   {
      addMethods.clear();
      delMethods.clear();
      setVisible (false);
      dispose();
   }


   /**
    * Get the propertyName attribute of the PEMethod object
    *
    * @return   The propertyName value
    */
   protected String getPropertyName()
   {
      if (getClassIncrement() != null)
      {
         int count = 1;
         Iterator methodIter = getClassIncrement().iteratorOfMethods();
         while (methodIter.hasNext())
         {
            count++;
            methodIter.next();
         }
         return "m" + count;
      }
      return "New Method";
   }


   /**
    * Sets the resultTypeIsPointer attribute of the PEMethod object
    *
    * @param isResultTypeIsPointer  The new resultTypeIsPointer value
    */
   public void setResultTypeIsPointer (boolean isResultTypeIsPointer)
   {
      pointer.setSelected (isResultTypeIsPointer);
   }


   /**
    * Get the resultTypeIsPointer attribute of the PEMethod object
    *
    * @return   The resultTypeIsPointer value
    */
   protected boolean isResultTypeIsPointer()
   {
      return false;
   }


   /**
    * Get the pEMethodSelection attribute of the PEMethod object
    *
    * @return   The pEMethodSelection value
    */
   public PEMethodSelection getPEMethodSelection()
   {
      return selection;
   }


   /**
    * Get the propertyNameTextField attribute of the PEMethod object
    *
    * @return   The propertyNameTextField value
    */
   public PETextField getPropertyNameTextField()
   {
      return propertyName;
   }


   /**
    * Get the visibilityChoiceCombo attribute of the PEMethod object
    *
    * @return   The visibilityChoiceCombo value
    */
   public PECombo getVisibilityChoiceCombo()
   {
      return visibilityChoice;
   }


   /**
    * added function to handle events of specialized PESelection.<add/remove/modify> -buttons
    * function is called from event listeners of instances of PEButton
    *
    * @param buttonIdentifier  No description provided
    * @param e                 No description provided
    * @return                  No description provided
    */
   public boolean buttonActionPerformed (String buttonIdentifier, ActionEvent e)
   {
      // text label of PESelection.addButton is "add"
      // FIX ME: maybe nicer with "equals (<PESelection>.getAddButton ().getIdentifier ())"
      // thus handle these events in class PEMethodSelection - see end of this file

      if (buttonIdentifier.equals ("add"))
      {
         this.addButton_actionPerformed (e);
         return PEButton.caughtEvent;
      }

      if (buttonIdentifier.equals ("remove"))
      {
         this.removeButton_actionPerformed (e);
         return PEButton.caughtEvent;
      }

      if (buttonIdentifier.equals ("apply"))
      {
         this.modifyButton_actionPerformed (e);
         return PEButton.caughtEvent;
      }

      return PEButton.remainedUnbound;
   }


   /**
    * Access method for an one to n association.
    *
    * @param e  The object added.
    */
   void addButton_actionPerformed (ActionEvent e)
   {
      if (selection.getTypeName().length() > 0)
      {
         UMLMethod newMethod = new UMLMethod();
         boolean skipParsing = false;

         //If the method is a constructor, use classname for this method
         ASGElement selectedIncr = selection.getSourceSelectedIncr();
         if ( (selectedIncr != null) &&  (selectedIncr instanceof UMLType))
         {
            String typeName =  ((UMLType) selectedIncr).getName();
            if (typeName.equals ("Constructor"))
            {
               setPropertyName (getClassIncrement().getName());
            }

            if (typeName.equals ("Initializer"))
            {
               setPropertyName ("");
               setSignalModifier (false);
               setFinalModifier (false);
               setStaticModifier (true);
               setVisibilityChoice (FDeclaration.PUBLIC);
               setAbstractModifier (false);
               setSynchronizedModifier (false);
               setNativeModifier (false);
               skipParsing = true;
            }
         }

         if (!skipParsing)
         {
            MethodDeclaration decl = new MethodDeclaration (propertyName.getText());

            if (!decl.isValid())
            {
               JOptionPane.showMessageDialog (null, "Invalid method declaration");
               return;
            }

            if (MethodDeclaration.ILLEGAL_PARAMETER_DECLARATION.equals (decl.getMethodError()))
            {
               JOptionPane.showMessageDialog (null, MethodDeclaration.ILLEGAL_PARAMETER_DECLARATION + ".\n\nParameters will be ignored.");
            }
            else if (MethodDeclaration.ILLEGAL_RETURN_TYPE_DECLARATION.equals (decl.getMethodError()))
            {
               JOptionPane.showMessageDialog (null, MethodDeclaration.ILLEGAL_RETURN_TYPE_DECLARATION + ".\n\nReturn type won't be changed.");
            }
            else if (MethodDeclaration.ILLEGAL_PARAMETER_AND_RETURN_TYPE_DECLARATION.equals (decl.getMethodError()))
            {
               JOptionPane.showMessageDialog (null, MethodDeclaration.ILLEGAL_PARAMETER_AND_RETURN_TYPE_DECLARATION + ".\n\nParameters will be ignored,\nreturn type won't be changed");
            }

            newMethod.setName (decl.getName());
            newMethod.setSignal (signalModifier.isSelected());
            newMethod.setFinal (decl.isFinal() || finalModifier.isSelected());
            newMethod.setStatic (decl.isStatic() || staticModifier.isSelected());
            newMethod.setAbstract (decl.isAbstract() || abstractModifier.isSelected());
            newMethod.setSynchronized (decl.isSynchronized() || synchronizedModifier.isSelected());
            newMethod.setUmlNative (decl.isNative() || nativeModifier.isSelected());

            newMethod.setResultTypeIsPointer (pointer.isSelected());

            if (decl.isPublic())
            {
               visibilityChoice.setSelectedString ("+ public");
            }
            if (decl.isPackage())
            {
               visibilityChoice.setSelectedString ("~ package");
            }
            if (decl.isProtected())
            {
               visibilityChoice.setSelectedString ("# protected");
            }
            if (decl.isPrivate())
            {
               visibilityChoice.setSelectedString ("- private");
            }

            //////////////////////////////
            // if return-type is empty and method-name equals class-name,
            // we adjust the return-type to 'constructor'
            ASGElement incr = getIncrement();
            UMLClass umlClass = null;
            if (incr instanceof UMLClass)
            {
               umlClass = (UMLClass) incr;
            }

            String declReturnType = decl.getReturnType();
            if ( (declReturnType == null || declReturnType.equals (""))
               && umlClass != null && umlClass.getName().equals (decl.getName()))
            {
               declReturnType = UMLBaseTypes.CONSTRUCTOR;
            }
            //////////////////////////////

            String rType = TextUtil.makeFujabaSuitable (declReturnType);

            Enumeration enumeration = selection.getSourceList();

            while (enumeration.hasMoreElements())
            {
               String str =  ((PEItem) enumeration.nextElement()).getText();

               if (str.equals (rType))
               {
                  selection.setSourceSelectedIncr (selection.getSourceIncrementByName (rType));
                  break;
               }
            }

            String[] param = decl.getParameters();
            String[] var = decl.getParameterVariables();

            for (int i = 0; i < param.length; i++)
            {
               if (var[i].length() == 0)
               {
                  var[i] = "p" + newMethod.sizeOfParam();
               }

               newMethod.addToParam (new UMLParam (var[i], TextUtil.makeFujabaSuitable (param[i])));
            }
         }

         else
         {
            newMethod.setName (propertyName.getText());
            newMethod.setSignal (signalModifier.isSelected());
            newMethod.setFinal (finalModifier.isSelected());
            newMethod.setStatic (staticModifier.isSelected());
            newMethod.setAbstract (abstractModifier.isSelected());
            newMethod.setSynchronized (synchronizedModifier.isSelected());
            newMethod.setUmlNative (nativeModifier.isSelected());

            newMethod.setResultTypeIsPointer (pointer.isSelected());

         }
         skipParsing = false;

         ASGElement incr = null;
         PEListIncr listIncr = selection.getSource();
         if (listIncr != null)
         {
            incr = listIncr.getSelectedIncrement();
         }
         if (incr == null)
         {
            incr = selection.getSourceIncrementByName (selection.getTypeName());
         }
         // the type is null if a stereotype must be created for the class
         if (incr == null)
         {
            UMLTypeList typelist = null;
            if (getIncrement() instanceof UMLClass)
            {
               typelist =  ((UMLClass) getIncrement()).getRevTypes();
            }
            UMLClass refClass = new UMLClass (selection.getTypeName(),
               UMLStereotypeManager.get().getFromStereotypes (UMLStereotypeManager.REFERENCE), typelist, null);
            newMethod.setResultType (refClass);
            refClasses.add (refClass);
         }
         else
         {
            newMethod.setResultType ((UMLType) incr);
         }
         switch (visibilityChoice.getSelectedIndex())
         {
            case 0:
            { // private visibility

               newMethod.setVisibility (0);
               addMethods.add (newMethod);
               break;
            }
            case 1:
            { // public visibility

               newMethod.setVisibility (1);
               addMethods.add (newMethod);
               break;
            }
            case 2:
            { // protected visibility

               newMethod.setVisibility (2);
               addMethods.add (newMethod);
               break;
            }
            case 3:
            { // package visibility
               newMethod.setVisibility (3);
               addMethods.add (newMethod);
               break;
            }
         }
         selection.addToDest (newMethod);
         setPropertyName ("");
         propertyName.requestFocus();
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   void removeButton_actionPerformed (ActionEvent e)
   {
      ASGElement incr = selection.getDestSelectedIncr();
      if (incr != null)
      {
         delMethods.add (incr);
         selection.removeFromDest (incr);
         addMethods.remove (incr);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   void modifyButton_actionPerformed (ActionEvent e)
   {
      ASGElement oldIncr = selection.getDestSelectedIncr();
      if (oldIncr != null && oldIncr instanceof UMLMethod)
      {
         // add modified method
         if (selection.getTypeName().length() > 0)
         {
            UMLMethod curMethod = (UMLMethod) oldIncr;

            ASGElement incr = null;
            PEListIncr listIncr = selection.getSource();
            if (listIncr != null)
            {
               incr = listIncr.getSelectedIncrement();
            }
            if (incr == null)
            {
               incr = selection.getSourceIncrementByName (selection.getTypeName());
            }

            if (incr.getName().equals ("Constructor") && !propertyName.getText().equals (getClassIncrement().getName()))
            {
               JOptionPane.showMessageDialog (null, "The returntype Constructor cannot be applied to this Method", "Wrong Type", JOptionPane.INFORMATION_MESSAGE);
               return;
            }

            MethodDeclaration decl = new MethodDeclaration (propertyName.getText());
            if (!decl.isValid())
            {
               JOptionPane.showMessageDialog (null, "Invalid method declaration");
               return;
            }

            if (MethodDeclaration.ILLEGAL_PARAMETER_DECLARATION.equals (decl.getMethodError()))
            {
               JOptionPane.showMessageDialog (null, MethodDeclaration.ILLEGAL_PARAMETER_DECLARATION + ".\n\nParameters will be ignored.");
            }
            else if (MethodDeclaration.ILLEGAL_RETURN_TYPE_DECLARATION.equals (decl.getMethodError()))
            {
               JOptionPane.showMessageDialog (null, MethodDeclaration.ILLEGAL_RETURN_TYPE_DECLARATION + ".\n\nReturn type won't be changed.");
            }
            else if (MethodDeclaration.ILLEGAL_PARAMETER_AND_RETURN_TYPE_DECLARATION.equals (decl.getMethodError()))
            {
               JOptionPane.showMessageDialog (null, MethodDeclaration.ILLEGAL_PARAMETER_AND_RETURN_TYPE_DECLARATION + ".\n\nParameters will be ignored,\nreturn type won't be changed");
            }

            curMethod.setName (decl.getName());
            curMethod.setSignal (signalModifier.isSelected());
            curMethod.setFinal (decl.isFinal() || finalModifier.isSelected());
            curMethod.setStatic (decl.isStatic() || staticModifier.isSelected());
            curMethod.setAbstract (decl.isAbstract() || abstractModifier.isSelected());
            curMethod.setSynchronized (decl.isSynchronized() || synchronizedModifier.isSelected());
            curMethod.setUmlNative (decl.isNative() || nativeModifier.isSelected());

            curMethod.setResultTypeIsPointer (pointer.isSelected());

            if (decl.isPublic())
            {
               visibilityChoice.setSelectedString ("+ public");
            }
            if (decl.isPackage())
            {
               visibilityChoice.setSelectedString ("~ package");
            }
            if (decl.isProtected())
            {
               visibilityChoice.setSelectedString ("# protected");
            }
            if (decl.isPrivate())
            {
               visibilityChoice.setSelectedString ("- private");
            }

            //////////////////////////////
            // if return-type is empty and method-name equals class-name,
            // we adjust the return-type to 'constructor'
            ASGElement increment = getIncrement();
            UMLClass umlClass = null;
            if (increment instanceof UMLClass)
            {
               umlClass = (UMLClass) increment;
            }

            String declReturnType = decl.getReturnType();
            if ( (declReturnType == null || declReturnType.equals (""))
               && umlClass != null && umlClass.getName().equals (decl.getName()))
            {
               declReturnType = UMLBaseTypes.CONSTRUCTOR;
            }
            //////////////////////////////
            String rType = TextUtil.makeFujabaSuitable (declReturnType);
            Enumeration enumeration = selection.getSourceList();

            while (enumeration.hasMoreElements())
            {
               String str =  ((PEItem) enumeration.nextElement()).getText();

               if (str.equals (rType))
               {
                  selection.setSourceSelectedIncr (selection.getSourceIncrementByName (rType));
                  break;
               }
            }

            String[] param = decl.getParameters();
            String[] var = decl.getParameterVariables();

            if (param.length != 0)
            {
               curMethod.removeAllFromParam();
            }

            for (int i = 0; i < param.length; i++)
            {
               if (var[i].length() == 0)
               {
                  var[i] = "p" + curMethod.sizeOfParam();
               }

               curMethod.addToParam (new UMLParam (var[i], TextUtil.makeFujabaSuitable (param[i])));
            }

            curMethod.setResultType ((UMLType) incr);
            curMethod.setVisibility (visibilityChoice.getSelectedIndex());

            selection.removeFromDest (curMethod);
            selection.addToDest (curMethod);
         }
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   void parametersButton_actionPerformed (ActionEvent e)
   {
      UMLMethod method = (UMLMethod) selection.getDestSelectedIncr();
      if (method != null)
      {
         PEParameters umlParameterEditor = new PEParameters (frame);
         umlParameterEditor.setIncrement (method, getIncrement());
         umlParameterEditor.setTypeList (selection.getSourceList());
         umlParameterEditor.showCentered();
         selection.removeFromDest (method);
         selection.addToDest (method);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   void throwsButton_actionPerformed (ActionEvent e)
   {
      UMLMethod method = (UMLMethod) selection.getDestSelectedIncr();
      if (method != null)
      {
         new PEThrowsDialog (frame, method, selection.getSourceList());
         selection.removeFromDest (method);
         selection.addToDest (method);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: cschneid $
    * @version   $Revision: 1.115.2.3 $
    */
   private class SourceMouseListener implements MouseListener
   {
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      PEListbox liste;


      /**
       * Constructor for class SourceMouseListener
       *
       * @param list  No description provided
       */
      SourceMouseListener (PEListbox list)
      {
         liste = list;
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void mouseClicked (MouseEvent e)
      {
         if (e.getClickCount() == 2)
         {
            ASGElement oldIncr = selection.getDestSelectedIncr();
            if (oldIncr != null && oldIncr instanceof UMLMethod)
            {
               UMLMethod curMethod = (UMLMethod) oldIncr;

               if (propertyName.getText().equals (curMethod.getName()))
               {
                  modifyButton_actionPerformed (null);
               }
               else
               {
                  addButton_actionPerformed (null);
               }
            }
            else
            {
               addButton_actionPerformed (null);
            }
         }
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void mouseEntered (MouseEvent e) { }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void mouseExited (MouseEvent e) { }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void mousePressed (MouseEvent e) { }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void mouseReleased (MouseEvent e) { }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: cschneid $
    * @version   $Revision: 1.115.2.3 $
    */
   private class DestMouseListener implements MouseListener
   {
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      PEListbox liste;


      /**
       * Constructor for class DestMouseListener
       *
       * @param list  No description provided
       */
      DestMouseListener (PEListbox list)
      {
         liste = list;
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void mouseClicked (MouseEvent e)
      {
         if (e.getClickCount() == 2)
         {
            parametersButton_actionPerformed (null);

         }
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void mouseEntered (MouseEvent e) { }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void mouseExited (MouseEvent e) { }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void mousePressed (MouseEvent e)
      {
         if ( (e.getClickCount() == 2) &&  (SwingUtilities.isRightMouseButton (e)))
         {
            removeButton_actionPerformed (null);
         }
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void mouseReleased (MouseEvent e) { }
   }

}


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: cschneid $
 * @version   $Revision: 1.115.2.3 $
 */
class PEMethodSelection extends PETypeSelection
{


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private PEButton parameter;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private PEButton throwsButton;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private PEMethod parent;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private PEMethod methodEditor;


   /**
    * Constructor for class PEMethodSelection
    *
    * @param parent  No description provided
    */
   PEMethodSelection (PEMethod parent)
   {
      super (parent, "Void");
      getDest().setHeader ("Methods");

      this.parent = parent;
      parameter = new PEButton (this, "parameter");
      throwsButton = new PEButton (this, "throws...");

      getButtonColumn().add (parameter);
      getButtonColumn().add (throwsButton);

      methodEditor = parent;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected void destSelectionChanged()
   {
      ASGElement umlIncr = destination.getSelectedIncrement();
      if (umlIncr instanceof UMLMethod)
      {
         UMLMethod umlMethod = (UMLMethod) umlIncr;
         methodEditor.setPropertyName (umlMethod.getName());
         methodEditor.setSignalModifier (umlMethod.isSignal());
         methodEditor.setFinalModifier (umlMethod.isFinal());
         methodEditor.setStaticModifier (umlMethod.isStatic());
         methodEditor.setVisibilityChoice (umlMethod.getVisibility());
         methodEditor.setAbstractModifier (umlMethod.isAbstract());
         methodEditor.setSynchronizedModifier (umlMethod.isSynchronized());
         methodEditor.setNativeModifier (umlMethod.isUmlNative());
         methodEditor.setResultTypeIsPointer (umlMethod.isResultTypeIsPointer());
         source.selectIncrement ((UMLIncrement) umlMethod.getResultType());
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void fillDestList()
   {
      clearDest();
      ASGElement incr = getIncrement();
      if (incr instanceof UMLClass)
      {
         Iterator methodIter =  ((UMLClass) incr).iteratorOfMethods();
         UMLMethod umlMethod;
         while (methodIter.hasNext())
         {
            umlMethod = (UMLMethod) methodIter.next();
            if (umlMethod != null)
            {
               addToDest (umlMethod);
            }
         }
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param buttonIdentifier  No description provided
    * @param e                 No description provided
    * @return                  No description provided
    */
   public boolean buttonActionPerformed (String buttonIdentifier, ActionEvent e)
   {
      if (buttonIdentifier.equals (parameter.getIdentifier()))
      {
         parent.parametersButton_actionPerformed (e);
         return PEButton.caughtEvent;
      }
      else if (buttonIdentifier.equals (throwsButton.getIdentifier()))
      {
         parent.throwsButton_actionPerformed (e);
         return PEButton.caughtEvent;
      }

      return parent.buttonActionPerformed (buttonIdentifier, e);
   }

}

/*
 * $Log: PEMethod.java,v $
 * Revision 1.115.2.3  2006/08/14 11:02:41  cschneid
 * initial selection in Attribute and Parameter Editor is "String" now
 *
 */
