/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gui;

import java.awt.*;
import java.util.Enumeration;
import java.util.Iterator;

import javax.swing.*;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.upb.tools.fca.EnumerationForAnIterator;
import de.upb.tools.fca.FLinkedList;


/**
 * PE List implements a Listbox with a additional List of objects
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.24 $
 */
public class PEListbox extends JList
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private FLinkedList itemList = new FLinkedList(); // List of PEItems

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private PEStringListModel slm = null;


   /**
    * Constructor for class PEListbox
    */
   PEListbox()
   {
      super (new PEStringListModel());
      slm = (PEStringListModel) this.getModel();
      addListSelectionListener (new PEListSelectionListener (this));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param item  No description provided
    */
   public void add (PEItem item)
   {
      itemList.add (item);
      slm.add (item.getText());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param incr  No description provided
    */
   public void add (ASGElement incr)
   {
      PEItem item = new PEItem (incr);
      this.add (item);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param s  No description provided
    */
   public void add (String s)
   {
      itemList.add (null);
      slm.add (s);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param incr  No description provided
    */
   public void remove (ASGElement incr)
   {
      int i = 0;
      int index = -1;
      Iterator items = itemList.iterator();
      PEItem item = null;
      while ( (items.hasNext()) &&  (index < 0))
      {
         item = (PEItem) items.next();
         if (item.getIncrement() == incr)
         {
            index = i;
         }
         i++;
      }
      if (index >= 0)
      {
         itemList.remove (index);
         slm.remove (index);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void removeAll()
   {
      slm.clear();
      itemList.clear();
   }


   /**
    * Get the itemByIndex attribute of the PEListbox object
    *
    * @param index  No description provided
    * @return       The itemByIndex value
    */
   public PEItem getItemByIndex (int index)
   {
      PEItem item = null;
      Iterator list = itemList.iterator();
      int i = 0;
      while ( (list.hasNext()) &&  (i <= index))
      {
         item = (PEItem) list.next();
         i++;
      }
      if (i == index + 1)
      {
         return item;
      }
      return null;
   }


   /**
    * Get the incrementIndex attribute of the PEListbox object
    *
    * @param incr  No description provided
    * @return      The incrementIndex value
    */
   public int getIncrementIndex (ASGElement incr)
   {
      PEItem item = null;
      Iterator list = itemList.iterator();
      int i = 0;
      while (list.hasNext())
      {
         item = (PEItem) list.next();
         if (item != null)
         {
            if (item.getIncrement() == incr)
            {
               return i;
            }
         }
         i++;
      }
      return -1;
   }


   /**
    * Get the selectedIncrement attribute of the PEListbox object
    *
    * @return   The selectedIncrement value
    */
   public ASGElement getSelectedIncrement()
   {
      int index = getSelectedIndex();
      if (index >= 0)
      {
         PEItem item = getItemByIndex (index);
         if (item != null)
         {
            return  (item.getIncrement());
         }
      }
      return null;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Enumeration elements()
   {
      return new EnumerationForAnIterator (iterator());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Iterator iterator()
   {
      return itemList.iterator();
   }


   /**
    * Get the selectedElements attribute of the PEListbox object
    *
    * @return   The selectedElements value
    */
   public int[] getSelectedElements()
   {
      return getSelectedIndices();
   }


   /**
    * Get the incrementSelected attribute of the PEListbox object
    *
    * @param incr  No description provided
    * @return      The incrementSelected value
    */
   public boolean isIncrementSelected (ASGElement incr)
   {
      int i = 0;
      Iterator incrs = itemList.iterator();
      while ( (incrs.hasNext()) &&  ( ((PEItem) incrs.next()).getIncrement() != incr))
      {
         i++;
      }
      if (
      /*
       *  (i < getComponentCount ()) &&
       */
          (isSelectedIndex (i)))
      {
         return true;
      }
      return false;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param incr  No description provided
    */
   public void selectIncrement (ASGElement incr)
   {
      int i = getIncrementIndex (incr);
      if (i >= 0)
      {
         setSelectedIndex (i);
      }
   }


   /**
    * Get the incrementByName attribute of the PEListbox object
    *
    * @param name  No description provided
    * @return      The incrementByName value
    */
   public ASGElement getIncrementByName (String name)
   {
      Iterator items = itemList.iterator();
      PEItem item = null;
      while (items.hasNext())
      {
         item = (PEItem) items.next();
         if (item.getText().equals (name))
         {
            return item.getIncrement();
         }
      }
      return null;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void selectionChanged() { }
}


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.24 $
 */
class PEListSelectionListener implements ListSelectionListener
{


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   PEListbox adaptor;


   /**
    * Constructor for class PEListSelectionListener
    *
    * @param adapter  No description provided
    */
   PEListSelectionListener (PEListbox adapter)
   {
      adaptor = adapter;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void valueChanged (ListSelectionEvent e)
   {
      adaptor.selectionChanged();
      int index = adaptor.getSelectedIndex();
      Rectangle rect = adaptor.getCellBounds (index, index);
      if (rect != null)
      {
         adaptor.scrollRectToVisible (rect);
      }
   }
}

/*
 * $Log: PEListbox.java,v $
 * Revision 1.24  2004/11/03 10:18:04  lowende
 * Javadoc warnings removed.
 *
 */
