/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gui;

import java.util.Iterator;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.uml.UMLIncrement;
import de.upb.tools.fca.FLinkedList;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.19 $
 */
public class PEComboIncr extends PECombo
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private FLinkedList incrList = new FLinkedList();


   /**
    * Constructor for class PEComboIncr
    *
    * @param parent  No description provided
    * @param title   No description provided
    */
   public PEComboIncr (PropertyEditor parent, String title)
   {
      super (parent, title);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param text  No description provided
    */
   public void add (String text)
   {
      incrList.add (null);
      super.add (text);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param asgElement  No description provided
    */
   public void add (ASGElement asgElement)
   {
      if (asgElement != null)
      {
         incrList.add (asgElement);
         super.add (asgElement.getText());
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param incr  No description provided
    * @param text  No description provided
    */
   public void add (UMLIncrement incr, String text)
   {
      incrList.add (incr);
      super.add (text);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void clear()
   {
      incrList.clear();
      removeAll();
   }


   /**
    * Get the selectedIncrement attribute of the PEComboIncr object
    *
    * @return   The selectedIncrement value
    */
   public UMLIncrement getSelectedIncrement()
   {
      int index = getSelectedIndex();
      try
      {
         UMLIncrement incr = (UMLIncrement) incrList.get (index);
         return incr;
      }
      catch (IndexOutOfBoundsException e)
      {
      }
      return null;
   }


   /**
    * Sets the selectedIncrement attribute of the PEComboIncr object
    *
    * @param incr  The new selectedIncrement value
    * @return      No description provided
    */
   public int setSelectedIncrement (UMLIncrement incr)
   {
      Iterator iter = incrList.iterator();

      int i = 0;
      UMLIncrement item = null;
      if (iter.hasNext())
      {
         item = (UMLIncrement) iter.next();
         i++;
      }
      while ( (iter.hasNext()) &&  (item != incr))
      {
         item = (UMLIncrement) iter.next();
         i++;
      }
      if ( (i > 0) &&  (item == incr))
      {
         setSelectedIndex (i - 1);
         return i - 1;
      }
      return -1;
   }
}

/*
 * $Log: PEComboIncr.java,v $
 * Revision 1.19  2004/11/03 10:18:04  lowende
 * Javadoc warnings removed.
 *
 */
