/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gui;

import javax.swing.*;
import javax.swing.event.ChangeListener;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.16 $
 */
public class PECheck extends PEHeaderComponent
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JCheckBox check;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String checkname;


   /**
    * Constructor for class PECheck
    *
    * @param parent  No description provided
    * @param header  No description provided
    * @param name    No description provided
    */
   public PECheck (PropertyEditor parent, String header, String name)
   {
      super (parent, header);
      setCheckName (name);
   }


   /**
    * Sets the readOnly attribute of the PECheck object
    *
    * @param b  The new readOnly value
    */
   public void setReadOnly (boolean b)
   {
      check.setEnabled (!b);
   }


   /**
    * Sets the checkName attribute of the PECheck object
    *
    * @param name  The new checkName value
    */
   private void setCheckName (String name)
   {
      checkname = name;
      check.setText (name);
   }


   /**
    * Access method for an one to n association.
    */
   public void addComponents()
   {
      check = new JCheckBox (checkname);
      add (check);
   }


   /**
    * Sets the selected attribute of the PECheck object
    *
    * @param b  The new selected value
    */
   public void setSelected (boolean b)
   {
      check.setSelected (b);
   }


   /**
    * Get the selected attribute of the PECheck object
    *
    * @return   The selected value
    */
   public boolean isSelected()
   {
      return check.isSelected();
   }


   /**
    * Get the horzResizable attribute of the PECheck object
    *
    * @return   The horzResizable value
    */
   public boolean isHorzResizable()
   {
      return false;
   }


   /**
    * Get the vertResizable attribute of the PECheck object
    *
    * @return   The vertResizable value
    */
   public boolean isVertResizable()
   {
      return true;
   }


   /**
    * Sets the enabled attribute of the PECheck object
    *
    * @param value  The new enabled value
    */
   public void setEnabled (boolean value)
   {
      check.setEnabled (value);
   }


   /**
    * Access method for an one to n association.
    *
    * @param listener  The object added.
    */
   public void addValueChangedListener (ChangeListener listener)
   {
      check.addChangeListener (listener);
   }

}

/*
 * $Log: PECheck.java,v $
 * Revision 1.16  2004/11/03 10:18:04  lowende
 * Javadoc warnings removed.
 *
 */
