/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.*;

import org.apache.log4j.Logger;


/**
 * Class to simplify that adding of some button to row/column. Usage : create instance of it
 * in some client object and override the method 'buttonActionPerformed (String, ActionEvent)'
 * of that client class. Clients could be of type PEBaseComponent or BasicPropertyEditor
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.21 $
 */
public class PEButton extends JButton
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (PEButton.class);


   /**
    * Constructor for class PEButton
    *
    * @param parent           No description provided
    * @param buttonTextLabel  No description provided
    */
   public PEButton (PEBaseComponent parent, String buttonTextLabel)
   {
      // initiate button label
      super (buttonTextLabel);

      this.baseComponent = parent;
      init (buttonTextLabel);
   }


   /**
    * Constructor for class PEButton
    *
    * @param parent           No description provided
    * @param buttonTextLabel  No description provided
    */
   public PEButton (BasicPropertyEditor parent, String buttonTextLabel)
   {
      // initiate button label
      super (buttonTextLabel);

      // store some needed data
      this.propertyEditor = parent;
      init (buttonTextLabel);
   }

   //////////////////////////////////////////////////////////////////////////

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param buttonTextLabel  No description provided
    */
   private void init (String buttonTextLabel)
   {
      this.identifier = buttonTextLabel;

      // create listener for button-pressed-event
      ActionListener listener = new PEButtonEventListener (this);
      this.addActionListener (listener);
   }

   //////////////////////////////////////////////////////////////////////////

   /**
    * Get the identifier attribute of the PEButton object
    *
    * @return   The identifier value
    */
   public String getIdentifier()
   {
      return this.identifier;
   }

   //////////////////////////////////////////////////////////////////////////

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public static boolean caughtEvent = true;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public static boolean remainedUnbound = false;


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void buttonActionPerformed (ActionEvent e)
   {
      boolean handled = false;

      if (propertyEditor != null)
      {
         handled = propertyEditor.buttonActionPerformed (this.identifier, e);
      }

      if (baseComponent != null)
      {
         handled = baseComponent.buttonActionPerformed (this.identifier, e);
      }

      if (!handled)
      {
         if (log.isDebugEnabled())
         {
            log.debug ("PEButton.buttonActionPerformed : "
               + "unbound button event '"
               + e.getActionCommand() + "' from button '"
               + this.identifier + "'");
         }
      }
   }

   //////////////////////////////////////////////////////////////////////////

   /*
    *  @deprecated This method is deprecated.
    *  just for upwards compability of class PEButton with former
    *  implemention of "overriding needed event listeners"
    */
   /**
    * Sets the listener attribute of the PEButton object
    *
    * @param listener  The new listener value
    */
   public void setListener (ActionListener listener)
   {
      this.addActionListener (listener);
   }

   //////////////////////////////////////////////////////////////////////////

   // parent is reference to that editor, in which button is invoked,
   // can be either some BaseComponent
   // or some PropertyEditor
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private PEBaseComponent baseComponent = null;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private BasicPropertyEditor propertyEditor = null;

   // each button should have some unique identifier,
   // used as label of button as well
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String identifier;

   //////////////////////////////////////////////////////////////////////////
   //////////////////////////////////////////////////////////////////////////

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: lowende $
    * @version   $Revision: 1.21 $
    */
   class PEButtonEventListener implements ActionListener
   {
      /**
       * Constructor for class PEButtonEventListener
       *
       * @param adaptee  No description provided
       */
      public PEButtonEventListener (PEButton adaptee)
      {
         peButton = adaptee;
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void actionPerformed (ActionEvent e)
      {
         peButton.buttonActionPerformed (e);
      }

      //////////////////////////////////////////////////////////////////////

      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      private PEButton peButton;
   }

}

/*
 * $Log: PEButton.java,v $
 * Revision 1.21  2004/11/03 10:18:04  lowende
 * Javadoc warnings removed.
 *
 */
