/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gui;

import java.awt.*;
import java.awt.event.*;
import java.util.*;

import javax.swing.*;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import de.uni_paderborn.fujaba.asg.ASGDiagram;
import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.basic.FujabaComparator;
import de.uni_paderborn.fujaba.uml.*;
import de.uni_paderborn.fujaba.uml.utility.MultiLinkGenerator;
import de.uni_paderborn.fujaba.uml.utility.UMLObjectDiagramUtility;
import de.uni_paderborn.fujaba.views.ViewDefinition;
import de.uni_paderborn.fujaba.views.ViewDiagram;
import de.upb.tools.fca.FTreeSet;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: creckord $
 * @version   $Revision: 1.93.2.2 $
 */
public class PEActLink extends PropertyEditor
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String NullLink = "Null";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String NegLink = "Negative";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String OptLink = "Optional";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String NoneLink = "None";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String DeleteLink = "Destroy";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String CreateLink = "Create";

   /**
    * Static String for PERadioGroup "multiLinkRadioGoup"
    */
   public final static String AnyElement = "Any";
   /**
    * Static String for PERadioGroup "multiLinkRadioGoup"
    */
   public final static String FirstElement = "First";
   /**
    * Static String for PERadioGroup "multiLinkRadioGoup"
    */
   public final static String LastElement = "Last";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String TotalityLink = "Totality";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String AssertLink = "Assert";

   //Needed for XMLObjects
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String ChildElement = "Child Element";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String IDRef = "IDRef";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private UMLIncrement second;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private PERolePanel rolePanel;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private PETextField name;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private PEListIncr associations;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private PETextField range;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private PERadioGroup type;
   /**
    * Contains the radio group to control sorted links (Multilinks) on sorted assocs
    */
   private PERadioGroup multiLinkRadioGoup;
   /**
    * Contains the possible containers for sorted links (Multilinks)
    */
   private JComboBox containerComboBox;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private PERadioGroup modifier;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private PECheck set;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private PECheck assertion;
   // May not be named "assert", because it is a keyword in Java2 1.4 [tr].


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private PETextField pathExpr;


   /**
    * Constructor for class PEActLink
    *
    * @param frame  No description provided
    */
   public PEActLink (JFrame frame)
   {
      super (frame);
      setTitle ("Link Activity Editor");
      initPE();
   } // constructor


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param panel  No description provided
    */
   protected void additionalProperties (PEEditPanel panel)
   {
      name = new PETextField (this, "Name");
      name.setStatus ("Enter the name of the link");

      associations = new PEListIncr (this, "Associations");
      associations.setStatus ("Select the association");
      associations.addSelectionListener (new PESelectionListener (this));

      range = new PETextField (this, "Range");
      String[] typeNames =
         {
         NullLink, NegLink, OptLink
         };
      type = new PERadioGroup (this, "Type", typeNames);
      type.setStatus ("Select the type of the link");
      String[] modifierNames =
         {
         NoneLink, DeleteLink, CreateLink
         };
      modifier = new PERadioGroup (this, "Modifier", modifierNames);
      modifier.setStatus ("Select the modifier");

      PERow multiLinkPanel = new PERow (this);
      multiLinkPanel.setBorder (new TitledBorder ("MultiLink"));

      String[] sortNames = {AnyElement, FirstElement, LastElement};
      multiLinkRadioGoup = new PERadioGroup (this, "Type", sortNames);

      String helpTextSortNames = "Select from which position of the sorted assoc the object should be.";
      modifier.setStatus (helpTextSortNames);
      multiLinkRadioGoup.setToolTipText (helpTextSortNames);

      multiLinkPanel.add (multiLinkRadioGoup);

      PEColumn containerColumn = new PEColumn (this);

      JLabel containerLabel = new JLabel (" Container Object");
      containerColumn.add (containerLabel);
      containerComboBox = new JComboBox();
      containerComboBox.setRenderer (new MyCellRenderer());
      containerColumn.add (containerComboBox);

      multiLinkPanel.add (containerColumn);
      //Should be enabled with checkMultiLinkMode() only
      multiLinkRadioGoup.setEnabled (false);
      containerComboBox.setEnabled (false);

      PERow setPanel = new PERow (this);
      setPanel.setBorder (new TitledBorder ("Set Behavior"));
      set = new PECheck (this, "", TotalityLink);
      set.setStatus ("Select the set behaviour");
      setPanel.add (set);
      assertion = new PECheck (this, "", AssertLink);
      assertion.setStatus ("Select the assert behaviour");
      setPanel.add (assertion);

      rolePanel = new PERolePanel();

      pathExpr = new PETextField (this, "Path Expression");
      pathExpr.setStatus ("Enter a path expression like a.b.c*");

      PEColumn column = new PEColumn (this);
      column.add (rolePanel);
      column.add (name);
      column.add (associations);
      column.add (range);

      PERow modRow = new PERow (this);
      modRow.add (type);
      modRow.add (modifier);
      modRow.add (setPanel);
      modRow.add (multiLinkPanel);

      column.add (modRow);
      column.add (pathExpr);

      panel.add (column);
   }


   /**
    * Sets the increment attribute of the PEActLink object
    *
    * @param incr     The new increment value
    * @param addIncr  The new increment value
    */
   public void setIncrement (UMLIncrement incr, UMLIncrement addIncr)
   {
      second = addIncr;
      super.setIncrement (incr);
   }


   /**
    * Method is called if the selection in the role panel has been changed.
    *
    * @param e  No description provided
    */
   public void rolePanelItemStateChanged (ItemEvent e)
   {
      UMLObject srcObj = (UMLObject)  ((PEObjListEntry) rolePanel.getLeftComboSelectedItem()).getItem();
      UMLObject tgtObj = (UMLObject)  ((PEObjListEntry) rolePanel.getRightComboSelectedItem()).getItem();
      fillAssociations (srcObj, tgtObj);
   }


   /**
    * Get the propertyName attribute of the PEActLink object
    *
    * @return   The propertyName value
    */
   public String getPropertyName()
   {
      return "ActivityLink";
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param assoc  No description provided
    * @return       No description provided
    */
   private boolean checkMultiLinkMode (UMLAssoc assoc)
   {
      if (assoc != null)
      {
         Iterator iter = assoc.iteratorOfConstraints();

         while (iter.hasNext())
         {
            UMLConstraint constraint = (UMLConstraint) iter.next();
            if ( (constraint.getText().equals ("sorted") ||
               constraint.getText().equals ("ordered")) &&
               rolePanel.getLeftComboSelectedItem() != null &&
               rolePanel.getRightComboSelectedItem() != null)
            {
               multiLinkRadioGoup.setEnabled (true);
               containerComboBox.setEnabled (true);
               fillContainerComboBox (assoc);
               return true;
            }
         }
      }

      multiLinkRadioGoup.setEnabled (false);
      containerComboBox.setEnabled (false);
      return false;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param assoc  No description provided
    */
   private void fillContainerComboBox (UMLAssoc assoc)
   {
      int leftCard = assoc.getLeftRole().getCard().getUpperBound();
      int rightCard = assoc.getRightRole().getCard().getUpperBound();

      UMLObject sourceObj = (UMLObject)  ((PEObjListEntry) rolePanel.getLeftComboSelectedItem()).getItem();
      UMLObject targetObj = (UMLObject)  ((PEObjListEntry) rolePanel.getRightComboSelectedItem()).getItem();

      UMLClass leftClass = assoc.getLeftRole().getTarget();
      UMLClass rightClass = assoc.getRightRole().getTarget();

      containerComboBox.removeAllItems();

      if (rightCard > 1)
      {
         if (sourceObj != null && sourceObj.getInstanceOf() == leftClass)
         {
            containerComboBox.addItem (sourceObj);
            containerComboBox.setSelectedIndex (0);
         }
         else if (targetObj != null && targetObj.getInstanceOf() == leftClass)
         {
            containerComboBox.addItem (targetObj);
            containerComboBox.setSelectedIndex (0);
         }
      }

      if (leftCard > 1)
      {
         if (sourceObj != null && sourceObj.getInstanceOf() == rightClass)
         {
            containerComboBox.addItem (sourceObj);
            containerComboBox.setSelectedIndex (0);
         }
         else if (targetObj != null && targetObj.getInstanceOf() == rightClass)
         {
            containerComboBox.addItem (targetObj);
            containerComboBox.setSelectedIndex (0);
         }
      }
   }


   /**
    * Adds all associations between two classes to the list of associations. Inherited assocs
    * will be also considered.
    *
    * @param class1        the first class.
    * @param class2        the second class.
    * @param intersection  No description provided
    */
   private void fillAssocs (FTreeSet intersection, UMLClass class1, UMLClass class2)
   {
      UMLAssoc firstAssoc = null;

      // Clear the list.
      associations.removeAll();

      // Fill the list.
      Iterator iter = intersection.iterator();
      while (iter.hasNext())
      {
         UMLAssoc tmpAssoc = (UMLAssoc) iter.next();
         UMLClass left = tmpAssoc.getLeftRole().getTarget();
         UMLClass right = tmpAssoc.getRightRole().getTarget();

         //Ensure that only assocs with proper direction are shown... >trinet
         if ( (class1.isChildOf (left) && class2.isChildOf (right))
            ||
             (class2.isChildOf (left) && class1.isChildOf (right)
            ))
         { //<trinet

            associations.add (tmpAssoc);

            if (firstAssoc == null)
            {
               firstAssoc = tmpAssoc;
            }
         }
      }

      if (firstAssoc != null)
      {
         associations.selectIncrement (firstAssoc);
      }

   } // fillAssocs


   /**
    * Fills the list of associations. Only those assocs, which are in the list, can be selected
    * to create a link between to classes.
    *
    * @param link  No description provided
    */
   private void fillAssociations (UMLLink link)
   {
      FTreeSet assocs = UMLObjectDiagramUtility.getAssociations (link);

      UMLClass firstClass = null;
      UMLClass secondClass = null;

      UMLObject object = link.getSource();
      if (object != null)
      {
         firstClass = object.getInstanceOf();
      }
      object = link.getTarget();
      if (object != null)
      {
         secondClass = object.getInstanceOf();
      }

      fillAssocs (assocs, firstClass, secondClass);
   } // fillAssociations


   /**
    * Fills the list of associations. Only those assocs, which are in the list, can be selected
    * to create a link between to classes.
    *
    * @param srcObj  No description provided
    * @param tgtObj  No description provided
    */
   private void fillAssociations (UMLObject srcObj, UMLObject tgtObj)
   {
      FTreeSet intersection = UMLObjectDiagramUtility.getAssociations (srcObj, tgtObj);

      UMLClass firstClass = srcObj.getInstanceOf();
      UMLClass secondClass = tgtObj.getInstanceOf();

      fillAssocs (intersection, firstClass, secondClass);
   } // fillAssociations


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param sourceObj  No description provided
    * @param targetObj  No description provided
    * @param diag       No description provided
    */
   private void fillRolePanel (UMLObject sourceObj, UMLObject targetObj, UMLDiagram diag)
   {
      boolean addClassDiagDeclsOnTheFlyOption = true;

      PEObjListEntry sourceEntry = null;
      PEObjListEntry targetEntry = null;

      Iterator itemsIter = diag.iteratorOfElements();
      while (itemsIter.hasNext())
      {
         ASGElement tmpItem = (ASGElement) itemsIter.next();
         if (tmpItem instanceof UMLObject)
         {
            UMLObject tmpObj = (UMLObject) tmpItem;
            PEObjListEntry newEntry = new PEObjListEntry (tmpObj);
            boolean isSource = false;
            boolean isTarget = false;
            boolean interfaceIsTarget = false;

            UMLClass instClass = tmpObj.getInstanceOf();

            // we assume that only a	class could have one real superclass !!!!!
            while (instClass != null)
            {
               // find out if the object could be source or target or both
               Iterator tmpIter = instClass.iteratorOfRoles();
               while (tmpIter.hasNext())
               {
                  UMLRole tmpRole = (UMLRole) tmpIter.next();
                  if (tmpRole.getRevLeftRole() != null)
                  {
                     isSource = true;
                  }
                  if (tmpRole.getRevRightRole() != null)
                  {
                     isTarget = true;
                  }
               }

               // look for the real superclass
               Iterator genIter = instClass.iteratorOfRevSubclass();
               instClass = null;
               while (genIter.hasNext() && instClass == null)
               {
                  UMLClass tmpClass =  ((UMLGeneralization) genIter.next()).getSuperclass();
                  if (!tmpClass.hasInStereotypes (UMLStereotypeManager.get().getFromStereotypes (UMLStereotypeManager.INTERFACE)))
                  {
                     instClass = tmpClass;
                  }
                  else
                  {
                     //Check	interfaces >tri
                     tmpIter = tmpClass.iteratorOfRoles();
                     while (tmpIter.hasNext())
                     {
                        UMLRole tmpRole = (UMLRole) tmpIter.next();
                        if (tmpRole.getRevRightRole() != null)
                        {
                           interfaceIsTarget = true;
                        }
                     }
                  }
               }
            }
            if (isSource || addClassDiagDeclsOnTheFlyOption)
            {
               rolePanel.addItemToLeftComboBox (newEntry);
            }
            if (isTarget || interfaceIsTarget || addClassDiagDeclsOnTheFlyOption)
            {
               rolePanel.addItemToRightComboBox (newEntry);
            }

            if (tmpObj == sourceObj)
            {
               sourceEntry = newEntry;
               rolePanel.setLeftComboSelectedItem (sourceEntry);
            }
            if (tmpObj == targetObj)
            {
               targetEntry = newEntry;
               rolePanel.setRightComboSelectedItem (targetEntry);
            }
         }
      }
      // search	for an association which connects sourceClass and
      // targetClass (or a superclass).

      UMLClass sourceClass = sourceObj.getInstanceOf();
      UMLClass targetClass = targetObj.getInstanceOf();

      TreeSet sourceClassAndParents = new TreeSet (FujabaComparator.getLessBasicIncr());
      TreeSet targetClassAndParents = new TreeSet (FujabaComparator.getLessBasicIncr());

      // fill treeSets
      UMLClass startClass = sourceClass;
      while (startClass != null)
      {
         sourceClassAndParents.add (startClass);

         //Add all Interfaces >tri
         Iterator genIter = startClass.iteratorOfRevSubclass();
         while (genIter.hasNext())
         {
            UMLClass tmpClass =  ((UMLGeneralization) genIter.next()).getSuperclass();
            if (tmpClass.hasInStereotypes (UMLStereotypeManager.get().getFromStereotypes (UMLStereotypeManager.INTERFACE)))
            {
               sourceClassAndParents.add (tmpClass);
            }
         }

         startClass = startClass.getSuperClass();
      }
      startClass = targetClass;
      while (startClass != null)
      {
         //	   log.info("added to	targetSet " + startClass);
         targetClassAndParents.add (startClass);

         //Add all Interfaces >tri
         Iterator genIter = startClass.iteratorOfRevSubclass();
         while (genIter.hasNext())
         {
            UMLClass tmpClass =  ((UMLGeneralization) genIter.next()).getSuperclass();
            if (tmpClass.hasInStereotypes (UMLStereotypeManager.get().getFromStereotypes (UMLStereotypeManager.INTERFACE)))
            {
               targetClassAndParents.add (tmpClass);
            }
         }

         startClass = startClass.getSuperClass();
      }

      Enumeration enumeration = associations.elements();
      while (enumeration.hasMoreElements())
      {
         UMLAssoc assoc = (UMLAssoc)  ((PEItem) enumeration.nextElement()).getIncrement();

         UMLClass leftClass = assoc.getLeftRole().getTarget();
         UMLClass rightClass = assoc.getRightRole().getTarget();

         if (sourceClassAndParents.contains (leftClass) && targetClassAndParents.contains (rightClass))
         {
            // found an	association between sourceClass	and targetClass
            rolePanel.setLeftComboSelectedItem (sourceEntry);
            rolePanel.setRightComboSelectedItem (targetEntry);
         }
         else if (sourceClassAndParents.contains (rightClass) && targetClassAndParents.contains (leftClass))
         {
            // found an	association between targetClass	and sourceClass
            rolePanel.setLeftComboSelectedItem (targetEntry);
            rolePanel.setRightComboSelectedItem (sourceEntry);
         }

      }

      rolePanel.addItemListener (new PERolePanelItemListener (this));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected void unparse()
   {
      if (getIncrement() != null)
      {
         ASGElement asgElement = getIncrement();
         if (asgElement instanceof UMLPath)
         {
            // just set the path expression
            UMLPath myPath = (UMLPath) asgElement;
            pathExpr.setText (myPath.getExpression());
         }
         else if (asgElement instanceof UMLLink)
         {
            UMLLink link = (UMLLink) asgElement;

            // instance of
            fillAssociations (link);

            // source and target
            fillRolePanel (link.getSource(), link.getTarget(), link.getCurrentActiveDiagram());

            checkMultiLinkMode (link.getInstanceOf());

            // name
            name.setText (link.getName());
            if (link.getInstanceOf() != null)
            {
               associations.selectIncrement (link.getInstanceOf());
            }
            // range
            range.setText (link.getRange());
            // type and modifier
            type.setSelectedButtonIndex (link.getType());
            modifier.setSelectedButtonIndex (link.getModifier());

            // set
            set.setSelected (link.getTotality());
            set.setEnabled (link.getSource().isSet() && link.getTarget().isSet());

            // assert
            assertion.setSelected (link.isAssertInUnitTest());

            //unparse UMLMultiLink
            if (link.getRevTargetLink() != null)
            {
               UMLMultiLink multiLink = link.getRevTargetLink();

               if (multiLink.getType() == UMLMultiLink.FIRST)
               {
                  //This link points to the FIRST element
                  multiLinkRadioGoup.setSelectedButtonIndex (1);
               }
            }
            else if (link.getRevSourceLink() != null)
            {
               UMLMultiLink multiLink = link.getRevSourceLink();

               if (multiLink.getType() == UMLMultiLink.LAST)
               {
                  //This link points to the LAST element
                  multiLinkRadioGoup.setSelectedButtonIndex (2);
               }
            }
         }
         else if ( (asgElement instanceof UMLObject) &&  (second instanceof UMLObject))
         {
            UMLObject srcObj = (UMLObject) asgElement;
            UMLObject tgtObj = (UMLObject) second;
            fillAssociations (srcObj, tgtObj);

            fillRolePanel (srcObj, tgtObj, srcObj.getCurrentActiveDiagram());

            if (associations.getSelectedIncrement() != null)
            {
               checkMultiLinkMode ((UMLAssoc) associations.getSelectedIncrement());
            }
            else
            {
               checkMultiLinkMode (null);
            }
         }
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected void parse()
   {
      ASGElement asgElement = getIncrement();
      if (asgElement != null)
      {
         UMLLink link = null;

         if (asgElement instanceof UMLPath)
         {
            UMLPath myPath = (UMLPath) asgElement;
            myPath.setExpression (pathExpr.getText());
         }
         else if (asgElement instanceof UMLLink)
         {
            UMLLink oldLink = (UMLLink) asgElement;
            link = new UMLLink();

            // name
            String linkName = name.getText();
            if (linkName == null || linkName.equals ( ("")))
            {
               // no name, no link
               return;
            }

            UMLObject sourceObj = (UMLObject)  ((PEObjListEntry) rolePanel.getLeftComboSelectedItem()).getItem();
            UMLObject targetObj = (UMLObject)  ((PEObjListEntry) rolePanel.getRightComboSelectedItem()).getItem();

            // instance of
            UMLAssoc myAssoc = findOrNewAssocForLinkName (linkName, sourceObj, targetObj);
            link.setInstanceOf (myAssoc);

            link.setName (linkName);

            // range
            link.setRange ( (range.getText() == null) ? "" : range.getText());
            // type and modifier
            link.setType (type.getSelectedButtonIndex());
            link.setModifier (modifier.getSelectedButtonIndex());
            link.setTotality (set.isSelected());
            link.setAssertInUnitTest (assertion.isSelected());

            UMLObject oldSourceObj = link.getSource();
            UMLObject oldTargetObj = link.getTarget();

            // update the connected objects
            if (oldSourceObj != sourceObj)
            {
               link.setSource (sourceObj);
            }

            if (oldTargetObj != targetObj)
            {
               link.setTarget (targetObj);
            }

            for (Iterator iter = oldLink.iteratorOfDiagrams(); iter.hasNext(); )
            {
               ASGDiagram diag = (ASGDiagram) iter.next();
               diag.addToElements (link);
            }
            oldLink.removeYou();

         }
         else if ( (asgElement instanceof UMLObject) &&  (second instanceof UMLObject))
         {
            String linkName = name.getText();
            String pathText = pathExpr.getText();

            UMLObject sourceObj = (UMLObject)  ((PEObjListEntry) rolePanel.getLeftComboSelectedItem()).getItem();
            UMLObject targetObj = (UMLObject)  ((PEObjListEntry) rolePanel.getRightComboSelectedItem()).getItem();

            if (linkName != null && !linkName.equals (""))
            {
               // the linkName is provided


               boolean doLink =  (pathText == null || pathText.equals (""));

               if (doLink)
               {
                  UMLAssoc myAssoc = findOrNewAssocForLinkName (linkName, sourceObj, targetObj);
                  link = new UMLLink (name.getText(),
                     type.getSelectedButtonIndex(),
                     modifier.getSelectedButtonIndex(),
                     "",
                     sourceObj, targetObj,
                     myAssoc);

                  if (range.getText().length() > 0)
                  {
                     link.setRange (range.getText());
                  }

                  addToAllDiags (asgElement, link);

                  if (multiLinkRadioGoup.isEnabled() && link != null)
                  {
                     //delete all old UMLMultiLinks
                     if (link.getRevSourceLink() != null)
                     {
                        link.getRevSourceLink().removeYou();
                     }

                     if (link.getRevTargetLink() != null)
                     {
                        link.getRevTargetLink().removeYou();
                     }

                     switch (multiLinkRadioGoup.getSelectedButtonIndex())
                     {
                        //Any
                        case 0:
                        {
                           //All old UMLMultiLinks were deleted above
                        }
                           break;
                        //First
                        case 1:
                        {
                           MultiLinkGenerator myGenerator = new MultiLinkGenerator();
                           UMLObject obj = (UMLObject) containerComboBox.getSelectedItem();
                           myGenerator.generateFirstMultiLink (obj, link);
                        }
                           break;
                        //Last
                        case 2:
                        {
                           MultiLinkGenerator myGenerator = new MultiLinkGenerator();
                           UMLObject obj = (UMLObject) containerComboBox.getSelectedItem();
                           myGenerator.generateLastMultiLink (obj, link);
                        }
                           break;
                        default:
                        {
                        }
                           break;
                     }
                  }
               }
            } // doLink
            else
            {
               // do a path
               pathText = pathExpr.getText();
               if (pathText != null && !pathText.equals (""))
               {
                  UMLPath myPath = new UMLPath (sourceObj, pathText, targetObj);

                  // add to story pattern
                  Iterator iter = sourceObj.iteratorOfDiagrams();
                  if (iter.hasNext())
                  {
                     UMLDiagram diag = (UMLDiagram) iter.next();
                     diag.addToElements (myPath);
                  }
               }

            }
         }
         else if (link != null)
         {
            //Remove all existing UMLMultiLinks
            if (link.getRevSourceLink() != null)
            {
               link.getRevSourceLink().removeYou();
            }

            if (link.getRevTargetLink() != null)
            {
               link.getRevTargetLink().removeYou();
            }
         }
      }
   }


   private void addToAllDiags (ASGElement asgElement, UMLLink link)
   {
      /*
       *  First add items to ViewDiagramms and later to StoryPattern.
       *  Otherways updating StoryPattern would removes all unlinked
       *  objects from ViewDiagramms
       */
      Iterator diags =  ((UMLObject) asgElement).iteratorOfDiagrams();
      if (diags != null)
      {
         UMLDiagram diag = null;
         while (diags.hasNext())
         {
            diag = (UMLDiagram) diags.next();
            if ( (diag.hasInElements (asgElement)) &&  (diag.hasInElements (second)))
            {
               if (diag instanceof ViewDiagram)
               {
                  ViewDiagram viewDiag = (ViewDiagram) diag;
                  // Fix Me selction Dialog for ViewDefinitions needed
                  Iterator viewDefIter = viewDiag.iteratorOfViewDefinitions();
                  if (viewDefIter.hasNext())
                  {
                     ViewDefinition viewDefinition = (ViewDefinition) viewDefIter.next();
                     //viewDefinition.addToItems (link, viewDiag.getOriginalDiagram ());
                     viewDefinition.addToItems (link);
                     viewDefinition.addToStartItems (link);
                  } // if

                  //viewDiag.update (true);
               } // if

            } // if

         } // while

         diags =  ((UMLObject) asgElement).iteratorOfDiagrams();
         if (diags != null)
         {
            diag = null;
            while (diags.hasNext())
            {
               diag = (UMLDiagram) diags.next();
               if ( (diag.hasInElements (asgElement)) &&  (diag.hasInElements (second)))
               {
                  if (! (diag instanceof ViewDiagram))
                  {
                     diag.addToElements (link);
                  }
               }
            }
         }
      }
   }


   private UMLAssoc findOrNewAssocForLinkName (String linkName, UMLObject sourceObj, UMLObject targetObj)
   {
      UMLAssoc myAssoc = (UMLAssoc) associations.getSelectedIncrement();

      if (myAssoc == null || !linkName.equals (myAssoc.getName()))
      {
         // try to find other assoc for the current linkName
         myAssoc = findAssocForLinkName (linkName);
         if (myAssoc == null)
         {
            // create assoc on the fly
            myAssoc = this.createAssocOnTheFly (sourceObj, targetObj, linkName);
         }
      }
      return myAssoc;
   }


   private UMLAssoc findAssocForLinkName (String linkName)
   {
      if (linkName == null)
      {
         return null;
      }

      for (Enumeration myEnum = associations.elements(); myEnum.hasMoreElements(); )
      {
         UMLAssoc myAssoc = (UMLAssoc)  ((PEItem) myEnum.nextElement()).getIncrement();
         if (linkName.equals (myAssoc.getName()))
         {
            // got it
            return myAssoc;
         }
      }

      // nothing found
      return null;
   }


   /**
    * @param sourceObj
    * @param targetObj
    * @param name       No description provided
    * @return           No description provided
    */
   private UMLAssoc createAssocOnTheFly (UMLObject sourceObj, UMLObject targetObj, String name)
   {
      // retrieve classes and add a many to many assoc between them
      UMLClass srcClass = sourceObj.getInstanceOf();
      UMLClass tgtClass = targetObj.getInstanceOf();
      if (srcClass == null || tgtClass == null)
      {
         return null;
      }

      //----- create a new assoc, with roles and cardinalities
      UMLRole leftRole = new UMLRole();
      leftRole.setCard (new UMLCardinality());
      leftRole.setTarget (srcClass);
      UMLRole rightRole = new UMLRole();
      rightRole.setCard (new UMLCardinality());
      rightRole.setTarget (tgtClass);

      UMLAssoc result = new UMLAssoc (name, UMLAssoc.LEFTRIGHT, null, leftRole, rightRole);
//      UMLAssoc result = new UMLAssoc (name,
//         srcClass, srcClass.getName() + "s", "0..n",
//         tgtClass, tgtClass.getName() + "s", "0..n");

      // the source cardinality defaults to 0..1
      leftRole.getCard().setCardString ("0..1");

      String rightRoleName = name;
      if (name.endsWith ("s") || name.endsWith ("en"))
      {
         // this looks like a 0..n cardinality
         rightRole.getCard().setCardString ("0..n");
      }
      else
      {
         // default is a 0..1 cardinality
         rightRole.getCard().setCardString ("0..1");
      }

      String leftRoleName = EditAssocDialog.toUnused (srcClass.getName(), leftRole, rightRoleName, rightRole, tgtClass);
      leftRole.setName (leftRoleName);

      rightRoleName = EditAssocDialog.toUnused (rightRoleName, rightRole, leftRoleName, leftRole, srcClass);
      rightRole.setName (rightRoleName);

      // add it to the class diags
      EditAssocDialog.addAssocToAllClassDiags (result);

      return result;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected void cancel() { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void selectionChanged()
   {
      ASGElement selectedAssoc = associations.getSelectedIncrement();
      if (selectedAssoc != null)
      {
         name.setText (selectedAssoc.getText());
      }

      if (selectedAssoc instanceof UMLAssoc)
      {
         UMLAssoc assoc = (UMLAssoc) selectedAssoc;
         checkMultiLinkMode (assoc);
      }
      else
      {
         multiLinkRadioGoup.setEnabled (false);
         containerComboBox.setEnabled (false);
      }

   } //selectionChanged()


   /**
    * Overwrites buttonActionPerformed from PEBasicPropertyEditor
    *
    * @param buttonIdentifier  No description provided
    * @param e                 No description provided
    * @return                  No description provided
    */
   public boolean buttonActionPerformed (String buttonIdentifier, ActionEvent e)
   {
      if (buttonIdentifier.equals (IDRef))
      {
         name.setReadOnly (true);
      } // if

      else if (buttonIdentifier.equals (ChildElement) && name.isReadOnly())
      {
         name.setReadOnly (false);
      } // if

      return PEButton.remainedUnbound;
   } // buttonActionPerformed


   /**
    * This class renders the content of containerComboBox in human readable format
    *
    * @author    $Author: creckord $
    * @version   $Revision: 1.93.2.2 $
    */
   class MyCellRenderer extends JLabel implements ListCellRenderer
   {
      /**
       * Constructor for class MyCellRenderer
       */
      public MyCellRenderer()
      {
         setOpaque (true);
      }


      /**
       * Get the listCellRendererComponent attribute of the MyCellRenderer object
       *
       * @param list          No description provided
       * @param value         No description provided
       * @param index         No description provided
       * @param isSelected    No description provided
       * @param cellHasFocus  No description provided
       * @return              The listCellRendererComponent value
       */
      public Component getListCellRendererComponent (JList list, Object value,
                                                     int index, boolean isSelected, boolean cellHasFocus)
      {
         if (isSelected)
         {
            setBackground (list.getSelectionBackground());
            setForeground (list.getSelectionForeground());
         }
         else
         {
            setBackground (list.getBackground());
            setForeground (list.getForeground());
         }

         if (value instanceof UMLObject)
         {
            UMLObject obj = (UMLObject) value;
            setText (" " + obj.getObjectName() + ": " + obj.getInstanceOf() + " ");
         }
         else
         {
            setText ("unknown_value");
         }

         return this;
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: creckord $
    * @version   $Revision: 1.93.2.2 $
    */
   class PESelectionListener implements ListSelectionListener
   {
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      PEActLink adaptor;


      /**
       * Constructor for class PESelectionListener
       *
       * @param adapter  No description provided
       */
      PESelectionListener (PEActLink adapter)
      {
         adaptor = adapter;
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void valueChanged (ListSelectionEvent e)
      {
         adaptor.selectionChanged();
      }
   }


   /**
    * Encapsulates UMLObjects only.
    *
    * @author    $Author: creckord $
    * @version   $Revision: 1.93.2.2 $
    */
   class PEObjListEntry extends PEListEntry
   {

      /**
       * Constructor for class PEObjListEntry
       *
       * @param obj  No description provided
       */
      public PEObjListEntry (UMLObject obj)
      {
         super (obj);
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @return   No description provided
       */
      public String toString()
      {
         UMLObject tmpObj = (UMLObject) this.getItem();
         String result = tmpObj.getObjectName();
         if (!tmpObj.isBound())
         {
            result += ":" + tmpObj.getObjectType();
         }
         return result;
      }
   }


   /**
    * Listener class for recalculating assocs if other items are selected
    *
    * @author    $Author: creckord $
    * @version   $Revision: 1.93.2.2 $
    */
   class PERolePanelItemListener implements ItemListener
   {

      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      private PEActLink adaptee;


      /**
       * Constructor for class PERolePanelItemListener
       *
       * @param adaptee  No description provided
       */
      public PERolePanelItemListener (PEActLink adaptee)
      {
         this.adaptee = adaptee;
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void itemStateChanged (ItemEvent e)
      {
         adaptee.rolePanelItemStateChanged (e);
      }
   }

}

/*
 * $Log: PEActLink.java,v $
 * Revision 1.93.2.2  2006/06/07 09:13:30  creckord
 * - UMLTransitionGuard can be null instead of UMLTransitionGuard.NONE
 * - old "repair assoc" code removed (access methods are not kept, so repairing them is no longer needed)
 * - loop bends for assocs are removed when loop is removed
 *
 */
