/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gui;

import javax.swing.*;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.uml.*;
import de.uni_paderborn.fujaba.views.ViewDiagram;


/**
 * @author    $Author: cschneid $
 * @version   $Revision: 1.18 $
 */
public class NopActivityPanel extends ActivityPanel
{
   /**
    * Constructor for class NopActivityPanel
    *
    * @param asgElement  No description provided
    */
   public NopActivityPanel (ASGElement asgElement)
   {
      setAsgElement (asgElement);
      if (isResponsible())
      {
         setLayout (new BoxLayout (this, BoxLayout.Y_AXIS));

         add (new JLabel (" There are no user-editable properties."));
         add (new JLabel (" Just press \"Add\" for a new NOP activity."));
      }
   } // constructor


   /**
    * Get the name attribute of the NopActivityPanel object
    *
    * @return   The name value
    */
   public String getName()
   {
      return "NOP";
   } // getName


   /**
    * Get the responsible attribute of the NopActivityPanel object
    *
    * @return   The responsible value
    */
   public boolean isResponsible()
   {
      return  (getAsgElement() instanceof UMLActivityDiagram ||
          (getAsgElement() instanceof ViewDiagram &&  ((ViewDiagram) getAsgElement()).getOriginalDiagram() instanceof UMLActivityDiagram));
   } // isResponsible


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public UMLActivity parse()
   {
      UMLNopActivity nop = null;

      if (getAsgElement() instanceof UMLActivityDiagram)
      {
         UMLActivityDiagram diag = (UMLActivityDiagram) getAsgElement();
         if (diag != null)
         {
            nop = new UMLNopActivity();
            diag.addToElements (nop);
         }
      }
      else if (getAsgElement() instanceof ViewDiagram)
      {
         UMLActivityDiagram diag = (UMLActivityDiagram)  ((ViewDiagram) getAsgElement()).getOriginalDiagram();
         if (diag != null)
         {
            nop = new UMLNopActivity();
            diag.addToElements (nop);
         }
      }

      return nop;
   } // parse


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void unparse()
   {
   } // unparse

}

/*
 * $Log: NopActivityPanel.java,v $
 * Revision 1.18  2005/01/27 15:44:46  cschneid
 * bugfixes, new libraries, SDMObjectDialog improved, add activity in transition
 *
 */
