/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gui;

import javax.swing.*;

import de.uni_paderborn.fujaba.metamodel.FRole;
import de.uni_paderborn.fujaba.uml.UMLAssoc;
import de.uni_paderborn.fujaba.uml.UMLRole;


/**
 * this combobox is used to select a assoc, aggregation or a composition. <p>
 *
 * FIX ME: prehaps we could use very nice little icons instead of boring ASCII-stuff.
 *
 * @author    $Author: zuendorf $
 * @version   $Revision: 1.17 $
 */
public class KindComboBox extends JComboBox
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String NORMAL = "--------------------";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String RIGHT_AGG = "------------------< >";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String LEFT_AGG = "< >------------------";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String RIGHT_COMP = "------------------<*>";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String LEFT_COMP = "<*>------------------";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String LEFT_REF = "<--------------------";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String RIGHT_REF = "-------------------->";


   /**
    * Constructor for class KindComboBox
    */
   public KindComboBox()
   {
      this.addItem (NORMAL);
      this.addItem (RIGHT_AGG);
      this.addItem (LEFT_AGG);
      this.addItem (RIGHT_COMP);
      this.addItem (LEFT_COMP);
      this.addItem (RIGHT_REF);
      this.addItem (LEFT_REF);
   }


   /**
    * this function swaps the direction of the selected item, if it is a aggregation or a composition.
    */
   public void swapDirection()
   {
      int direction = this.getDirection();
      if (direction == UMLAssoc.RIGHTLEFT)
      {
         this.adjustDirection (UMLAssoc.LEFTRIGHT);
      }
      else if (direction == UMLAssoc.LEFTRIGHT)
      {
         this.adjustDirection (UMLAssoc.RIGHTLEFT);
      }
   }


   /**
    * this function adjust the direction of the current selection. a aggregation or a composition.
    *
    * @param direction  the direction to which the selction should be adjusted (valid arguments
    *      are: UMLAssoc.LEFTRIGHT or UMLAssoc.RIGHTLEFT)
    */
   public void adjustDirection (int direction)
   {
      Object sel = this.getSelectedItem();
      if (direction == UMLAssoc.RIGHTLEFT)
      {
         if (sel == LEFT_AGG)
         {
            this.setSelectedItem (RIGHT_AGG);
         }
         else if (sel == LEFT_COMP)
         {
            this.setSelectedItem (RIGHT_COMP);
         }
         else if (sel == LEFT_REF)
         {
            this.setSelectedItem (RIGHT_REF);
         }
      }
      else
      {
         if (sel == RIGHT_AGG)
         {
            this.setSelectedItem (LEFT_AGG);
         }
         else if (sel == RIGHT_COMP)
         {
            this.setSelectedItem (LEFT_COMP);
         }
         else if (sel == RIGHT_REF)
         {
            this.setSelectedItem (LEFT_REF);
         }
      }
   }


   /**
    * @return   the direction of the current selction. If it is a aggregation or a composition
    *      the return value is UMLAssoc.LEFTRIGHT or UMLAssoc.RIGHTLEFT. Else it is -1
    */
   public int getDirection()
   {
      Object sel = this.getSelectedItem();
      if (sel == RIGHT_AGG || sel == RIGHT_COMP || sel == RIGHT_REF)
      {
         return UMLAssoc.RIGHTLEFT;
      }
      else if (sel == LEFT_AGG || sel == LEFT_COMP || sel == LEFT_REF)
      {
         return UMLAssoc.LEFTRIGHT;
      }
      return -1;
   }


   /**
    * Get the selected attribute of the KindComboBox object
    *
    * @return   The selected value
    */
   public String getSelected()
   {
      Object sel = this.getSelectedItem();
      return (String) sel;
   }


   /**
    * unparse the data of the leftRole and rightRole-object to the ComboBox data.
    *
    * @param leftRole   the left role of the current dialog (could be null)
    * @param rightRole  the right role of the current dialog (could be null)
    * @param assoc      No description provided
    */
   public void unparse (UMLAssoc assoc, UMLRole leftRole, UMLRole rightRole)
   {
      if (leftRole != null && rightRole != null && assoc != null)
      {
         if (assoc.getDirection() == UMLAssoc.LEFTRIGHT)
         {
            if (leftRole.getAdornment() == FRole.AGGREGATION)
            {
               this.setSelectedItem (LEFT_AGG);
            }
            else if (leftRole.getAdornment() == FRole.COMPOSITION)
            {
               this.setSelectedItem (LEFT_COMP);
            }
            else if (rightRole.getAdornment() == FRole.REFERENCE)
            {
               this.setSelectedItem (RIGHT_REF);
            }
            else
            {
               this.setSelectedItem (NORMAL);
            }
         }
         else
         {
            if (rightRole.getAdornment() == FRole.AGGREGATION)
            {
               this.setSelectedItem (RIGHT_AGG);
            }
            else if (rightRole.getAdornment() == FRole.COMPOSITION)
            {
               this.setSelectedItem (RIGHT_COMP);
            }
            else if (leftRole.getAdornment() == FRole.REFERENCE)
            {
               this.setSelectedItem (LEFT_REF);
            }
            else
            {
               this.setSelectedItem (NORMAL);
            }
         }
      }
      else
      {
         this.setSelectedItem (NORMAL);
      }
   }


   /**
    * parse the data of the ComboBox to the leftRole and rightRole-object
    *
    * @param leftRole   the left role of the current dialog (could NOT be null)
    * @param rightRole  the right role of the current dialog (could NOT be null)
    */
   public void parse (UMLRole leftRole, UMLRole rightRole)
   {
      Object sel = this.getSelectedItem();

      if (sel == LEFT_AGG)
      {
         leftRole.setAdornment (FRole.AGGREGATION);
         rightRole.setAdornment (FRole.NONE);
      }
      else if (sel == LEFT_COMP)
      {
         leftRole.setAdornment (FRole.COMPOSITION);
         rightRole.setAdornment (FRole.NONE);
      }
      else if (sel == LEFT_REF)
      {
         leftRole.setAdornment (FRole.REFERENCE);
         rightRole.setAdornment (FRole.NONE);
      }
      else if (sel == RIGHT_AGG)
      {
         leftRole.setAdornment (FRole.NONE);
         rightRole.setAdornment (FRole.AGGREGATION);
      }
      else if (sel == RIGHT_COMP)
      {
         leftRole.setAdornment (FRole.NONE);
         rightRole.setAdornment (FRole.COMPOSITION);
      }
      else if (sel == RIGHT_REF)
      {
         leftRole.setAdornment (FRole.NONE);
         rightRole.setAdornment (FRole.REFERENCE);
      }
      else
      {
         leftRole.setAdornment (FRole.NONE);
         rightRole.setAdornment (FRole.NONE);
      }
   }
}

/*
 * $Log: KindComboBox.java,v $
 * Revision 1.17  2005/03/02 13:23:17  zuendorf
 * Alt Left Right to switch between panels
 *
 */
