/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gui;

import java.io.File;

import javax.swing.JFrame;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.19.2.2 $
 */
public class FileComboDialog extends ComboDialog
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static String defLabel = "Please choose a file:";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static String defTitle = "File chooser";


   /**
    * @param f
    * @param filelist  No description provided
    */
   public FileComboDialog (JFrame f, File[] filelist)
   {
      this (f, defLabel, defTitle, filelist);
   }


   /**
    * @param f
    * @param label
    * @param title
    * @param other
    * @param filelist  No description provided
    */
   public FileComboDialog (JFrame f, String label, String title, File[] filelist, int other)
   {
      super (f, label, title, filelist, other);
   }


   /**
    * @param f
    * @param label
    * @param title
    * @param filelist  No description provided
    */
   public FileComboDialog (JFrame f, String label, String title, File[] filelist)
   {
      super (f, label, title, filelist);
   }


   /**
    * Get the selectedFile attribute of the FileComboDialog object
    *
    * @return   The selectedFile value
    */
   public File getSelectedFile()
   {
      return (File) getSelectedItem();
   }


   /**
    * Sets the fileList attribute of the FileComboDialog object
    *
    * @param filelist  The new fileList value
    */
   public void setFileList (File[] filelist)
   {
      setItemList (filelist);
   }
}

/*
 * $Log: FileComboDialog.java,v $
 * Revision 1.19.2.2  2005/08/23 08:24:40  lowende
 * Removed compile warnings.
 *
 */
