/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gui;

import java.awt.*;

import javax.swing.*;


/**
 * FPopupMenu is a wrapper class for a JPopupMenu, which overwrites the show method in that
 * case, that the popup menu is shown on the screen and is not cuttet off by the screens bounds.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.11 $
 */
public class FPopupMenu
{
   /**
    * Display the popupmenu at the position x,y in the coordinate space of the component invoker.
    * The position is recalculated if the popup menu can not be shown in the screen. Therefore
    * the position is calculated as follows: x = (x + popupwidth > screenwidth) ? (x - popupwidth)
    * : x y = min (screenheight - popupheight, y) If the popupmenu is larger than the screensize,
    * the menu will popup at position (0,0) or (0,y) or (x,0).
    *
    * @param menu     the popup menu to display
    * @param invoker  The component in whose space the popupmenu is to appear
    * @param x        the x coordinate in invoker's coordinate space at which the popup menu
    *      is to be displayed
    * @param y        the y coordinate in invoker's coordinate space at which the popup menu
    *      is to be displayed
    */
   public static void show (JPopupMenu menu, Component invoker, int x, int y)
   {
      if (menu != null)
      {
         Dimension pDim = menu.getPreferredSize();
         Dimension sDim = Toolkit.getDefaultToolkit().getScreenSize();

         // don't know what to do if there is no invoker :-(
         if (invoker != null)
         {
            // a popup menu could appear over the frames bounds
            Point locOnScreen = invoker.getLocationOnScreen();
            // get absolute position on the screen of the click
            Point absPosOfMouseClickOnScreen = new Point (locOnScreen);
            absPosOfMouseClickOnScreen.translate (x, y);
            // recalculate the popup's position
            int newX =  (absPosOfMouseClickOnScreen.x + pDim.width > sDim.width) ?  (x - pDim.width) : x;
            int newY =  (absPosOfMouseClickOnScreen.y + pDim.height > sDim.height) ?  (y -  (absPosOfMouseClickOnScreen.y + pDim.height - sDim.height)) : y;

            // uups, it might happen, that the recalculated absolute position is smaller than zero
            // in that case position the popup menu on the top and left.
            x =  (absPosOfMouseClickOnScreen.x - x < 0) ? x : newX;
            y =  (absPosOfMouseClickOnScreen.y - y < 0) ? y : newY;

         }

         menu.show (invoker, x, y);
      }
   }

}

/*
 * $Log: FPopupMenu.java,v $
 * Revision 1.11  2004/11/03 10:18:03  lowende
 * Javadoc warnings removed.
 *
 */
