/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gui;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;

import javax.swing.*;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.gui.comp.FujabaDialog;
import de.uni_paderborn.fujaba.uml.*;
import de.uni_paderborn.fujaba.views.ViewDiagram;
import de.upb.tools.fca.FEmptyIterator;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.16 $
 */
public class EditNameAndConstraintsDialog extends FujabaDialog
{
   /**
    * Constructor for class EditNameAndConstraintsDialog
    *
    * @param frame       No description provided
    * @param enableName  No description provided
    */
   public EditNameAndConstraintsDialog (JFrame frame, boolean enableName)
   {
      super (frame, "Constraint editor", true);

      guiInit (enableName);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JList constraintList;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private DefaultListModel constraintListModel;

   // the textfields
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JTextField constraintTextField;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JTextField nameField;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private ASGElement incr = null;



   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param enableName  No description provided
    */
   public void guiInit (boolean enableName)
   {
      JPanel mainPanel = new JPanel (new BorderLayout());
      mainPanel.setLayout (new BoxLayout (mainPanel, BoxLayout.Y_AXIS));

      // list of collab. stats.
      JPanel constraintListPanel = new JPanel (new BorderLayout());

      constraintListPanel.setBorder (new TitledBorder ("Constraint selection list"));

      constraintListModel = new DefaultListModel();
      constraintList = new JList (constraintListModel);

      JScrollPane constraintScrollPane = new JScrollPane (constraintList);
      constraintList.addListSelectionListener (
         new ListSelectionListener()
         {
            public void valueChanged (ListSelectionEvent e)
            {
               UMLConstraint constraint = (UMLConstraint) constraintList.getSelectedValue();
               if (constraint != null)
               {
                  String constraintText = constraint.getText();
                  if (constraintText != null)
                  {
                     constraintTextField.setText (constraintText);
                  }
               }
            }
         }
         );
      constraintListPanel.add (constraintScrollPane);

      // name
      JPanel namePanel = new JPanel (new BorderLayout());
      namePanel.setBorder (new TitledBorder ("Name"));
      nameField = new JTextField();
      namePanel.add (nameField, BorderLayout.NORTH);

      // constraint text
      JPanel constraintPanel = new JPanel (new BorderLayout());
      constraintPanel.setBorder (new TitledBorder ("Constraint text"));
      constraintTextField = new JTextField();
      constraintPanel.add (constraintTextField, BorderLayout.NORTH);

      // some buttons
      JPanel buttonPanel = new JPanel (new FlowLayout());
      JButton applyButton = new JButton ("Apply");
      JButton newButton = new JButton ("New");
      JButton removeButton = new JButton ("Remove");
      applyButton.addActionListener (
         new ActionListener()
         {
            public void actionPerformed (ActionEvent e)
            {
               writeFieldsToConstraint ((UMLConstraint) constraintList.getSelectedValue());
            }
         }
         );

      newButton.addActionListener (
         new ActionListener()
         {
            public void actionPerformed (ActionEvent e)
            {
               makeNewConstraint();
            }
         }
         );

      removeButton.addActionListener (
         new ActionListener()
         {
            public void actionPerformed (ActionEvent e)
            {
               removeConstraint ((UMLConstraint) constraintList.getSelectedValue());
            }
         }
         );
      buttonPanel.add (newButton);
      buttonPanel.add (applyButton);
      buttonPanel.add (removeButton);

      if (enableName)
      {
         mainPanel.add (namePanel);
      }

      mainPanel.add (constraintListPanel);
      mainPanel.add (constraintPanel);
      mainPanel.add (buttonPanel);

      // standard stuff
      Container container = this.getContentPane();
      container.setLayout (new BorderLayout());
      container.add ("North", mainPanel);
      container.add ("South", this.guiPanelOkCancelHelp());
      pack();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   void makeNewConstraint()
   {
      UMLConstraint newConstraint = new UMLConstraint();

      if (incr instanceof UMLIncrement)
      {
          ((UMLIncrement) incr).addToConstraints (newConstraint);
      }
      else if (incr instanceof UMLDiagram)
      {
          ((UMLDiagram) incr).addToConstraints (newConstraint);
      }
      constraintListModel.addElement (newConstraint);
      writeFieldsToConstraint (newConstraint);
      clearFieldsAndUpdateListBox();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param constraint  No description provided
    */
   void removeConstraint (UMLConstraint constraint)
   {
      constraintListModel.removeElement (constraint);
      constraint.removeYou();
      clearFieldsAndUpdateListBox();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private void clearFieldsAndUpdateListBox()
   {
      constraintList.setModel (constraintListModel);
      constraintTextField.setText ("");
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param constraint  No description provided
    */
   void writeFieldsToConstraint (UMLConstraint constraint)
   {
      if (constraint != null)
      {
         constraint.setText (constraintTextField.getText());
         clearFieldsAndUpdateListBox();
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param incr  No description provided
    */
   public void unparse (ASGElement incr)
   {
      this.incr = incr;
      if (incr != null)
      {
         if (incr instanceof UMLStoryPattern ||
             (incr instanceof ViewDiagram &&  ((ViewDiagram) incr).getOriginalDiagram() instanceof UMLStoryPattern))
         {
            nameField.setText (incr.getName());
         }

         Iterator iter = null;
         if (incr instanceof UMLIncrement)
         {
            iter =  ((UMLIncrement) incr).iteratorOfConstraints();
         }
         else if (incr instanceof UMLDiagram)
         {
            iter =  ((UMLDiagram) incr).iteratorOfConstraints();
         }
         else
         {
            iter = FEmptyIterator.get();
         }

         while (iter.hasNext())
         {
            UMLConstraint tmpConst = (UMLConstraint) iter.next();
            constraintListModel.addElement (tmpConst);
         }
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void parse()
   {
      String name = nameField.getText();
      if ( (incr instanceof UMLStoryPattern ||
          (incr instanceof ViewDiagram &&  ((ViewDiagram) incr).getOriginalDiagram() instanceof UMLStoryPattern))
         && name.trim().length() != 0)
      {
         incr.setName (name);
      }
   }

}

/*
 * $Log: EditNameAndConstraintsDialog.java,v $
 * Revision 1.16  2004/10/20 17:49:52  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
