/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

import de.uni_paderborn.fujaba.gui.comp.FujabaDialog;
import de.uni_paderborn.fujaba.uml.UMLBaseTypes;
import de.uni_paderborn.fujaba.uml.UMLCollabStat;
import de.uni_paderborn.fujaba.uml.UMLIncrement;
import de.uni_paderborn.fujaba.uml.UMLObject;
import de.uni_paderborn.fujaba.uml.UMLProject;
import de.uni_paderborn.fujaba.uml.UMLStoryActivity;
import de.uni_paderborn.fujaba.uml.UMLStoryPattern;
import de.uni_paderborn.fujaba.uml.UMLType;
import de.uni_paderborn.fujaba.uml.UMLTypeList;
import de.uni_paderborn.lib.basic.ImageResourceManager;
import de.uni_paderborn.lib.classloader.UPBClassLoader;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: creckord $
 * @version   $Revision: 1.53.2.5 $
 */
public class EditCollabStatDialog extends FujabaDialog
{
   /**
    * Constructor for class EditCollabStatDialog
    *
    * @param frame  No description provided
    */
   public EditCollabStatDialog (JFrame frame)
   {
      super (frame, "Collaboration statements editor", true);
      collabStats = new DefaultListModel();
      targets = new DefaultComboBoxModel();
      sources = new DefaultComboBoxModel();
      this.guiInit();
   }

   // latin capital letter o with stroke
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static String nullObject = "\330";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JList collabStatList;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private DefaultListModel collabStats;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JComboBox targetComboBox;


   /**
    * Get the targetComboBox attribute of the EditCollabStatDialog object
    *
    * @return   The targetComboBox value
    */
   public JComboBox getTargetComboBox()
   {
      return targetComboBox;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JComboBox sourceComboBox;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private DefaultComboBoxModel targets;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private DefaultComboBoxModel sources;

   // the textfields
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JTextField callTextField;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JTextField loopVarNameField;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JTextField startValueField;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JTextField stopValueField;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JTextField ifCondTextField;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JTextField whileLoopTextField;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JTextField numberTextField;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JTextField assignTargetField;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JComboBox assignTargetTypeField;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JCheckBox storyPatternBox;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JCheckBox sequenceBarBox;

   /**
    * Enable "Call on elements of Set" for sets
    */
   JCheckBox callOnElementsOfSetBox;


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void guiInit()
   {
      JPanel myPanel = new JPanel (new BorderLayout());

      // list of collab. stats.
      JPanel collabStatListPanel = new JPanel (new BorderLayout());
      JScrollPane scrollPane = new JScrollPane (myPanel);

      collabStatListPanel.setBorder (new TitledBorder ("Select a collab. stat. to modify or delete"));
      collabStatList = new JList (collabStats);
      collabStatList.setVisibleRowCount (5);
      collabStats.addElement ("[empty]");

      JScrollPane collabStatScrollPane = new JScrollPane (collabStatList);
      //FIX ME: Why the heck does the list determine a wrong preferred size and does not scroll?!?
      //quite bad fix for this:
      collabStatList.setPreferredSize (new Dimension (100, 500));

      collabStatList.addListSelectionListener (
         new ListSelectionListener()
         {
            public void valueChanged
                (ListSelectionEvent e)
            {
               fillFieldsFromCollabStat
                   ((UMLCollabStat)
                  collabStatList.getSelectedValue());

            }
         }
         );
      collabStatListPanel.add (collabStatScrollPane, BorderLayout.CENTER);
      myPanel.add (collabStatListPanel, BorderLayout.NORTH);

      //Panel for source, arrow and target
      JPanel sourceTargetPanel = new JPanel (new FlowLayout());

      // source selection
      JPanel sourceComboBoxPanel = new JPanel (new BorderLayout());
      sourceComboBoxPanel.setBorder (new TitledBorder ("source"));

      sourceComboBox = new JComboBox (sources);
      sourceComboBox.setRenderer (new MyCellRenderer());
      sourceComboBoxPanel.add (sourceComboBox);
      sourceTargetPanel.add (sourceComboBoxPanel);

      // arrow icon
      ImageResourceManager imgManager = ImageResourceManager.get();

      ImageIcon arrowIcon = imgManager.getImageIcon (UPBClassLoader.DEFAULT_CLASSLOADER, "de/uni_paderborn/fujaba/app/images/arrowright.gif");
      JLabel arrowIconLabel = new JLabel (arrowIcon);
      sourceTargetPanel.add ("Center", arrowIconLabel);

      // target selection
      JPanel targetComboBoxPanel = new JPanel (new BorderLayout());
      targetComboBoxPanel.setBorder (new TitledBorder ("target"));
      targetComboBox = new JComboBox (targets);
      targetComboBox.setRenderer (new MyCellRenderer());
      targetComboBox.addActionListener (new CheckForSetActionListener (this));
      targetComboBoxPanel.add (targetComboBox);
      sourceTargetPanel.add (targetComboBoxPanel);
      myPanel.add (sourceTargetPanel);

      //// fields to edit
      // for-panel
      JPanel forPanel = new JPanel (new FlowLayout());
      forPanel.add (new JLabel ("for "));
      loopVarNameField = new JTextField (2);
      forPanel.add (loopVarNameField);
      forPanel.add (new JLabel (" := "));
      startValueField = new JTextField (2);
      forPanel.add (startValueField);
      forPanel.add (new JLabel (" to "));
      stopValueField = new JTextField (2);
      forPanel.add (stopValueField);
      forPanel.add (new JLabel (" do ..."));

      // if-panel
      JPanel ifPanel = new JPanel (new FlowLayout());
      ifPanel.add (new JLabel ("if "));
      ifCondTextField = new JTextField (11);
      ifPanel.add (ifCondTextField);
      ifPanel.add (new JLabel (" then ..."));

      // while-panel
      JPanel whilePanel = new JPanel (new FlowLayout());
      whilePanel.add (new JLabel ("while "));
      whileLoopTextField = new JTextField (10);
      whilePanel.add (whileLoopTextField);
      whilePanel.add (new JLabel (" do ..."));

      // number id
      JPanel numberThreadPanel = new JPanel (new FlowLayout());
      numberThreadPanel.setBorder (new TitledBorder ("time flow"));
      numberTextField = new JTextField (10);
      numberThreadPanel.add (numberTextField);
      numberThreadPanel.add (new JLabel (" :"));

      // for-if-while box
      JPanel forIfWhilePanel = new JPanel();
      forIfWhilePanel.setLayout (new BoxLayout (forIfWhilePanel, BoxLayout.Y_AXIS));
      forIfWhilePanel.setBorder (new TitledBorder ("conditions / iterations"));
      forIfWhilePanel.add (forPanel);
      forIfWhilePanel.add (ifPanel);
      forIfWhilePanel.add (whilePanel);

      // assign target and call text
      JPanel assignCallPanel = new JPanel (new FlowLayout());
      assignTargetField = new JTextField (7);
      assignTargetTypeField = new JComboBox (new String[]{""});
      UMLTypeList typeList = UMLProject.get().getTypeList();
      if (typeList != null)
      {
         UMLType umlType;
         Iterator types = typeList.sortedIteratorOfTypes();
         while (types.hasNext())
         {
            umlType = (UMLType) types.next();
            if (umlType instanceof UMLBaseTypes)
            {
               String name =  ((UMLBaseTypes) umlType).getName();
               if (!UMLBaseTypes.INITIALIZER.equals (name) && !UMLBaseTypes.VOID.equals (name) &&
                  !UMLBaseTypes.CONSTRUCTOR.equals (name))
               {
                  assignTargetTypeField.addItem (umlType);
               }
            }
         }
      }

      assignCallPanel.add (new JLabel (" ... "));
      assignCallPanel.add (assignTargetTypeField);
      assignCallPanel.add (assignTargetField);
      assignCallPanel.add (new JLabel (" := "));
      callTextField = new JTextField (20);
      callTextField.addKeyListener (new CompletionKeyListener (null));
      assignCallPanel.add (callTextField);

      JPanel setModePanel = new JPanel (new FlowLayout());
      callOnElementsOfSetBox = new JCheckBox ("Call on each element of the set");
      callOnElementsOfSetBox.setSelected (true);
      callOnElementsOfSetBox.setToolTipText ("The call is performed on the elements " +
         "of the set.");
      callOnElementsOfSetBox.addChangeListener (new AssignTargetFieldDisablerChangeListener (this));
      setModePanel.add (callOnElementsOfSetBox);

      JPanel assignCallSetmodePanel = new JPanel();
      assignCallSetmodePanel.setLayout (new BoxLayout (assignCallSetmodePanel, BoxLayout.Y_AXIS));
      assignCallSetmodePanel.setBorder (new TitledBorder ("assign target and call text"));
      assignCallSetmodePanel.add (assignCallPanel);
      assignCallSetmodePanel.add (setModePanel);

      // show type
      JPanel showTypePanel = new JPanel (new FlowLayout());
      showTypePanel.setBorder (new TitledBorder ("show"));
      storyPatternBox = new JCheckBox ("storypattern");
      sequenceBarBox = new JCheckBox ("sequencebar");
      showTypePanel.add (storyPatternBox);
      showTypePanel.add (sequenceBarBox);
      storyPatternBox.addItemListener (
         new ItemListener()
         {
            public void itemStateChanged (ItemEvent e)
            {
               updateShowType();
            }
         }
         );

      sequenceBarBox.addItemListener (
         new ItemListener()
         {
            public void itemStateChanged (ItemEvent e)
            {
               updateShowType();
            }
         }
         );

      // some buttons
      JPanel buttonPanel = new JPanel (new FlowLayout());
      JButton applyButton = new JButton ("Apply");
      JButton newButton = new JButton ("New");
      JButton removeButton = new JButton ("Remove");
      applyButton.addActionListener (
         new ActionListener()
         {
            public void actionPerformed (ActionEvent e)
            {
               try
               {
                  writeFieldsToCollabStat ((UMLCollabStat) collabStatList.getSelectedValue());
               }
               catch (IllegalStateException ise)
               {
                  showPropertyError();
               }
            }
         }
         );

      newButton.addActionListener (
         new ActionListener()
         {
            public void actionPerformed (ActionEvent e)
            {
               makeNewCollabStat();
            }
         }
         );

      removeButton.addActionListener (
         new ActionListener()
         {
            public void actionPerformed (ActionEvent e)
            {
               removeCollabStat (
                  (UMLCollabStat)
                  collabStatList.getSelectedValue()
                  );
            }
         }
         );
      buttonPanel.add (newButton);
      buttonPanel.add (applyButton);
      buttonPanel.add (removeButton);

      ////
      JPanel textFieldsPanel = new JPanel();
      textFieldsPanel.setLayout (new BoxLayout (textFieldsPanel, BoxLayout.Y_AXIS));
      myPanel.add ("South", textFieldsPanel);
      textFieldsPanel.add (numberThreadPanel);
      textFieldsPanel.add (forIfWhilePanel);
      textFieldsPanel.add (assignCallSetmodePanel);
      textFieldsPanel.add (showTypePanel);
      textFieldsPanel.add (buttonPanel);

      // standard stuff
      java.awt.Container container = this.getContentPane();
      container.setLayout (new BorderLayout());
      container.add ("Center", scrollPane);
      container.add ("South", this.guiPanelCloseHelp());
      this.pack();
      collabStatList.setPreferredSize (collabStatList.getSize());
      collabStats.removeAllElements();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private UMLIncrement incr;


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   void updateShowType()
   {
      if (myPattern != null)
      {
         boolean showStoryPattern = storyPatternBox.isSelected();
         boolean showSequenceBar = sequenceBarBox.isSelected();
         if (showStoryPattern && showSequenceBar)
         {
            myPattern.setShowType (UMLStoryPattern.SHOWBOTH);
         }
         else if (showStoryPattern)
         {
            myPattern.setShowType (UMLStoryPattern.SHOWSTORYPATTERN);
         }
         else if (showSequenceBar)
         {
            myPattern.setShowType (UMLStoryPattern.SHOWSEQUENCEBAR);
         }
         else
         { // one must be selected

            myPattern.setShowType (UMLStoryPattern.SHOWSTORYPATTERN);
            storyPatternBox.setSelected (true);
         }
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param collabStat  No description provided
    */
   void fillFieldsFromCollabStat (UMLCollabStat collabStat)
   {
      if (collabStat != null)
      {
         callTextField.setText (collabStat.getCallText());
         loopVarNameField.setText (collabStat.getLoopVarName());
         startValueField.setText (collabStat.getLoopStartVal());
         stopValueField.setText (collabStat.getLoopStopVal());
         ifCondTextField.setText (collabStat.getIfCondText());
         whileLoopTextField.setText (collabStat.getWhileLoopText());
         numberTextField.setText (collabStat.getNoText() + collabStat.getThreadId());
         assignTargetField.setText (collabStat.getAssignTgtText());
         assignTargetTypeField.setSelectedItem (collabStat.getAssignTgtType());
         callOnElementsOfSetBox.setSelected (collabStat.isCallOnElementsOfSet());

         UMLObject target = collabStat.getCallTarget();
         if (target != null)
         {
            targetComboBox.setSelectedItem (target);
         }
         else
         {
            targetComboBox.setSelectedItem (nullObject);
         }

         UMLObject source = collabStat.getCallSource();
         if (source != null)
         {
            sourceComboBox.setSelectedItem (source);
         }
         else
         {
            sourceComboBox.setSelectedItem ("this");
         }
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   void makeNewCollabStat()
   {
      UMLCollabStat collabStat = new UMLCollabStat();
      if (masterCollabStat == null)
      {
         // generate a masterCollabStat first
         masterCollabStat = new UMLCollabStat();
         masterCollabStat.setMyPattern (myPattern);
      }
      masterCollabStat.addFirstToSubStats (collabStat);
      try
      {
         writeFieldsToCollabStat (collabStat);
         clearFieldsAndUpdateListBox();
      }
      catch (IllegalStateException ise)
      {
         collabStat.removeYou();
         showPropertyError();
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param collabStat  No description provided
    */
   void removeCollabStat (UMLCollabStat collabStat)
   {
      if (collabStat.sizeOfSubStats() == 0)
      {
         // remove leafs only
         UMLCollabStat parent = collabStat.getFatherStat();
         collabStat.removeYou();
         while (parent != null && parent.sizeOfSubStats() == 0 && parent.sizeOfDiagrams() == 0)
         {
            UMLCollabStat tmp = parent;
            parent = parent.getFatherStat();
            if (parent == tmp)
            {
               parent = null;
            }
            tmp.removeYou();
         }
         myPattern.renumberCollabStats();
         clearFieldsAndUpdateListBox();
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static Pattern NUMBER_PATTERN = Pattern.compile ("(\\d+)([_a-zA-Z]\\w*)?");


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param collabStat                 No description provided
    * @param noText                     No description provided
    * @throws IllegalArgumentException  Exception description not provided
    * @throws NumberFormatException     Exception description not provided
    */
   void parseNoText (UMLCollabStat collabStat, String noText) throws IllegalArgumentException, NumberFormatException
   {
      UMLCollabStat master = collabStat.getRootFatherStat();
      UMLCollabStat parent = master;
      String parentNoText = null;
      noText = noText.trim();
      int lastDot = noText.lastIndexOf ('.');
      if (lastDot > -1)
      {
         parentNoText = noText.substring (0, lastDot);
         noText = noText.substring (lastDot + 1);
      }

      Matcher matcher = NUMBER_PATTERN.matcher (noText);
      if (matcher.matches())
      {
         int number = Integer.parseInt (matcher.group (1));
         String thread = matcher.group (2);
         collabStat.setNumber (number);
         if (thread != null && thread.length() > 0)
         {
            collabStat.setThreadId (thread);
         }
         if (parentNoText != null)
         {
            parent = master.findSubStat (parentNoText);
            if (parent == null)
            {
               parent = master.createSubStat (parentNoText);
            }
         }
         parent.addFirstToSubStats (collabStat);
      }
      else
      {
         throw new IllegalArgumentException ("Malformed sequence path expression: " + noText);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param collabStat              No description provided
    * @throws IllegalStateException  Exception description not provided
    */
   void writeFieldsToCollabStat (UMLCollabStat collabStat) throws IllegalStateException
   {
      if (collabStat != null)
      {
         String noText = numberTextField.getText();
         if (noText.trim().length()==0)
         {
            collabStat.setNumber(Integer.MAX_VALUE);
            collabStat.setThreadId(null);
            collabStat.setFatherStat(masterCollabStat);
         }
         else
         {
            String oldText = collabStat.getNoText();
            try
            {
               parseNoText(collabStat, noText);
            }
            catch (IllegalArgumentException iae)
            {
               try
               {
                  collabStat.setNoText(oldText);
               }
               catch (Exception ex)
               {}
               showNumberError (numberTextField.getText());
            }
         }

         collabStat.setCallText (callTextField.getText());
         collabStat.setLoopVarName (loopVarNameField.getText());
         collabStat.setLoopStartVal (startValueField.getText());
         collabStat.setLoopStopVal (stopValueField.getText());
         collabStat.setIfCondText (ifCondTextField.getText());
         collabStat.setWhileLoopText (whileLoopTextField.getText());
         collabStat.setAssignTgtText (assignTargetField.getText());
         Object type = assignTargetTypeField.getSelectedItem();

         boolean show =  (collabStat.getCallText().trim().length() + collabStat.getAssignTgtText().trim().length() +
            collabStat.getLoopVarName().trim().length() + collabStat.getIfCondText().trim().length() +
            collabStat.getWhileLoopText().trim().length()) > 0;

         if (type instanceof UMLType)
         {
            collabStat.setAssignTgtType ((UMLType) type);
         }
         else
         {
            collabStat.setAssignTgtType (null);
         }

         if (callOnElementsOfSetBox.isEnabled())
         {
            collabStat.setCallOnElementsOfSet (callOnElementsOfSetBox.isSelected());
         }
         else
         {
            collabStat.setCallOnElementsOfSet (false);
         }

         Object selectedItem = targetComboBox.getSelectedItem();

         if (selectedItem instanceof UMLObject)
         {
            collabStat.setCallTarget ((UMLObject) selectedItem);
         }
         else
         {
            collabStat.setCallTarget (null);
         }

         selectedItem = sourceComboBox.getSelectedItem();
         if (selectedItem instanceof UMLObject)
         {
            collabStat.setCallSource ((UMLObject) selectedItem);
         }
         else
         {
            collabStat.setCallSource (null);
         }

         if (!show && collabStat.sizeOfSubStats() == 0)
         {
            throw new IllegalStateException ("Too few properties filled in");
         }
         if (collabStat.sizeOfDiagrams() == 0 && show)
         {
            myPattern.addToElements (collabStat);
         }
         else if (collabStat.sizeOfDiagrams() > 0 && !show)
         {
            collabStat.removeAllFromDiagrams();
         }

         myPattern.renumberCollabStats();
         clearFieldsAndUpdateListBox();
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param text  No description provided
    */
   private void showNumberError (String text)
   {
      JOptionPane.showMessageDialog (this, "Invalid Sequence Number: " + text, "Error: Invalid Parameter", JOptionPane.ERROR_MESSAGE);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   void showPropertyError()
   {
      JOptionPane.showMessageDialog (this, "Too few parameters.\n\nPlease fill out at least the call text or one of the condition/iteration fields",
         "Error: Too few Parameters", JOptionPane.ERROR_MESSAGE);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private void clearFieldsAndUpdateListBox()
   {
      collabStats.clear();
      if (masterCollabStat != null)
      {
         myPattern.renumberCollabStats();
         collectCollabStats (masterCollabStat);
      }
      collabStatList.setModel (collabStats); // is there a better way to update the list?

      callTextField.setText ("");
      loopVarNameField.setText ("");
      startValueField.setText ("");
      stopValueField.setText ("");
      ifCondTextField.setText ("");
      whileLoopTextField.setText ("");
      numberTextField.setText ("");
      assignTargetField.setText ("");
      assignTargetTypeField.setSelectedItem ("");
      targetComboBox.setSelectedItem (nullObject);
   }


   /**
    * Sets the increment attribute of the EditCollabStatDialog object
    *
    * @param incr  The new increment value
    */
   public void setIncrement (UMLIncrement incr)
   {
      this.incr = incr;
      KeyListener callFieldListener = callTextField.getKeyListeners()[0];
      if (callFieldListener instanceof CompletionKeyListener)
      {
          ((CompletionKeyListener) callFieldListener).setContext (incr, false);
      }
      parse();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   UMLCollabStat masterCollabStat;


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param master  No description provided
    */
   private void collectCollabStats (UMLCollabStat master)
   {
      if (master != null)
      {
         Enumeration enumeration = master.elementsOfSubStats();
         while (enumeration.hasMoreElements())
         {
            UMLCollabStat aCollabStat = (UMLCollabStat) enumeration.nextElement();
            collabStats.addElement (aCollabStat);
            collectCollabStats (aCollabStat);
         }
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private UMLStoryPattern myPattern = null;


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void parse()
   {
      if (incr != null)
      {
         if (incr instanceof UMLCollabStat)
         {
            myPattern =  ((UMLCollabStat) incr).findStoryPattern();
         }
         else if (incr instanceof UMLObject)
         {
            myPattern =  ((UMLStoryPattern)  ((UMLObject) incr).getFirstFromDiagrams());
         }
         else if (incr instanceof UMLStoryActivity)
         {
            myPattern =  ((UMLStoryActivity) incr).getStoryPattern();
         }
         if (myPattern != null)
         {
            // correct the order of the collabstats
            myPattern.renumberCollabStats();
            boolean showAllSources = myPattern.getType() == 1;

            masterCollabStat = myPattern.getRevMasterCollabStat();
            collectCollabStats (masterCollabStat);
            targets.addElement (nullObject); // dummy target for callTarget==null
            sources.addElement ("this");

            Iterator objects = myPattern.iteratorOfObjects();
            Object obj = null;
            while (objects.hasNext())
            {
               obj = objects.next();
               targets.addElement (obj);
               if (showAllSources)
               {
                  sources.addElement (obj);
               }
            }

            if (incr instanceof UMLCollabStat)
            {
               collabStatList.setSelectedValue (incr, true);
               fillFieldsFromCollabStat ((UMLCollabStat) incr);
            }
            switch (myPattern.getShowType())
            {
               case UMLStoryPattern.SHOWSTORYPATTERN:
                  storyPatternBox.setSelected (true);
                  sequenceBarBox.setSelected (false);
                  break;
               case UMLStoryPattern.SHOWSEQUENCEBAR:
                  storyPatternBox.setSelected (false);
                  sequenceBarBox.setSelected (true);
                  break;
               case UMLStoryPattern.SHOWBOTH:
                  storyPatternBox.setSelected (true);
                  sequenceBarBox.setSelected (true);
                  break;
            }
         }
      }
   }


   // ######################################################################

   /**
    * Disables the target text field if "Call on elements of set" is selected.
    *
    * @author    $Author: creckord $
    * @version   $Revision: 1.53.2.5 $
    */
   private static class AssignTargetFieldDisablerChangeListener implements ChangeListener
   {
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      EditCollabStatDialog eCSDialog = null;


      /**
       * Constructor for class AssignTargetFieldDisablerChangeListener
       *
       * @param editCollabStatDialog  No description provided
       */
      public AssignTargetFieldDisablerChangeListener (EditCollabStatDialog editCollabStatDialog)
      {
         if (editCollabStatDialog != null)
         {
            this.eCSDialog = editCollabStatDialog;
         }
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param changeEvent  No description provided
       */
      public void stateChanged (ChangeEvent changeEvent)
      {
         if (this.eCSDialog != null)
         {
            /*
             *  if (eCSDialog.callOnElementsOfSetBox.isSelected() &&
             *  eCSDialog.callOnElementsOfSetBox.isEnabled())
             *  {
             *  eCSDialog.assignTargetField.setEnabled (false);
             *  }
             *  else
             *  {
             */
            eCSDialog.assignTargetField.setEnabled (true);
            //}
         }

      }
   }


   /**
    * Action Listener for Target ComboBox. If target is set, "Call on elements of set" is enabled.
    *
    * @author    $Author: creckord $
    * @version   $Revision: 1.53.2.5 $
    */
   private static class CheckForSetActionListener implements ActionListener
   {
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      EditCollabStatDialog eCSDialog = null;


      /**
       * Constructor for class CheckForSetActionListener
       *
       * @param editCollabStatDialog  No description provided
       */
      public CheckForSetActionListener (EditCollabStatDialog editCollabStatDialog)
      {
         if (editCollabStatDialog != null)
         {
            this.eCSDialog = editCollabStatDialog;
         }
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void actionPerformed (ActionEvent e)
      {
         if (this.eCSDialog != null)
         {
            if (eCSDialog.targetComboBox.getSelectedItem() instanceof UMLObject)
            {
               UMLObject curObject = (UMLObject) eCSDialog.targetComboBox.getSelectedItem();
               if ( (curObject.getType() == UMLObject.SET) &&
                   (curObject.getModifier() != UMLObject.DELETE))
               {
                  eCSDialog.callOnElementsOfSetBox.setEnabled (true);
               }
               else
               {
                  eCSDialog.callOnElementsOfSetBox.setEnabled (false);
               }

               CompletionKeyListener completionListener = (CompletionKeyListener) eCSDialog.callTextField.getKeyListeners()[0];
               completionListener.setContext (curObject, false);
            }
         }
      }
   }

}


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: creckord $
 * @version   $Revision: 1.53.2.5 $
 */
class MyCellRenderer extends BasicComboBoxRenderer
{


   /**
    * Constructor for class MyCellRenderer
    */
   public MyCellRenderer()
   {
      super();
   }


   /**
    * Get the listCellRendererComponent attribute of the MyCellRenderer object
    *
    * @param list          No description provided
    * @param value         No description provided
    * @param index         No description provided
    * @param isSelected    No description provided
    * @param cellHasFocus  No description provided
    * @return              The listCellRendererComponent value
    */
   public Component getListCellRendererComponent (
                                                  JList list,
                                                  Object value,
                                                  int index,
                                                  boolean isSelected,
                                                  boolean cellHasFocus)
   {
      super.getListCellRendererComponent (list, value, index, isSelected, cellHasFocus);
      if (value instanceof UMLObject)
      {
         setText ( ((UMLObject) value).getObjectName());
      }
      return this;
   }
}

/*
 * $Log: EditCollabStatDialog.java,v $
 * Revision 1.53.2.5  2006/03/29 12:18:21  creckord
 * Fixed bug in CollabStat dialog when number field is empty
 *
 * Revision 1.53.2.4  2005/12/15 16:20:44  lowende
 * Removed a few compile warnings.
 *
 */
