/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gui;

import java.awt.*;
import java.awt.event.*;
import java.util.Iterator;
import java.util.TreeSet;

import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.CaretEvent;

import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.asg.ASGDiagram;
import de.uni_paderborn.fujaba.basic.Utility;
import de.uni_paderborn.fujaba.gui.comp.*;
import de.uni_paderborn.fujaba.metamodel.*;
import de.uni_paderborn.fujaba.uml.*;
import de.uni_paderborn.fujaba.views.ViewDiagram;


/**
 * @author    $Author: creckord $
 * @version   $Revision: 1.77.2.8 $
 */
public class EditAssocDialog extends FujabaDialog
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (EditAssocDialog.class);

   /*
    *  GUI-Stuff
    */
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JTextField textName = new JTextField();
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JTextField textLeftRoleName = new JTextField();
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JTextField textRightRoleName = new JTextField();
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JTextField textLeftCardinality = new JTextField();
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JTextField textRightCardinality = new JTextField();

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JRadioButton radioLeftToRight = new JRadioButton ("Left to right");
   /**
    * @see   UMLAssoc#isRolesTransient()
    */
   private JCheckBox transientCheckBox = new JCheckBox ("transient");
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JRadioButton radioRightToLeft = new JRadioButton ("Right to left");

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private VisibilityComboBox boxLeftVisibility = new VisibilityComboBox();
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private VisibilityComboBox boxRightVisibility = new VisibilityComboBox();

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JComboBox boxLeftClass = new JComboBox();
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JComboBox boxLeftQualifier = new JComboBox();
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JComboBox boxLeftQualifierAttrType = new JComboBox();
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   KindComboBox boxKind = new KindComboBox();
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JComboBox boxRightClass = new JComboBox();
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JComboBox boxRightQualifier = new JComboBox();
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JComboBox boxRightQualifierType = new JComboBox();
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JComboBox assocConstraints = new JComboBox();
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JTextField sortedComparator = new JTextField (10);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JComboBox boxStereotype = new JComboBox();

   /*
    *  Data-Stuff
    */
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private UMLAssoc assoc = null;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private UMLRole leftRole = null;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private UMLRole rightRole = null;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   boolean leftQualifierEnabled;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   boolean rightQualifierEnabled;

   // ######################################################################

   /**
    * use this constructor, if the user want to edit an association
    *
    * @param frame  No description provided
    * @param assoc  No description provided
    */
   public EditAssocDialog (JFrame frame, UMLAssoc assoc)
   {
      super (frame, "Association Editor - edit assoc", true);
      this.guiInit();
      this.assoc = assoc;
      this.leftRole = assoc.getLeftRole();
      this.rightRole = assoc.getRightRole();
      this.unparse (null, null);
      this.actionMode = true;
   }


   /**
    * use this constructor, if the user selected one class
    *
    * @param frame     No description provided
    * @param oneClass  No description provided
    */
   public EditAssocDialog (JFrame frame, UMLClass oneClass)
   {
      this (frame, oneClass, oneClass);
   }


   /**
    * use this constructor, if the user selected two classes
    *
    * @param frame       No description provided
    * @param leftClass   No description provided
    * @param rightClass  No description provided
    */
   public EditAssocDialog (JFrame frame, UMLClass leftClass, UMLClass rightClass)
   {
      super (frame, "Association Editor - new assoc", true);
      this.guiInit();
      this.unparse (leftClass, rightClass);
      this.actionMode = true;
   }

   // ######################################################################

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final void guiInit()
   {
      java.awt.Container container = this.getContentPane();
      container.setLayout (new BorderLayout());
      container.add (this.guiWorkPanel(), BorderLayout.CENTER);
      JPanel panel = this.guiPanelOkCancelHelp();
      container.add (panel, BorderLayout.SOUTH);
      this.pack();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   private final JPanel guiWorkPanel()
   {
      JPanel panel = new JPanel (new BorderLayout());
      panel.setBorder (new EmptyBorder (5, 5, 5, 5));

      // create panel that should contain
      // comboboxes for left and right class
      JPanel classPanel = new JPanel (new BorderLayout());
      classPanel.setBorder (new EmptyBorder (5, 5, 5, 5));

      JPanel leftPanel = new JPanel();
      leftPanel.setLayout (new BorderLayout());
      leftPanel.add (this.guiComboBoxBorder (this.boxLeftClass), BorderLayout.NORTH);
      this.boxLeftClass.addActionListener (new BoxClassActionListener());

      JPanel rightPanel = new JPanel();
      rightPanel.setLayout (new BorderLayout());
      rightPanel.add (this.guiComboBoxBorder (this.boxRightClass), BorderLayout.NORTH);
      this.boxRightClass.addActionListener (new BoxClassActionListener());

      // arrange panels, so the dialog will be useable even if
      // we have classes with long names and a small screen
      classPanel.add (leftPanel, BorderLayout.WEST);
      classPanel.add (rightPanel, BorderLayout.EAST);

      // add panel that contains left and right classes to top of panel
      panel.add (classPanel, BorderLayout.NORTH);
      // and the rest to the center
      panel.add (this.guiMiddle(), BorderLayout.CENTER);

      return panel;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   private final JPanel guiMiddle()
   {
      JPanel panel = new JPanel();

      //----- set gridbaglayout to the panel
      GridBagLayout gridbag = new GridBagLayout();
      GridBagConstraints constraints = new GridBagConstraints();
      panel.setLayout (gridbag);

      //----- some presettings to the constraints
      constraints.ipadx = 5;
      constraints.ipady = 5;
      constraints.insets = new Insets (5, 5, 5, 5);

      //----- add all gui-stuff to the panel

      //----- first row
      constraints.gridwidth = 1;
      constraints.anchor = GridBagConstraints.WEST;
      panel.add (this.guiLeftPanel ("LeftName",
         this.textLeftRoleName,
         constraints, gridbag));
      this.textLeftRoleName.addCaretListener (new TextRoleNameCaretListener());

      constraints.gridwidth = 2;
      constraints.anchor = GridBagConstraints.CENTER;
      panel.add (this.guiCenterPanel ("Assoc-Name",
         this.textName,
         constraints, gridbag));
      this.textName.addCaretListener (new TextNameCaretListener());

      constraints.gridwidth = GridBagConstraints.REMAINDER;
      constraints.anchor = GridBagConstraints.EAST;
      panel.add (this.guiRightPanel ("RightName",
         this.textRightRoleName,
         constraints, gridbag));
      this.textRightRoleName.addCaretListener (new TextRoleNameCaretListener());

      //----- second row
      constraints.gridwidth = 1;
      constraints.anchor = GridBagConstraints.WEST;
      constraints.fill = GridBagConstraints.HORIZONTAL;
      panel.add (this.guiLeftPanel ("Left Qualifier Name",
         this.boxLeftQualifier,
         constraints, gridbag));
      this.boxLeftQualifier.addActionListener (new BoxQualifierActionListener());
      constraints.gridwidth = GridBagConstraints.RELATIVE;
      constraints.anchor = GridBagConstraints.CENTER;
      panel.add (this.guiCenterPanel ("Kind",
         this.boxKind,
         constraints, gridbag));
      this.boxKind.addActionListener (new BoxKindActionListener());
      constraints.gridwidth = GridBagConstraints.REMAINDER;
      constraints.anchor = GridBagConstraints.EAST;
      panel.add (this.guiRightPanel ("Right Qualifier Name",
         this.boxRightQualifier,
         constraints, gridbag));
      this.boxRightQualifier.addActionListener (new BoxQualifierActionListener());

      //----- additional row for qualifier type
      constraints.gridwidth = 1;
      constraints.fill = GridBagConstraints.NONE;
      constraints.anchor = GridBagConstraints.WEST;
      panel.add (this.guiLeftPanel ("Left Qualifer Type",
         this.boxLeftQualifierAttrType,
         constraints, gridbag));

      constraints.gridwidth = GridBagConstraints.RELATIVE;
      constraints.anchor = GridBagConstraints.CENTER;
      panel.add (this.guiCenterPanel ("Constraints",
         assocConstraints,
         constraints, gridbag));

      constraints.gridwidth = GridBagConstraints.REMAINDER;
      constraints.anchor = GridBagConstraints.EAST;
      panel.add (this.guiRightPanel ("Right Qualifier Type",
         this.boxRightQualifierType,
         constraints, gridbag));

      //----- third row
      constraints.gridwidth = 1;
      constraints.fill = GridBagConstraints.NONE;
      constraints.anchor = GridBagConstraints.WEST;
      panel.add (this.guiLeftPanel ("LeftCardinality",
         this.textLeftCardinality,
         constraints, gridbag));

      constraints.gridwidth = GridBagConstraints.RELATIVE;
      constraints.anchor = GridBagConstraints.CENTER;
      panel.add (this.guiCenterPanel ("Comparator", sortedComparator,
         constraints, gridbag));

      constraints.gridwidth = GridBagConstraints.REMAINDER;
      constraints.anchor = GridBagConstraints.EAST;
      panel.add (this.guiRightPanel ("RightCardinality",
         this.textRightCardinality,
         constraints, gridbag));

      //----- fourth row
      constraints.gridx = 0;
      constraints.gridwidth = 1;
      constraints.anchor = GridBagConstraints.WEST;
      panel.add (this.guiLeftPanel ("LeftVisibility",
         this.boxLeftVisibility,
         constraints, gridbag));

      constraints.gridx = 1;
      constraints.gridwidth = 2;
      constraints.gridheight = 2;
      constraints.anchor = GridBagConstraints.CENTER;
      panel.add (this.guiCenterPanel (null, this.guiDirection(),
         constraints, gridbag));

      constraints.gridx = 1;
      constraints.gridwidth = 2;
      constraints.gridheight = 1;
      panel.add (this.guiCenterPanel (null, transientCheckBox,
         constraints, gridbag));

      constraints.gridx = 3;
      constraints.gridwidth = GridBagConstraints.REMAINDER;
      constraints.anchor = GridBagConstraints.EAST;
      panel.add (this.guiRightPanel ("RightVisibility",
         this.boxRightVisibility,
         constraints, gridbag));

      //----- fifth row (only left side)
      constraints.gridx = 0;
      constraints.gridwidth = 1;
      constraints.anchor = GridBagConstraints.WEST;
      panel.add (this.guiLeftPanel ("Stereotypes",
         this.boxStereotype,
         constraints, gridbag));

      return panel;
   }


   /**
    * this function generates a JPanel, with a left-adjusted Label and the container, also
    * left-adjusted
    *
    * @param text         No description provided
    * @param component    No description provided
    * @param constraints  No description provided
    * @param gridbag      No description provided
    * @return             No description provided
    */
   private final JPanel guiLeftPanel (String text, JComponent component,
                                      GridBagConstraints constraints,
                                      GridBagLayout gridbag)
   {
      JLabel label = new JLabel (text);
      JPanel panel = new JPanel();
      panel.setLayout (new BoxLayout (panel, BoxLayout.Y_AXIS));
      label.setAlignmentX (LEFT_ALIGNMENT);
      panel.add (label);
      component.setAlignmentX (LEFT_ALIGNMENT);
      panel.add (component);
      gridbag.setConstraints (panel, constraints);
      return panel;
   }


   /**
    * this function generates a JPanel, with a right-adjusted Label and the container, also
    * right-adjusted
    *
    * @param text         No description provided
    * @param component    No description provided
    * @param constraints  No description provided
    * @param gridbag      No description provided
    * @return             No description provided
    */
   private final JPanel guiRightPanel (String text, JComponent component,
                                       GridBagConstraints constraints,
                                       GridBagLayout gridbag)
   {
      JLabel label = new JLabel (text);
      JPanel panel = new JPanel();
      panel.setLayout (new BoxLayout (panel, BoxLayout.Y_AXIS));
      label.setAlignmentX (RIGHT_ALIGNMENT);
      panel.add (label);
      component.setAlignmentX (RIGHT_ALIGNMENT);
      panel.add (component);
      gridbag.setConstraints (panel, constraints);
      return panel;
   }


   /**
    * this function generates a JPanel, with a centered Label and the container, also centered-adjusted
    *
    * @param text         No description provided
    * @param component    No description provided
    * @param constraints  No description provided
    * @param gridbag      No description provided
    * @return             No description provided
    */
   private final JPanel guiCenterPanel (String text, JComponent component,
                                        GridBagConstraints constraints,
                                        GridBagLayout gridbag)
   {
      JLabel label = new JLabel (text);
      JPanel panel = new JPanel();
      panel.setLayout (new BoxLayout (panel, BoxLayout.Y_AXIS));
      if (text != null)
      {
         label.setAlignmentX (CENTER_ALIGNMENT);
         panel.add (label);
      }
      component.setAlignmentX (CENTER_ALIGNMENT);
      panel.add (component);
      gridbag.setConstraints (panel, constraints);
      return panel;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param box  No description provided
    * @return     No description provided
    */
   private final JPanel guiComboBoxBorder (JComboBox box)
   {
      JPanel panel = new JPanel (new BorderLayout());
      panel.setLayout (new BoxLayout (panel, BoxLayout.Y_AXIS));
      panel.setBorder (new LineBorder (Color.black));
      box.setAlignmentX (Component.CENTER_ALIGNMENT);
      box.setAlignmentY (Component.CENTER_ALIGNMENT);
      panel.add (box, BorderLayout.CENTER);
      return panel;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   private final JPanel guiDirection()
   {
      // group buttons
      ButtonGroup group = new ButtonGroup();
      group.add (this.radioLeftToRight);
      group.add (this.radioRightToLeft);

      // build panel
      JPanel panel = new JPanel();
      panel.setBorder (new TitledBorder ("Direction of the assoc"));
      panel.setLayout (new BoxLayout (panel, BoxLayout.Y_AXIS));

      panel.add (this.radioLeftToRight);
      panel.add (this.radioRightToLeft);

      radioLeftToRight.setEnabled (false);
      radioRightToLeft.setEnabled (false);

      return panel;
   }

   // ######################################################################

   /**
    * UML-AST to dialog
    *
    * @param leftClass   No description provided
    * @param rightClass  No description provided
    */
   public void unparse (UMLClass leftClass, UMLClass rightClass)
   {
      if (this.assoc != null)
      {
         this.leftRole = this.assoc.getLeftRole();
         this.rightRole = this.assoc.getRightRole();

         if (this.leftRole == null || this.rightRole == null)
         {
            this.assoc.removeYou();
            this.assoc = null;
            this.leftRole = null;
            this.rightRole = null;
         } // end of if ()

      }
      else
      {
         this.rightRole = null;
         this.leftRole = null;
      } // end of else

      if (this.leftRole != null && this.rightRole != null)
      {
         //----- fill the left- and rightClass varibales from
         //      the current selected assoc
         leftClass = this.leftRole.getTarget();
         rightClass = this.rightRole.getTarget();
      } // end of if ()

      //----- set the DataModel for the class names ComboBox
      this.unparseClassComboBox (this.boxLeftClass, leftClass);
      this.unparseClassComboBox (this.boxRightClass, rightClass);

      //----- set the DataModel for the qualifier ComboBox
      this.unparseQualifierComboBox (this.boxLeftQualifier, this.boxLeftQualifierAttrType, rightClass);
      this.unparseQualifierComboBox (this.boxRightQualifier, this.boxRightQualifierType, leftClass);

      this.unparseConstraintsComboBox (assocConstraints);

      this.unparseStereotypesComboBox (this.boxStereotype);

      if (this.assoc != null)
      {
         //----- use the data from the selected assoc
         //----- middle
         this.textName.setText (this.assoc.getName());
         this.boxKind.unparse (this.assoc, this.leftRole, this.rightRole);

         // Disable some Dialog components on unidirectional references...
         if (KindComboBox.LEFT_REF.equals (boxKind.getSelected()))
         {
            setLeftEditable();
         }
         else if (KindComboBox.RIGHT_REF.equals (boxKind.getSelected()))
         {
            setRightEditable();
         }

         transientCheckBox.setSelected (this.assoc.isRolesTransient());

         if (this.assoc.getDirection() == UMLAssoc.RIGHTLEFT)
         {
            this.radioRightToLeft.setSelected (true);
         }
         else
         {
            this.radioLeftToRight.setSelected (true);
         }
         //----- left side
         this.textLeftRoleName.setText (this.leftRole.getName());
         this.textLeftCardinality.setText (this.leftRole.getCard().getCardString());
         this.unparseQualifierSelect (this.boxLeftQualifier, this.boxLeftQualifierAttrType, this.leftRole);
         this.boxLeftVisibility.setUmlSelectedIndex (this.leftRole.getUmlVisibility());
         //----- right side
         this.textRightRoleName.setText (this.rightRole.getName());
         this.textRightCardinality.setText (this.rightRole.getCard().getCardString());
         this.unparseQualifierSelect (this.boxRightQualifier, this.boxRightQualifierType, this.rightRole);
         this.boxRightVisibility.setUmlSelectedIndex (this.rightRole.getUmlVisibility());

         // set Comparator
         sortedComparator.setEnabled (false);
         if (assoc.getSortedComparator() != null)
         {
            sortedComparator.setText (assoc.getSortedComparator());
            sortedComparator.setEnabled (assocConstraints.getSelectedItem().equals ("sorted"));
         }
      }
      else
      {
         //----- no assoc selected, use default stuff
         //----- middle
         this.textName.setText ("Assoc");
         this.boxKind.setSelectedItem (KindComboBox.NORMAL);
         this.radioLeftToRight.setSelected (true);

         //----- left side
         this.textLeftCardinality.setText ("0..1");
         this.boxLeftVisibility.setUmlSelectedIndex (FDeclaration.PUBLIC);

         //----- right side
         this.textRightCardinality.setText ("0..1");
         this.boxRightVisibility.setUmlSelectedIndex (FDeclaration.PUBLIC);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param box    No description provided
    * @param clazz  No description provided
    */
   private void unparseClassComboBox (JComboBox box, UMLClass clazz)
   {
      UMLDiagram tmpDiag = UMLProject.get().getCurrentUMLDiagram();

      while (tmpDiag != null && tmpDiag instanceof ViewDiagram)
      {
         tmpDiag =  ((ViewDiagram) tmpDiag).getDiagram();
      }

      if (tmpDiag == null ||
         ! (tmpDiag instanceof UMLClassDiagram))
      {
         Exception e = new Exception ("Something's wrong with diagram's editors");
         e.printStackTrace();
      }

      UMLClassDiagram diag = (UMLClassDiagram) tmpDiag;

      JglComboBoxModel model = new JglComboBoxModel (diag.getAllClassItems(), false);
      box.setModel (model);
      box.setSelectedItem (clazz);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private transient TreeSet names = new TreeSet();


   /**
    * Access method for an one to n association.
    *
    * @param clazz  The object added.
    */
   private void addAttributesFromClassToQualifierComboBox (UMLClass clazz)
   {
      if (clazz != null)
      {
         // Adding attribute names.
         Iterator iter = clazz.iteratorOfAllAttrs();
         while (iter.hasNext())
         {
            UMLAttr attr = (UMLAttr) iter.next();
            names.add (attr.getName());
         }
         iter = clazz.iteratorOfAllRoles();
         while (iter.hasNext())
         {
            final Object next = iter.next();
            if (next instanceof UMLRole)
            {
               UMLRole umlRole = (UMLRole) next;
               UMLRole partnerRole = umlRole.getPartnerRole();
               if (umlRole.getQualifier() == null &&
                  umlRole.getAdornment() != FRole.REFERENCE &&
                  getCardinality (partnerRole) == 1)
               {
                  names.add (partnerRole.getAttrName());
               }
            }
         }
      }
   }


   /**
    * Get the cardinality attribute of the EditAssocDialog object
    *
    * @param umlRole  No description provided
    * @return         The cardinality value
    */
   private int getCardinality (UMLRole umlRole)
   {
      int card = 1;
      UMLCardinality umlCard = umlRole.getCard();
      if (umlCard != null)
      {
         card = umlCard.getUpperBound();
      }
      return card;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param boxName  No description provided
    * @param boxType  No description provided
    * @param clazz    No description provided
    */
   void unparseQualifierComboBox (JComboBox boxName, JComboBox boxType, UMLClass clazz)
   {
      boxName.setEditable (true);
      boxType.setEnabled (true);

      if (clazz != null)
      {
         // Add the 'None' keyword.
         boxName.addItem ("None");

         names.clear();
         addAttributesFromClassToQualifierComboBox (clazz);

         Iterator iter = names.iterator();
         while (iter.hasNext())
         {
            boxName.addItem (iter.next());
         }

         // Adding attribute types.
         iter = UMLProject.get().getTypeList().sortedIteratorOfTypes();
         while (iter.hasNext())
         {
            UMLType type = (UMLType) iter.next();
            if (! (type instanceof UMLArray))
            {
               if (type instanceof FClass)
               {
                  boxType.addItem ( ((FClass) type).getFullClassName());
               }
               else
               {
                  boxType.addItem (type.getName());
               }
            }
         }
      }
      else
      {
         boxName.setModel (new DefaultComboBoxModel());
         boxType.setModel (new DefaultComboBoxModel());
      }

      // Select default settings.
      boxName.setSelectedItem ("None");
      boxType.setEnabled (false);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param box  No description provided
    */
   void unparseStereotypesComboBox (JComboBox box)
   {
      box.addItem (null);
      Iterator iter = UMLStereotypeManager.get().iteratorOfStereotypes();
      while (iter.hasNext())
      {
         UMLStereotype stereotype = (UMLStereotype) iter.next();
         box.addItem (stereotype);
      }

      if (this.assoc != null)
      {
         Iterator it = this.assoc.iteratorOfStereotypes();
         if (it.hasNext())
         {
            box.setSelectedItem (it.next());
         }
         if (it.hasNext())
         {
            JOptionPane.showMessageDialog (this, "EditAssocDialog cannot handle multiple stereotype for an assoc yet. " +
               "If you choose OK in the dialog only one stereotype will remain!");
         }
      }

   } // unparseStereotypesComboBox


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param boxName  No description provided
    * @param boxType  No description provided
    * @param role     No description provided
    */
   private void unparseQualifierSelect (JComboBox boxName, JComboBox boxType, UMLRole role)
   {
      UMLQualifier qualifier = role.getQualifier();
      if (qualifier != null)
      {
         boxName.setSelectedItem (qualifier.getName());
         if (qualifier.getType() != null)
         {
            UMLType type = qualifier.getType();
            if (! (type instanceof UMLArray))
            {
               if (type instanceof FClass)
               {
                  boxType.setSelectedItem ( ((FClass) type).getFullClassName());
               }
               else
               {
                  boxType.setSelectedItem (type.getName());
               }
            }

            //boxType.setSelectedItem (qualifier.getType().getName());
         } // end of if ()

         if (!qualifier.isExternalQualifier())
         {
            // The qualifier is an attribute, so the type can not be changed.
            boxType.setEnabled (false);
         }
         else
         {
            // The qualifier is not an attribute, so the type can be changed.
            boxType.setEnabled (true);
         }
      }
      else
      {
         boxName.setSelectedItem ("None");
         boxType.setEnabled (false);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param assocConstraints  No description provided
    */
   private void unparseConstraintsComboBox (JComboBox assocConstraints)
   {
      assocConstraints.addActionListener (new ConstraintBoxActionListener());

      assocConstraints.addItem ("No");
      assocConstraints.addItem ("sorted");
      assocConstraints.addItem ("ordered");
      assocConstraints.setSelectedIndex (0);

      if (assoc != null)
      {
         Iterator iter = assoc.iteratorOfConstraints();

         while (iter.hasNext())
         {
            UMLConstraint constraint = (UMLConstraint) iter.next();

            if (constraint.getText().equals ("sorted"))
            {
               assocConstraints.setSelectedIndex (1);
            }
            else if (constraint.getText().equals ("ordered"))
            {
               assocConstraints.setSelectedIndex (2);
            }
         }
      }
   }

   // ######################################################################

   /**
    * Sets the roleName attribute of the EditAssocDialog object
    *
    * @param role           The new roleName value
    * @param field          The new roleName value
    * @param nameBox        The new roleName value
    * @param classBox       The new roleName value
    * @param otherRoleName  The new roleName value
    * @param otherRole      The new roleName value
    */
   private void setRoleName (UMLRole role, JTextField field,
                             JComboBox nameBox, JComboBox classBox,
                             String otherRoleName, UMLRole otherRole)
   {
      String roleName = field.getText().trim();

      if ( (!roleName.equals ("")) && roleName.equals (role.getName()))
      {
         return;
      } // <=========== nothing to do

      UMLClass nameClass = getSelected (nameBox);
      UMLClass classClass = getSelected (classBox);
      if ( (nameClass == null) ||  (classClass == null))
      {
         if (log.isInfoEnabled())
         {
            log.info ("ALERT: EditAssocDialog: Some class  and a role name are missing.");
         }
         if (roleName.equals (""))
         {
            roleName = "role";
         }
      }
      else
      {
         if (roleName.equals (""))
         {
            roleName = nameClass.getName();
         }

         roleName = toUnused (roleName, role, otherRoleName, otherRole,
            classClass);
      }
      role.setName (roleName);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param roleName       No description provided
    * @param role           No description provided
    * @param otherRoleName  No description provided
    * @param otherRole      No description provided
    * @param clazz          No description provided
    * @return               No description provided
    */
   public static String toUnused (String roleName, UMLRole role, String otherRoleName, UMLRole otherRole,
                                  UMLClass clazz)
   {
      // perhaps the name is still available
      roleName = Utility.downFirstChar (roleName);

      UMLAttr existingAttr = clazz.getFromAllAttrs (roleName);
      UMLRole existingRole = findRole (clazz, roleName);

      String result = roleName;

      boolean mayBeSameName =  (role.getTarget() == otherRole.getTarget()) &&
          (role.getCard().getCardString() == otherRole.getCard().getCardString() ||
          (role.getCard().getCardString() != null &&
         role.getCard().getCardString().equals (otherRole.getCard().getCardString())));
      //FIXME: There's more that needs to be compared. Roles have to be equal in everything but the name.

      for (int i = 1; ! ( (existingAttr == null || existingAttr.getImplementingAssocRole() == role ||
          (mayBeSameName && existingAttr.getImplementingAssocRole() == otherRole))
         &&  (existingRole == null || existingRole == role ||
          (mayBeSameName && existingRole == otherRole))
         &&  (mayBeSameName || !result.equals (otherRoleName))); i++)
      {
         // this name is already in use, take next
         result = roleName + i;
         existingAttr = clazz.getFromAllAttrs (result);
         existingRole = findRole (clazz, result);
      }

      return result;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param umlClass  No description provided
    * @param name      No description provided
    * @return          No description provided
    */
   private static UMLRole findRole (UMLClass umlClass, String name)
   {
      Iterator roleIter = umlClass.iteratorOfAllRoles();
      while (roleIter.hasNext())
      {
         UMLRole umlRole = (UMLRole) roleIter.next();
         umlRole = umlRole.getPartnerRole();
         if (umlRole != null && name.equals (umlRole.getName()))
         {
            return umlRole;
         }
      }
      return null;
   }


   /**
    * dialog to UML-AST
    */
   public void parse()
   {
      if (this.assoc == null)
      {
         //----- create a new assoc, with roles and cardinalities
         this.leftRole = new UMLRole();
         this.leftRole.setCard (new UMLCardinality());
         this.rightRole = new UMLRole();
         this.rightRole.setCard (new UMLCardinality());
         this.assoc = new UMLAssoc (this.textName.getText(),
            UMLAssoc.LEFTRIGHT, null,
            this.leftRole, this.rightRole);
      }
      else
      {
         this.assoc.setName (this.textName.getText());
      }

      this.assoc.setRolesTransient (this.transientCheckBox.isSelected());

      /*
       *  ----- edit current assoc
       */
      if (this.radioRightToLeft.isSelected())
      {
         this.assoc.setDirection (UMLAssoc.RIGHTLEFT);
      }
      else
      {
         this.assoc.setDirection (UMLAssoc.LEFTRIGHT);
      }

      //---- kind of the assoc
      // DO NOT MIX UP the order of unparsing: at first the assoc
      // kind and then the qualifiers
      this.boxKind.parse (this.leftRole, this.rightRole);

      //----- left-side (name, qualifier, visibility, stereotypes)
      this.leftRole.getCard().setCardString (this.textLeftCardinality.getText());
      this.leftRole.setUmlVisibility (
         this.boxLeftVisibility.getUmlSelectedIndex());
      this.parseQualifierComboBox (this.boxLeftQualifier, this.boxLeftQualifierAttrType, this.leftRole);
      this.parseClassComboBox (this.boxLeftClass, this.leftRole);

      this.parseStereotypes (this.boxStereotype, this.assoc);

      //----- right-side (name, qualifier, visibility)
      this.rightRole.getCard().setCardString (this.textRightCardinality.getText());
      this.rightRole.setUmlVisibility (
         this.boxRightVisibility.getUmlSelectedIndex());
      this.parseQualifierComboBox (this.boxRightQualifier, this.boxRightQualifierType, this.rightRole);
      this.parseClassComboBox (this.boxRightClass, this.rightRole);

      //----- update constraints
      parseConstraints (assocConstraints);

      // set Comparator
      assoc.setSortedComparator (sortedComparator.getText());

      //----- role names at the end
      this.setRoleName (leftRole, this.textLeftRoleName,
         this.boxLeftClass, this.boxRightClass, null, rightRole);
      this.setRoleName (rightRole, this.textRightRoleName,
         this.boxRightClass, this.boxLeftClass,
         leftRole.getName(), leftRole);

      // add it to the class diags
      addAssocToAllClassDiags (assoc);
   }


   /**
    * @param assoc  The object added.
    */
   public static void addAssocToAllClassDiags (UMLAssoc assoc)
   {
      //----- add assoc to every diagram or remove, if nesseccary
      Iterator iter = UMLProject.get().iteratorOfDiags();
      UMLClass leftClass = assoc.getLeftRole().getTarget();
      UMLClass rightClass = assoc.getRightRole().getTarget();
      UMLDiagram diag;
      while (iter.hasNext())
      {
         ASGDiagram tmpDiag = (ASGDiagram) iter.next();
         if (tmpDiag instanceof UMLDiagram)
         {
            diag = (UMLDiagram) tmpDiag;
            if (diag.hasInElements (leftClass) && diag.hasInElements (rightClass))
            {
               //----- add assoc to diagram
               diag.addToElements (assoc);
               diag.addToElements (leftClass);
               diag.addToElements (rightClass);
            }
            else if (diag.hasInElements (assoc))
            {
               //----- remove assoc from diagram
               diag.removeFromElements (assoc);
            }
         }
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param boxName  No description provided
    * @param boxType  No description provided
    * @param role     No description provided
    */
   private final void parseQualifierComboBox (JComboBox boxName, JComboBox boxType, UMLRole role)
   {
      UMLQualifier qualifier;
      UMLClass clazz;
      UMLAttr attr;
      UMLType qType;
      String qName;

      qualifier = role.getQualifier();
      qName = (String) boxName.getSelectedItem();
      qType = UMLProject.get().getTypeList().getFromTypes ((String) boxType.getSelectedItem());

      if (!qName.equals ("None") && !qName.equals (""))
      { //&& !disabled)

         // Qualifier specified. Check if qualifier is an attribute.
         clazz = (UMLClass)  ( (boxName == boxLeftQualifier) ? boxRightClass.getSelectedItem() : boxLeftClass.getSelectedItem());
         attr = clazz.getFromAllAttrs (qName);

         if (qualifier == null)
         {
            qualifier = new UMLQualifier();
            qualifier.setRevQualifier (role);
         }

         qualifier.setQualifiedAttr (attr);
         if (attr == null)
         {
            UMLRole qualRole = clazz.getFromAllPartnerRoles (qName);
            qualifier.setQualifiedRole (qualRole);
            if (qualRole == null)
            {
               qualifier.setName (qName);
               qualifier.setType (qType);
            }
         }
         role.setAdornment (FRole.QUALIFIED);
      }
      else if (qualifier != null)
      {
         // Delete the qualifier from the assoc.
         role.setQualifier (null);
         qualifier.removeYou();

         if (role.getAdornment() == FRole.QUALIFIED)
         {
            role.setAdornment (FRole.NONE);
         }
      }

   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param box          No description provided
    * @param association  No description provided
    */
   private void parseStereotypes (JComboBox box, UMLAssoc association)
   {
      if (association != null)
      {
         association.removeAllFromStereotypes();
         UMLStereotype selectedStereotype;

         selectedStereotype = (UMLStereotype) box.getSelectedItem();
         association.addToStereotypes (selectedStereotype);
      }
   }


   /**
    * Get the selected attribute of the EditAssocDialog object
    *
    * @param box  No description provided
    * @return     The selected value
    */
   private UMLClass getSelected (JComboBox box)
   {
      Object sel = box.getSelectedItem();

      return  ( (sel instanceof UMLClass)
         ?  ((UMLClass) sel)
         : null);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param box   No description provided
    * @param role  No description provided
    */
   private final void parseClassComboBox (JComboBox box, UMLRole role)
   {
      UMLClass clazz = getSelected (box);
      if ( (clazz != null) &&  (role.getTarget() != clazz))
      {
         role.setTarget (clazz);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param assocConstraints  No description provided
    */
   private void parseConstraints (JComboBox assocConstraints)
   {
      String str = (String) assocConstraints.getSelectedItem();

      Iterator iter = assoc.iteratorOfConstraints();

      while (iter.hasNext())
      {
         UMLConstraint constraint = (UMLConstraint) iter.next();

         if (constraint.getText().equals ("sorted") || constraint.getText().equals ("ordered"))
         {
            assoc.removeFromConstraints (constraint);
         }
      }

      if (str.equals ("sorted") || str.equals ("ordered"))
      {
         assoc.addToConstraints (new UMLConstraint (str));
      }
   }


   /**
    * These methods are used to enable/disable the corresponding textFields/comboBoxes when
    * the association type of the new assoc is changed
    */
   void setLeftEditable()
   {
      textRightRoleName.setEditable (false);
      textRightCardinality.setEditable (false);
      boxRightVisibility.setEnabled (false);

      boxLeftQualifier.setSelectedItem ("None");

      boxLeftQualifier.setEditable (false);
      boxLeftQualifier.setEnabled (false);
      boxLeftQualifierAttrType.setEnabled (false);

      textLeftRoleName.setEditable (true);
      textLeftCardinality.setEditable (true);
      boxRightQualifier.setEditable (true);
      boxRightQualifier.setEnabled (true);
      boxLeftVisibility.setEnabled (true);

      if (rightQualifierEnabled)
      {
         boxRightQualifierType.setEnabled (true);
      }
   }


   /**
    * Sets the rightEditable attribute of the EditAssocDialog object
    */
   void setRightEditable()
   {
      textLeftRoleName.setEditable (false);
      textLeftCardinality.setEditable (false);
      boxLeftVisibility.setEnabled (false);

      boxRightQualifier.setSelectedItem ("None");

      boxRightQualifier.setEditable (false);
      boxRightQualifier.setEnabled (false);
      boxRightQualifierType.setEnabled (false);

      textRightRoleName.setEditable (true);
      textRightCardinality.setEditable (true);
      boxLeftQualifier.setEditable (true);
      boxLeftQualifier.setEnabled (true);
      boxRightVisibility.setEnabled (true);

      if (leftQualifierEnabled)
      {
         boxLeftQualifierAttrType.setEnabled (true);
      }
   }


   /**
    * Sets the allEditable attribute of the EditAssocDialog object
    */
   void setAllEditable()
   {
      // Enable all textFields
      textRightRoleName.setEditable (true);
      textRightCardinality.setEditable (true);
      textLeftRoleName.setEditable (true);
      textLeftCardinality.setEditable (true);

      boxRightVisibility.setEnabled (true);
      boxRightQualifier.setEditable (true);
      boxRightQualifier.setEnabled (true);
      boxLeftVisibility.setEnabled (true);
      boxLeftQualifier.setEditable (true);
      boxLeftQualifier.setEnabled (true);

      if (leftQualifierEnabled)
      {
         boxLeftQualifierAttrType.setEnabled (true);
      }
      if (rightQualifierEnabled)
      {
         boxRightQualifierType.setEnabled (true);
      }
   }

   // ######################################################################

   /*
    *  action-stuff
    */
   /**
    * this function is called if the OK-button is pressed
    */
   public void actionOkButton()
   {
      super.actionOkButton();
      /*
       *  String qL = (String) boxLeftQualifier.getSelectedItem();
       *  String qR = (String) boxRightQualifier.getSelectedItem();
       *  if (!qL.equals ("None") && !qL.equals ("") ||
       *  !qR.equals ("None") && !qR.equals (""))
       *  {
       *  super.actionOkButton();
       *  }
       */
   }

   // ######################################################################

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   boolean actionMode = false;


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: creckord $
    * @version   $Revision: 1.77.2.8 $
    */
   class BoxClassActionListener implements java.awt.event.ActionListener
   {
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void actionPerformed (ActionEvent e)
      {
         if (actionMode == true)
         {
            actionMode = false;
            JComboBox currentBox = (JComboBox) e.getSource();
            UMLClass selClass = (UMLClass) currentBox.getSelectedItem();
            if (currentBox == boxLeftClass)
            {
               unparseQualifierComboBox (boxRightQualifier, boxRightQualifierType, selClass);
               //boxRightQualifier.setSelectedItem (JglComboBoxModel.NONE);
               boxRightQualifier.setSelectedItem ("None");
            }
            else
            {
               unparseQualifierComboBox (boxLeftQualifier, boxLeftQualifierAttrType, selClass);
               //boxLeftQualifier.setSelectedItem (JglComboBoxModel.NONE);
               boxLeftQualifier.setSelectedItem ("None");
            }
            actionMode = true;
         }
      }
   } // end of class ActionClassComboBox


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: creckord $
    * @version   $Revision: 1.77.2.8 $
    */
   class BoxKindActionListener implements java.awt.event.ActionListener
   {
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void actionPerformed (ActionEvent e)
      {
         if (actionMode == true)
         {
            actionMode = false;
            int direction = boxKind.getDirection();
            if (direction == UMLAssoc.LEFTRIGHT &&
                (boxLeftQualifier.getSelectedItem() instanceof UMLAttr))
            {
               boxLeftQualifier.setSelectedItem (JglComboBoxModel.NONE);
            }
            else if (direction == UMLAssoc.RIGHTLEFT &&
                (boxRightQualifier.getSelectedItem() instanceof UMLAttr))
            {
               boxRightQualifier.setSelectedItem (JglComboBoxModel.NONE);
            }

            if (KindComboBox.RIGHT_REF.equals (boxKind.getSelected()))
            {
               // Right Reference selected: Disable roleName / cardinality / ... at right class
               setRightEditable();
            }
            else if (KindComboBox.LEFT_REF.equals (boxKind.getSelected()))
            {
               // Left Reference selected: Disable roleName / cardinality / ... at left class
               setLeftEditable();
            }
            else
            {
               setAllEditable();
            }
            actionMode = true;
         }
      }
   } // end of class ActionKindComboBox


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: creckord $
    * @version   $Revision: 1.77.2.8 $
    */
   class BoxQualifierActionListener implements java.awt.event.ActionListener
   {
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void actionPerformed (ActionEvent e)
      {
         JComboBox currentBox;
         JComboBox boxType;
         Object sel;
         String selection;
         UMLClass clazz;
         UMLAttr attr;
         UMLRole qualRole;
         int direction;

         if (actionMode == true)
         {
            actionMode = false;
            currentBox = (JComboBox) e.getSource();
            sel = currentBox.getSelectedItem();
            direction = boxKind.getDirection();

            if (sel instanceof String || direction != -1)
            {
               selection = (String) sel;

               if (currentBox == boxLeftQualifier &&
                  direction == UMLAssoc.LEFTRIGHT)
               {
                  boxKind.setSelectedItem (KindComboBox.NORMAL);
               }
               else if (currentBox == boxRightQualifier &&
                  direction == UMLAssoc.RIGHTLEFT)
               {
                  boxKind.setSelectedItem (KindComboBox.NORMAL);
               }

               clazz = (UMLClass)  ( (currentBox == boxLeftQualifier) ? boxRightClass.getSelectedItem() : boxLeftClass.getSelectedItem());
               boxType =  (currentBox == boxLeftQualifier) ? boxLeftQualifierAttrType : boxRightQualifierType;

               if (!selection.equals ("None") && !selection.equals (""))
               {
                  attr = clazz.getFromAllAttrs (selection);
                  if (attr != null)
                  {
                     boxType.setSelectedItem (attr.getUMLType().getName());
                     boxType.setEnabled (false);
                     if (boxType == boxLeftQualifierAttrType)
                     {
                        leftQualifierEnabled = false;
                     }
                     else
                     {
                        rightQualifierEnabled = false;
                     }
                  }
                  else
                  {
                     qualRole = clazz.getFromAllPartnerRoles (selection);
                     if (qualRole != null)
                     {
                        boxType.setSelectedItem (qualRole.getPartnerRole().getTarget());
                        boxType.setEnabled (false);
                        if (boxType == boxLeftQualifierAttrType)
                        {
                           leftQualifierEnabled = false;
                        }
                        else
                        {
                           rightQualifierEnabled = false;
                        }
                     }
                     else
                     {
                        boxType.setEnabled (true);
                        if (boxType == boxLeftQualifierAttrType)
                        {
                           leftQualifierEnabled = true;
                        }
                        else
                        {
                           rightQualifierEnabled = true;
                        }
                     }
                  }
               }
               else
               {
                  boxType.setEnabled (false);
                  if (boxType == boxLeftQualifierAttrType)
                  {
                     leftQualifierEnabled = false;
                  }
                  else
                  {
                     rightQualifierEnabled = false;
                  }
               }
            }
            actionMode = true;
         }
      }
   } // end of ActionQualifierComboBox


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: creckord $
    * @version   $Revision: 1.77.2.8 $
    */
   class TextNameCaretListener implements javax.swing.event.CaretListener
   {
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void caretUpdate (CaretEvent e)
      {
         if (actionMode == true)
         {
            getButtonOk().setEnabled ( (textName.getText().length() != 0));
            actionMode = true;
         }
      }
   } // end of ActionNameTextField


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: creckord $
    * @version   $Revision: 1.77.2.8 $
    */
   class TextRoleNameCaretListener implements javax.swing.event.CaretListener
   {
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void caretUpdate (CaretEvent e)
      {
         if (actionMode == true)
         {
            actionMode = true;
         }
      }
   } // end of ActionRoleNameTextField


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: creckord $
    * @version   $Revision: 1.77.2.8 $
    */
   class ConstraintBoxActionListener implements ActionListener
   {
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param event  No description provided
       */
      public void actionPerformed (ActionEvent event)
      {
         JComboBox box = (JComboBox) event.getSource();
         Object str = box.getSelectedItem();
         sortedComparator.setEnabled (str.equals ("sorted"));
      }
   }

}

/*
 * $Log: EditAssocDialog.java,v $
 * Revision 1.77.2.8  2006/06/07 09:13:30  creckord
 * - UMLTransitionGuard can be null instead of UMLTransitionGuard.NONE
 * - old "repair assoc" code removed (access methods are not kept, so repairing them is no longer needed)
 * - loop bends for assocs are removed when loop is removed
 *
 */
