/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.gui;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;


/**
 * Abstract dialog for convenience.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.11 $
 */
public abstract class AbstractDialog extends JDialog
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static int NONE = 0;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static int OK = 1;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static int CANCEL = 2;


   /**
    * Deriving classes have to call "createUserInterface ();" and "initialize ();" during construction.
    *
    * @param frame  No description provided
    * @param modal  No description provided
    * @see          #createUserInterface
    * @see          #initialize
    */
   public AbstractDialog (JFrame frame, boolean modal)
   {
      super (frame, modal);

      addWindowListener (new DialogClose());
   } // constructor


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private int userChoice = NONE;


   /**
    * Sets the userChoice attribute of the AbstractDialog object
    *
    * @param userChoice  The new userChoice value
    */
   protected void setUserChoice (int userChoice)
   {
      if (userChoice != NONE)
      {
         this.userChoice = userChoice;
      }
   }


   /**
    * Get the userChoice attribute of the AbstractDialog object
    *
    * @return   The userChoice value
    */
   public int getUserChoice()
   {
      return this.userChoice;
   }


   /**
    * Does all the stuff that has to be done during construction. Should be called by the constructor
    * of the derived class. Calls unparse ().
    *
    * @see   #unparse
    */
   protected void initialize()
   {
      unparse();
      pack();
      centerDialog();
   } // initialize


   /**
    * The default "Cancel" button.
    *
    * @see   #setOkButton
    * @see   #getOkButton
    */
   private JButton okButton;


   /**
    * @param button  The new okButton value
    * @see           #okButton
    */
   protected void setOkButton (JButton button)
   {
      this.okButton = button;
   }


   /**
    * @return   The okButton value
    * @see      #okButton
    */
   protected JButton getOkButton()
   {
      return this.okButton;
   }


   /**
    * The default "Cancel" button.
    *
    * @see   #setCancelButton
    * @see   #getCancelButton
    */
   private JButton cancelButton;


   /**
    * @param button  The new cancelButton value
    * @see           #cancelButton
    */
   protected void setCancelButton (JButton button)
   {
      this.cancelButton = button;
   }


   /**
    * @return   The cancelButton value
    * @see      #cancelButton
    */
   protected JButton getCancelButton()
   {
      return this.cancelButton;
   }


   /**
    * Read the parameters which can be modified and put all information into the dialogs user
    * interface. Called by initialize ().
    *
    * @see   #initialize
    */
   protected abstract void unparse();


   /**
    * Get all information from the user interface and put them back to the parameters that
    * can be modified by this dialog. Called by okPressed ().
    *
    * @see   #okPressed
    */
   protected abstract void parse();


   /**
    * Put all constraint checks that have to be verified before leaving the dialog into this
    * method.
    *
    * @return   true
    * @see      #okPressed
    */
   protected boolean checkConstraints()
   {
      return true;
   } // checkConstraints


   /**
    * Ok is pressed. Calls checkConstraints (), if constraints are positively verified, call
    * parse () and leave dialog.
    *
    * @see   #checkConstraints
    * @see   #parse
    */
   public void okPressed()
   {
      if (checkConstraints())
      {
         parse();
         setVisible (false);
         setUserChoice (OK);
      }
   } // okPressed


   /**
    * Cancel is pressed, so don't change anything and leave dialog.
    */
   public void cancelPressed()
   {
      setVisible (false);
      setUserChoice (CANCEL);
   } // cancelPressed


   /**
    * Adds the main panel by calling createMainPanel () and the button panel by calling createButtonPanel
    * () to an panel and returns it. Should be alled by the constructor of deriving classes.
    *
    * @see   #createMainPanel
    * @see   #createButtonPanel
    */
   protected void createUserInterface()
   {
      JPanel panel = new JPanel();
      panel.setLayout (new BorderLayout());
      panel.add (createButtonPanel(), BorderLayout.SOUTH);
      panel.add (createMainPanel(), BorderLayout.CENTER);

      getContentPane().add (panel);
   } // createUserInterface


   /**
    * Contains the complete user interface of the dialog, except "Ok" and "Cancel" buttons.
    * Called by createUserInterface ().
    *
    * @return   JPanel that is positioned in the middle of the dialog.
    * @see      #createUserInterface
    */
   protected abstract JPanel createMainPanel();


   /**
    * Creates a panel with two buttons on the right side. The default are an "Ok" and a "Cancel"
    * button. Called by createUserInterface ().
    *
    * @return   No description provided
    * @see      #createUserInterface
    */
   protected JPanel createButtonPanel()
   {
      JPanel buttonPanel = new JPanel();
      buttonPanel.setLayout (new FlowLayout (FlowLayout.RIGHT));

      okButton = new JButton ("Ok");
      setOkButton (okButton);
      okButton.addActionListener (
         new ActionListener()
         {
            public void actionPerformed (ActionEvent e)
            {
               okPressed();
            }
         });

      buttonPanel.add (okButton);

      cancelButton = new JButton ("Cancel");
      setCancelButton (cancelButton);
      cancelButton.addActionListener (
         new ActionListener()
         {
            public void actionPerformed (ActionEvent e)
            {
               cancelPressed();
            }
         });

      buttonPanel.add (cancelButton);

      getRootPane().setDefaultButton (okButton);

      return buttonPanel;
   } // createButtonPanel


   /**
    * Center the dialog in the middle of the screen.
    */
   protected void centerDialog()
   {
      Dimension screenSize = this.getToolkit().getScreenSize();
      Dimension size = this.getSize();

      int y =  (screenSize.height - size.height) / 2;
      int x =  (screenSize.width - size.width) / 2;

      setLocation (x, y);
   } // centerDialog


   //=================================== inner classes ================================

   /**
    * Window is closed without ok or cancel buttons, calls cancelPressed ().
    *
    * @author    $Author: schneider $
    * @version   $Revision: 1.11 $
    */
   protected class DialogClose extends WindowAdapter
   {
      /**
       * Calls cancelPressed ().
       *
       * @param e  No description provided
       */
      public void windowClosing (WindowEvent e)
      {
         cancelPressed();
      } // windowClosing

   } // DialogClose

}

/*
 * $Log: AbstractDialog.java,v $
 * Revision 1.11  2004/10/20 17:49:51  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
