/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.fsa.update;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import javax.swing.*;

import de.uni_paderborn.fujaba.fsa.FSAObject;


/**
 * add and handle listener between fsa and uml. updates from logic to fsa only
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.3 $
 */
public class LogicToFsaSizeUpdater extends LogicToFsaUpdater
{
   /**
    * Default Constructor
    */
   public LogicToFsaSizeUpdater()
   {
      super();
      super.setFsaAttrName ("preferredSize");
      super.setLogicAttrName (null);
   }


   /**
    * Constructor for class LogicToFsaSizeUpdater
    *
    * @param incr  No description provided
    */
   public LogicToFsaSizeUpdater (Object incr)
   {
      this();
      setLogicObject (incr);
   }


   /**
    * Sets the fsaAttrName attribute of the LogicToFsaSizeUpdater object
    *
    * @param name  The new fsaAttrName value
    * @return      No description provided
    */
   public boolean setFsaAttrName (String name)
   {
      if ("preferredSize".equals (name))
      {
         return false;
      }

      throw new UnsupportedOperationException ("Cannot change LogicToFsaSizeUpdater.fsaAttrName from \"preferredSize\"");
   }


   /**
    * @param data  No description provided
    * @return      always null
    */
   public Object translateLogicToFsa (Object data)
   {
      return null;
   }


   /**
    * Access method for an one to n association.
    */
   protected void addListener()
   {
      if (! (getLogicObject() == null || getFsaObject() == null || getFsaAttrName() == null))
      {
         if (getLogicListener() == null)
         {
            setLogicListener (new LogicToFsaUpdatePCLRevalidate (this, getFsaAttrName(),
               getFsaObject()));
         }
         ListenerHelper.get().addPropertyChangeListener (getLogicObject(), getLogicAttrName(), (PropertyChangeListener) getLogicListener());
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   protected void removeListener()
   {
      if (! (getLogicObject() == null || getFsaObject() == null || getFsaAttrName() == null))
      {
         if (getLogicListener() != null)
         {
            ListenerHelper.get().removePropertyChangeListener (getLogicObject(), getLogicAttrName(), (PropertyChangeListener) getLogicListener());
         }
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: schneider $
    * @version   $Revision: 1.3 $
    */
   private static class LogicToFsaUpdatePCLRevalidate extends LogicToFsaUpdatePCL
   {
      /**
       * Constructor for class LogicToFsaUpdatePCLRevalidate
       *
       * @param updater    No description provided
       * @param attrName   No description provided
       * @param component  No description provided
       */
      public LogicToFsaUpdatePCLRevalidate (AbstractUpdater updater, String attrName, FSAObject component)
      {
         super (updater, attrName, component);
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param event  No description provided
       */
      public void propertyChange (PropertyChangeEvent event)
      {
         super.propertyChange (event);
         JComponent component = getFsaObject().getJComponent();
         component.revalidate();
         component.repaint();
      }
   }
}

/*
 * $Log: LogicToFsaSizeUpdater.java,v $
 * Revision 1.3  2004/10/20 17:49:51  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
